/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.FunctionScope;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.IfStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Statement;
import org.netbeans.modules.php.editor.parser.astnodes.SwitchCase;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.HintErrorRule;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;

public class MethodRedeclarationHintError
extends HintErrorRule {
    private FileObject fileObject;
    private List<Hint> hints;
    private Set<Statement> conditionStatements = Collections.emptySet();

    @Override
    public void invoke(PHPRuleContext context, List<Hint> hints) {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        FileScope fileScope = context.fileScope;
        this.fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        if (fileScope != null && this.fileObject != null) {
            this.hints = hints;
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            CheckVisitor checkVisitor = new CheckVisitor();
            phpParseResult.getProgram().accept(checkVisitor);
            this.conditionStatements = checkVisitor.getConditionStatements();
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkTypeScopes(ModelUtils.getDeclaredClasses(fileScope));
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkTypeScopes(ModelUtils.getDeclaredInterfaces(fileScope));
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkTypeScopes(ModelUtils.getDeclaredTraits(fileScope));
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkTypeScopes(ModelUtils.getDeclaredEnums(fileScope));
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkDeclaredFunctions(ModelUtils.getDeclaredFunctions(fileScope));
        }
    }

    private void checkTypeScopes(Collection<? extends TypeScope> typeScopes) {
        for (TypeScope typeScope : typeScopes) {
            this.checkDeclaredFunctions(typeScope.getDeclaredMethods());
        }
    }

    private void checkDeclaredFunctions(Collection<? extends FunctionScope> declaredFunctions) {
        HashSet<String> declaredMethodNames = new HashSet<String>();
        for (FunctionScope functionScope : declaredFunctions) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (this.isInConditionStatament(functionScope)) continue;
            String fullyQualifiedFunctionName = functionScope.getFullyQualifiedName().toString();
            if (declaredMethodNames.contains(fullyQualifiedFunctionName)) {
                this.hints.add(new Hint((Rule)this, Bundle.MethodRedeclarationCustom(functionScope.getName()), this.fileObject, functionScope.getNameRange(), null, 500));
                continue;
            }
            declaredMethodNames.add(fullyQualifiedFunctionName);
        }
    }

    private boolean isInConditionStatament(FunctionScope functionScope) {
        boolean result = false;
        for (Statement statement : this.conditionStatements) {
            OffsetRange statementOffsetRange = new OffsetRange(statement.getStartOffset(), statement.getEndOffset());
            if (!statementOffsetRange.containsInclusive(functionScope.getOffset())) continue;
            result = true;
            break;
        }
        return result;
    }

    public String getDisplayName() {
        return Bundle.MethodRedeclarationHintDispName();
    }

    private static final class CheckVisitor
    extends DefaultVisitor {
        private final Set<Statement> conditionStatements = new HashSet<Statement>();

        private CheckVisitor() {
        }

        public Set<Statement> getConditionStatements() {
            return new HashSet<Statement>(this.conditionStatements);
        }

        @Override
        public void visit(IfStatement node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.addStatement(node.getTrueStatement());
            this.addStatement(node.getFalseStatement());
        }

        @Override
        public void visit(SwitchCase node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.addStatement(node);
        }

        private void addStatement(Statement statement) {
            if (statement != null) {
                this.conditionStatements.add(statement);
            }
        }
    }
}

