/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser.astnodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.php.editor.parser.astnodes.SingleUseStatementPart;
import org.netbeans.modules.php.editor.parser.astnodes.Statement;
import org.netbeans.modules.php.editor.parser.astnodes.UseStatementPart;
import org.netbeans.modules.php.editor.parser.astnodes.Visitor;

public class UseStatement
extends Statement {
    private final List<UseStatementPart> parts;
    private final Type type;

    public UseStatement(int start, int end, List parts, Type type) {
        super(start, end);
        if (parts == null || parts.isEmpty() || type == null) {
            throw new IllegalArgumentException();
        }
        this.parts = new ArrayList<UseStatementPart>(parts);
        this.type = type;
    }

    public UseStatement(int start, int end, List parts) {
        this(start, end, parts, Type.TYPE);
    }

    public UseStatement(int start, int end, SingleUseStatementPart[] parts, Type type) {
        this(start, end, Arrays.asList(parts), type);
    }

    public UseStatement(int start, int end, SingleUseStatementPart[] parts) {
        this(start, end, parts, Type.TYPE);
    }

    public List<UseStatementPart> getParts() {
        return Collections.unmodifiableList(this.parts);
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (UseStatementPart useStatementPart : this.parts) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(useStatementPart);
        }
        return "use " + this.type.toString() + " " + sb.toString();
    }

    public static enum Type {
        TYPE("TYPE"),
        CONST("CONST"),
        FUNCTION("FUNCTION");

        private final String type;

        private Type(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }
}

