/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser.astnodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Comment;
import org.netbeans.modules.php.editor.parser.astnodes.Statement;
import org.netbeans.modules.php.editor.parser.astnodes.Visitor;

public class Program
extends ASTNode {
    private final ArrayList<Statement> statements = new ArrayList();
    private final ArrayList<Comment> comments = new ArrayList();

    private Program(int start, int end, Statement[] statements, List<Comment> commentsList) {
        super(start, end);
        this.statements.addAll(Arrays.asList(statements));
        for (Comment comment : commentsList) {
            this.comments.add(comment);
        }
    }

    public Program(int start, int end, List<Statement> statements, List<Comment> commentsList) {
        this(start, end, statements.toArray(new Statement[0]), commentsList);
    }

    public List<Comment> getComments() {
        return this.comments;
    }

    public List<Statement> getStatements() {
        return this.statements;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        StringBuilder sbComments = new StringBuilder();
        for (Comment comment : this.getComments()) {
            sbComments.append(comment).append(" ");
        }
        StringBuilder sbStatements = new StringBuilder();
        for (Statement statement : this.getStatements()) {
            sbStatements.append(statement).append(" ");
        }
        return sbComments.toString() + " *** " + sbStatements.toString();
    }
}

