/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.util;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.db.mysql.impl.MySQLDatabaseServer;
import org.openide.windows.InputOutput;

public class ExecSupport {
    private static final Logger LOGGER = Logger.getLogger(ExecSupport.class.getName());
    private OutputCopier[] copyMakers;

    public InputOutput displayProcessOutputs(final Process child) throws IOException, InterruptedException {
        InputOutput io = MySQLDatabaseServer.getOutput();
        try {
            io.getOut().reset();
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, e.getLocalizedMessage(), e);
        }
        this.copyMakers = new OutputCopier[3];
        this.copyMakers[0] = new OutputCopier(new InputStreamReader(child.getInputStream()), (Writer)io.getOut(), true);
        this.copyMakers[0].start();
        this.copyMakers[1] = new OutputCopier(new InputStreamReader(child.getErrorStream()), (Writer)io.getErr(), true);
        this.copyMakers[1].start();
        this.copyMakers[2] = new OutputCopier(io.getIn(), new OutputStreamWriter(child.getOutputStream()), true);
        this.copyMakers[2].start();
        new Thread(this){
            final /* synthetic */ ExecSupport this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    child.waitFor();
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                }
                finally {
                    try {
                        this.this$0.copyMakers[0].interrupt();
                        this.this$0.copyMakers[1].interrupt();
                        this.this$0.copyMakers[2].interrupt();
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.INFO, null, e);
                    }
                }
            }
        }.start();
        return io;
    }

    public static class OutputCopier
    extends Thread {
        final Writer os;
        final Reader is;
        final boolean autoflush;
        private boolean done = false;

        public OutputCopier(Reader is, Writer os, boolean b) {
            this.os = os;
            this.is = is;
            this.autoflush = b;
        }

        @Override
        public void run() {
            char[] buff = new char[256];
            try {
                int read;
                while ((read = this.read(this.is, buff, 0, 256)) > 0) {
                    if (this.os == null) continue;
                    this.os.write(buff, 0, read);
                    if (!this.autoflush) continue;
                    this.os.flush();
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.FINE, null, ex);
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.FINE, null, e);
            }
        }

        @Override
        public void interrupt() {
            super.interrupt();
            this.done = true;
        }

        private int read(Reader is, char[] buff, int start, int count) throws InterruptedException, IOException {
            while (!is.ready() && !this.done) {
                OutputCopier.sleep(100L);
            }
            return is.read(buff, start, count);
        }
    }
}

