/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.debugging;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public final class ThreadObjects {
    private int lastId = 1;
    private final Map<Integer, int[]> threadObjectIds = new HashMap<Integer, int[]>();
    private final Map<Integer, Object> objects = new HashMap<Integer, Object>();

    ThreadObjects() {
    }

    public synchronized int addObject(int threadId, Object object) {
        int id = this.lastId++;
        this.objects.put(id, object);
        int[] objectIds = this.threadObjectIds.get(threadId);
        if (objectIds == null) {
            objectIds = new int[10];
        }
        int numIds = objectIds[0];
        if (++numIds >= objectIds.length) {
            int newSize = numIds + (numIds >> 1);
            objectIds = Arrays.copyOf(objectIds, newSize);
        }
        objectIds[numIds] = id;
        objectIds[0] = numIds;
        return id;
    }

    public synchronized Object getObject(int objectId) {
        return this.objects.get(objectId);
    }

    public synchronized void cleanObjects(int threadId) {
        int[] objectIds = this.threadObjectIds.remove(threadId);
        if (!this.threadObjectIds.isEmpty()) {
            for (int i = objectIds[0]; i > 0; --i) {
                this.objects.remove(objectIds[i]);
            }
        } else {
            this.objects.clear();
            this.lastId = 1;
        }
    }

    public synchronized void cleanAll() {
        this.threadObjectIds.clear();
        this.objects.clear();
        this.lastId = 1;
    }

    public synchronized int findObjectThread(int objectId) {
        for (Map.Entry<Integer, int[]> threadEntry : this.threadObjectIds.entrySet()) {
            int[] ids = threadEntry.getValue();
            if (Arrays.binarySearch(ids, 1, ids[0], objectId) < 0) continue;
            return threadEntry.getKey();
        }
        return -1;
    }
}

