/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.api.jstesting;

import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.openide.util.Parameters;

public final class TestRunInfo {
    private final SessionType sessionType;
    private final String testFile;

    private TestRunInfo(Builder builder) {
        assert (builder != null);
        assert (builder.sessionType != null);
        this.sessionType = builder.sessionType;
        this.testFile = builder.testFile;
    }

    public SessionType getSessionType() {
        return this.sessionType;
    }

    @CheckForNull
    public String getTestFile() {
        return this.testFile;
    }

    public String toString() {
        return "TestRunInfo{sessionType=" + (Object)((Object)this.sessionType) + ", testFile=" + this.testFile + '}';
    }

    public static final class Builder {
        SessionType sessionType = SessionType.TEST;
        String testFile;

        public Builder setSessionType(@NonNull SessionType sessionType) {
            this.sessionType = sessionType;
            return this;
        }

        public Builder setTestFile(@NullAllowed String testFile) {
            this.testFile = testFile;
            return this;
        }

        public TestRunInfo build() {
            Parameters.notNull((CharSequence)"sessionType", (Object)((Object)this.sessionType));
            return new TestRunInfo(this);
        }
    }

    public static enum SessionType {
        TEST,
        DEBUG;

    }
}

