/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.ui;

import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import org.netbeans.modules.search.BasicComposition;
import org.netbeans.modules.search.ContextView;
import org.netbeans.modules.search.FindDialogMemory;
import org.netbeans.modules.search.ResultModel;
import org.netbeans.modules.search.TextDetail;
import org.netbeans.modules.search.ui.BasicAbstractResultsPanel;
import org.netbeans.modules.search.ui.ResultsOutlineSupport;
import org.netbeans.modules.search.ui.UiUtils;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.RequestProcessor;

public class BasicSearchResultsPanel
extends BasicAbstractResultsPanel {
    private static final String PREVIEW_ICON = "org/netbeans/modules/search/res/preview.png";
    private final RequestProcessor.Task dividerSaveTask;
    private final JComponent rightComponent = this.createRightComponent();
    private final JSplitPane splitPane = new JSplitPane();
    private JToggleButton showPreviewButton;

    public BasicSearchResultsPanel(ResultModel resultModel, BasicComposition composition, boolean details, Node infoNode) {
        this(resultModel, composition, details, new ResultsOutlineSupport(false, details, resultModel, composition, infoNode));
    }

    BasicSearchResultsPanel(ResultModel resultModel, BasicComposition composition, boolean details, ResultsOutlineSupport resultsOutlineSupport) {
        super(resultModel, composition, details, resultsOutlineSupport);
        this.splitPane.setLeftComponent(this.createLeftComponent());
        this.getContentPanel().add(this.splitPane);
        this.dividerSaveTask = RequestProcessor.getDefault().create(() -> {
            if (this.splitPane.getRightComponent() != null) {
                FindDialogMemory.getDefault().setReplaceResultsDivider(this.splitPane.getDividerLocation());
            }
        });
        this.splitPane.addPropertyChangeListener("dividerLocation", e -> this.dividerSaveTask.schedule(1000));
        this.updatePreview();
    }

    private void updatePreview() {
        int location = FindDialogMemory.getDefault().getReplaceResultsDivider();
        FindDialogMemory.getDefault().setShowPreview(this.getClass().getName(), this.showPreviewButton.isSelected());
        if (this.showPreviewButton.isSelected()) {
            this.splitPane.setRightComponent(this.rightComponent);
            this.splitPane.setDividerLocation(Math.max(location, 250));
        } else {
            this.splitPane.setRightComponent(null);
        }
    }

    JComponent createLeftComponent() {
        return this.resultsOutlineSupport.getOutlineView();
    }

    JComponent createRightComponent() {
        return new ContextView(this.resultModel, this.getExplorerManager());
    }

    @Override
    protected void onDetailShift(Node next) {
        TextDetail textDetail = (TextDetail)next.getLookup().lookup(TextDetail.class);
        if (textDetail != null) {
            textDetail.showDetail(1);
        }
    }

    @Override
    protected void initButtons() {
        super.initButtons();
        this.showPreviewButton = new JToggleButton();
        this.showPreviewButton.setEnabled(true);
        this.showPreviewButton.setIcon(ImageUtilities.loadImageIcon((String)PREVIEW_ICON, (boolean)true));
        this.showPreviewButton.setToolTipText(UiUtils.getText("TEXT_BUTTON_SHOW_PREVIEW"));
        this.showPreviewButton.setSelected(FindDialogMemory.getDefault().isShowPreview(this.getClass().getName()));
        this.showPreviewButton.addActionListener(ev -> this.updatePreview());
        this.addButton(this.showPreviewButton);
    }
}

