/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.project.support;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.spi.java.queries.CompilerOptionsQueryImplementation;
import org.netbeans.spi.project.LookupMerger;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Pair;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

final class CompilerOptionsQueryMerger
implements LookupMerger<CompilerOptionsQueryImplementation> {
    CompilerOptionsQueryMerger() {
    }

    public Class<CompilerOptionsQueryImplementation> getMergeableClass() {
        return CompilerOptionsQueryImplementation.class;
    }

    public CompilerOptionsQueryImplementation merge(Lookup lookup) {
        return new CompilerOptionsQueryImpl(lookup);
    }

    private static final class CompilerOptionsQueryImpl
    implements CompilerOptionsQueryImplementation {
        private final Lookup lookup;
        private final Map<FileObject, Reference<ResultImpl>> cache;

        CompilerOptionsQueryImpl(@NonNull Lookup lookup) {
            Parameters.notNull((CharSequence)"lookup", (Object)lookup);
            this.lookup = lookup;
            this.cache = Collections.synchronizedMap(new WeakHashMap());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckForNull
        public CompilerOptionsQueryImplementation.Result getOptions(@NonNull FileObject file) {
            ResultImpl res;
            FileObject owner = Optional.ofNullable(ClassPath.getClassPath((FileObject)file, (String)"classpath/source")).map(cp -> cp.findOwnerRoot(file)).orElse(file);
            Reference<ResultImpl> resRef = this.cache.get(owner);
            if (resRef == null || (res = resRef.get()) == null) {
                res = new ResultImpl(owner, this.lookup);
                if (res.isEmpty()) {
                    return null;
                }
                Map<FileObject, Reference<ResultImpl>> map = this.cache;
                synchronized (map) {
                    ResultImpl prev;
                    Reference<ResultImpl> prevRef = this.cache.get(owner);
                    if (prevRef == null || (prev = prevRef.get()) == null) {
                        this.cache.put(owner, new WeakReference<ResultImpl>(res));
                    } else {
                        res = prev;
                    }
                }
            }
            return res;
        }

        private static final class ResultImpl
        extends CompilerOptionsQueryImplementation.Result
        implements LookupListener,
        ChangeListener {
            private final FileObject artifact;
            private final Lookup.Result<CompilerOptionsQueryImplementation> providers;
            private final ChangeSupport listeners;
            private volatile List<Pair<CompilerOptionsQueryImplementation.Result, ChangeListener>> currentResults;
            private volatile List<String> currentArgs;

            ResultImpl(@NonNull FileObject artifact, @NonNull Lookup lookup) {
                this.artifact = artifact;
                this.providers = lookup.lookupResult(CompilerOptionsQueryImplementation.class);
                this.listeners = new ChangeSupport((Object)this);
                this.providers.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, this.providers));
                this.checkProviders();
            }

            public List<? extends String> getArguments() {
                return this.currentArgs;
            }

            public void addChangeListener(@NonNull ChangeListener listener) {
                this.listeners.addChangeListener(listener);
            }

            public void removeChangeListener(@NonNull ChangeListener listener) {
                this.listeners.removeChangeListener(listener);
            }

            public void resultChanged(LookupEvent ev) {
                this.update();
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                this.update();
            }

            boolean isEmpty() {
                List<Pair<CompilerOptionsQueryImplementation.Result, ChangeListener>> l = this.currentResults;
                return l == null ? true : l.isEmpty();
            }

            private void update() {
                Runnable resetAction = () -> {
                    this.checkProviders();
                    this.listeners.fireChange();
                };
                if (ProjectManager.mutex().isWriteAccess()) {
                    ProjectManager.mutex().postReadRequest(resetAction);
                } else {
                    resetAction.run();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void checkProviders() {
                ResultImpl resultImpl = this;
                synchronized (resultImpl) {
                    if (this.currentResults != null) {
                        for (Pair<CompilerOptionsQueryImplementation.Result, ChangeListener> res : this.currentResults) {
                            ((CompilerOptionsQueryImplementation.Result)res.first()).removeChangeListener((ChangeListener)res.second());
                        }
                        this.currentResults = null;
                    }
                }
                List newResults = this.providers.allInstances().stream().map(p -> p.getOptions(this.artifact)).filter(r -> r != null).map(r -> {
                    ChangeListener cl = WeakListeners.change((ChangeListener)this, (Object)r);
                    r.addChangeListener(cl);
                    return Pair.of((Object)r, (Object)cl);
                }).collect(Collectors.toList());
                List newArgs = newResults.stream().flatMap(p -> ((CompilerOptionsQueryImplementation.Result)p.first()).getArguments().stream()).collect(Collectors.toList());
                ResultImpl resultImpl2 = this;
                synchronized (resultImpl2) {
                    this.currentResults = newResults;
                    this.currentArgs = Collections.unmodifiableList(newArgs);
                }
            }
        }
    }
}

