/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.sites;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.web.clientproject.sites.Bundle;
import org.netbeans.modules.web.clientproject.sites.SiteZip;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.NbBundle;

public class SiteZipPanel
extends JPanel
implements DocumentListener {
    private SiteZip.Customizer cust;
    private JComboBox archiveComboBox;
    private JLabel archiveLabel;
    private JButton browseButton;
    private JLabel infoLabel;

    public SiteZipPanel(SiteZip.Customizer cust) {
        this.cust = cust;
        this.initComponents();
        ArrayList<String> templates = new ArrayList<String>(SiteZip.getUsedTemplates());
        if (templates.size() > 0 && ((String)templates.get(0)).length() > 0) {
            templates.add(0, "");
        }
        this.archiveComboBox.setModel(new DefaultComboBoxModel<String>(templates.toArray(new String[0])));
        ((JTextField)this.archiveComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(this);
    }

    private void initComponents() {
        this.archiveLabel = new JLabel();
        this.archiveComboBox = new JComboBox();
        this.browseButton = new JButton();
        this.infoLabel = new JLabel();
        this.archiveLabel.setLabelFor(this.archiveComboBox);
        Mnemonics.setLocalizedText((JLabel)this.archiveLabel, (String)NbBundle.getMessage(SiteZipPanel.class, (String)"SiteZipPanel.archiveLabel.text"));
        this.archiveComboBox.setEditable(true);
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(SiteZipPanel.class, (String)"SiteZipPanel.browseButton.text"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SiteZipPanel.this.browseButtonActionPerformed(evt);
            }
        });
        this.infoLabel.setFont(this.infoLabel.getFont().deriveFont((float)this.infoLabel.getFont().getSize() - 1.0f));
        Mnemonics.setLocalizedText((JLabel)this.infoLabel, (String)NbBundle.getMessage(SiteZipPanel.class, (String)"SiteZipPanel.infoLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.archiveLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.archiveComboBox, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton)).addComponent(this.infoLabel, -2, 0, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.archiveLabel).addComponent(this.browseButton).addComponent(this.archiveComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.infoLabel, -2, -1, -2)));
    }

    public String getTemplate() {
        return ((JTextField)this.archiveComboBox.getEditor().getEditorComponent()).getText();
    }

    public void setTemplate(String template) {
        ((JTextField)this.archiveComboBox.getEditor().getEditorComponent()).setText(template);
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        File file = new FileChooserBuilder(SiteZipPanel.class.getName()).setTitle(Bundle.LBL_SiteZipPanel_Title()).setFilesOnly(true).setApproveText(Bundle.LBL_SiteZipPanel_Select()).showOpenDialog();
        if (file != null) {
            ((JTextField)this.archiveComboBox.getEditor().getEditorComponent()).setText(file.getAbsolutePath());
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.cust.fireChange();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.cust.fireChange();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.cust.fireChange();
    }
}

