/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator;

final class Attr
extends Enum<Attr> {
    public static final /* enum */ Attr BGCOLOR = new Attr(9);
    public static final /* enum */ Attr FGCOLOR = new Attr(9);
    public static final /* enum */ Attr HIDDEN = new Attr(1);
    public static final /* enum */ Attr REVERSE = new Attr(1);
    public static final /* enum */ Attr BLINK = new Attr(1);
    public static final /* enum */ Attr UNDERSCORE = new Attr(1);
    public static final /* enum */ Attr BRIGHT = new Attr(1);
    public static final /* enum */ Attr DIM = new Attr(1);
    public static final /* enum */ Attr ACTIVE = new Attr(1);
    public static final /* enum */ Attr UNSET = new Attr(30, 1);
    public static final int ALT;
    public static final int PAL_ANSI = 0;
    public static final int PAL_BRIGHT = 8;
    public static final int PAL_RGB = 16;
    public static final int PAL_GREY = 232;
    public static final int PAL_FG = 256;
    public static final int PAL_BG = 257;
    public static final int PAL_BOLD = 258;
    public static final int PAL_SIZE = 259;
    private final int width;
    private final int fmask;
    private int offset;
    private int wmask;
    private static final Info[] map;
    private static final /* synthetic */ Attr[] $VALUES;

    public static Attr[] values() {
        return (Attr[])$VALUES.clone();
    }

    public static Attr valueOf(String name) {
        return Enum.valueOf(Attr.class, name);
    }

    private Attr(int offset, int width) {
        this.offset = offset;
        this.width = width;
        this.fmask = (1 << width) - 1;
    }

    private Attr(int width) {
        this.offset = -1;
        this.width = width;
        this.fmask = (1 << width) - 1;
    }

    private void init() {
        if (this.offset == -1) {
            if (this.ordinal() == 0) {
                this.offset = 0;
            } else {
                Attr prev = Attr.values()[this.ordinal() - 1];
                this.offset = prev.offset + prev.width;
            }
        }
        this.wmask = this.fmask << this.offset;
    }

    public String toString() {
        return String.format("%d %10s(%2d, %2d, 0x%02x %8s, 0x%08x %32s)", this.ordinal(), this.name(), this.offset, this.width, this.fmask, Integer.toBinaryString(this.fmask), this.wmask, Integer.toBinaryString(this.wmask));
    }

    public static String toString(int attr) {
        return String.format("%32s", Integer.toBinaryString(attr)).replace(" ", "0");
    }

    public final int get(int attr) {
        return attr >> this.offset & this.fmask;
    }

    public final int set(int attr, int value) {
        return attr & ~this.wmask | (value & this.fmask) << this.offset;
    }

    public final int set(int attr) {
        assert (this.width == 1);
        return attr | 1 << this.offset;
    }

    public final int clear(int attr) {
        return attr & ~this.wmask;
    }

    public final boolean isSet(int attr) {
        return (attr & this.wmask) != 0;
    }

    public static int foregroundColor(int attr) {
        int cx = FGCOLOR.get(attr);
        if (cx == 0) {
            return 256;
        }
        return cx - 1;
    }

    public static int backgroundColor(int attr) {
        int cx = BGCOLOR.get(attr);
        if (cx == 0) {
            return 257;
        }
        return cx - 1;
    }

    public static int setAttribute(int attr, int value) {
        switch (value) {
            case 0: {
                attr = 0;
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                attr = DIM.clear(attr);
                attr = BRIGHT.set(attr);
                break;
            }
            case 2: {
                attr = BRIGHT.clear(attr);
                attr = DIM.set(attr);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                attr = UNDERSCORE.set(attr);
                break;
            }
            case 7: {
                attr = REVERSE.set(attr);
                break;
            }
            case 8: {
                attr = HIDDEN.set(attr);
                break;
            }
            case 9: {
                attr = ACTIVE.set(attr);
                break;
            }
            case 22: 
            case 25: {
                attr = DIM.clear(attr);
                attr = BRIGHT.clear(attr);
                break;
            }
            case 24: {
                attr = UNDERSCORE.clear(attr);
                break;
            }
            case 27: {
                attr = REVERSE.clear(attr);
                break;
            }
            case 28: {
                attr = HIDDEN.clear(attr);
                break;
            }
            case 39: {
                attr = FGCOLOR.clear(attr);
                break;
            }
            case 49: {
                attr = BGCOLOR.clear(attr);
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                try {
                    Info i = map[value];
                    if (i == null) break;
                    attr = i.field.set(attr, i.pindex + 1);
                }
                catch (ArrayStoreException x) {}
                break;
            }
        }
        return attr;
    }

    public static int unsetAttribute(int attr, int value) {
        switch (value) {
            case 0: {
                attr = 0;
                break;
            }
            case 1: 
            case 5: {
                attr = BRIGHT.clear(attr);
                break;
            }
            case 2: {
                attr = DIM.clear(attr);
                break;
            }
            case 4: {
                attr = UNDERSCORE.clear(attr);
                break;
            }
            case 7: {
                attr = REVERSE.clear(attr);
                break;
            }
            case 8: {
                attr = HIDDEN.clear(attr);
                break;
            }
            case 9: {
                attr = ACTIVE.clear(attr);
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                try {
                    Info i = map[value];
                    if (i == null) break;
                    attr = i.field.clear(attr);
                }
                catch (ArrayStoreException x) {}
                break;
            }
        }
        return attr;
    }

    public static final int rendition_to_pindex(int rendition) {
        try {
            Info i = map[rendition];
            if (i == null) {
                return -1;
            }
            return i.pindex;
        }
        catch (ArrayIndexOutOfBoundsException x) {
            return -1;
        }
    }

    private static /* synthetic */ Attr[] $values() {
        return new Attr[]{BGCOLOR, FGCOLOR, HIDDEN, REVERSE, BLINK, UNDERSCORE, BRIGHT, DIM, ACTIVE, UNSET};
    }

    static {
        $VALUES = Attr.$values();
        for (Attr a : Attr.values()) {
            a.init();
        }
        ALT = Attr.BGCOLOR.wmask | Attr.FGCOLOR.wmask | Attr.REVERSE.wmask | Attr.ACTIVE.wmask;
        map = new Info[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, new Info(30, FGCOLOR, 0), new Info(31, FGCOLOR, 1), new Info(32, FGCOLOR, 2), new Info(33, FGCOLOR, 3), new Info(34, FGCOLOR, 4), new Info(35, FGCOLOR, 5), new Info(36, FGCOLOR, 6), new Info(37, FGCOLOR, 7), null, new Info(39, FGCOLOR, 256), new Info(40, BGCOLOR, 0), new Info(41, BGCOLOR, 1), new Info(42, BGCOLOR, 2), new Info(43, BGCOLOR, 3), new Info(44, BGCOLOR, 4), new Info(45, BGCOLOR, 5), new Info(46, BGCOLOR, 6), new Info(47, BGCOLOR, 7), null, new Info(49, BGCOLOR, 257), new Info(50, FGCOLOR, 8), new Info(51, FGCOLOR, 9), new Info(52, FGCOLOR, 10), new Info(53, FGCOLOR, 11), new Info(54, FGCOLOR, 12), new Info(55, FGCOLOR, 13), new Info(56, FGCOLOR, 14), new Info(57, FGCOLOR, 15), new Info(58, BGCOLOR, 8), new Info(59, BGCOLOR, 9), new Info(60, BGCOLOR, 10), new Info(61, BGCOLOR, 11), new Info(62, BGCOLOR, 12), new Info(63, BGCOLOR, 13), new Info(64, BGCOLOR, 14), new Info(65, BGCOLOR, 15), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, new Info(90, FGCOLOR, 8), new Info(91, FGCOLOR, 9), new Info(92, FGCOLOR, 10), new Info(93, FGCOLOR, 11), new Info(94, FGCOLOR, 12), new Info(95, FGCOLOR, 13), new Info(96, FGCOLOR, 14), new Info(97, FGCOLOR, 15), null, null, new Info(100, BGCOLOR, 8), new Info(101, BGCOLOR, 9), new Info(102, BGCOLOR, 10), new Info(103, BGCOLOR, 11), new Info(104, BGCOLOR, 12), new Info(105, BGCOLOR, 13), new Info(106, BGCOLOR, 14), new Info(107, BGCOLOR, 15)};
        for (int mx = 0; mx < map.length; ++mx) {
            assert (map[mx] == null || Attr.map[mx].rendition == mx);
        }
    }

    private static final class Info {
        public final int rendition;
        public final Attr field;
        public final int pindex;

        Info(int rendition, Attr field, int pindex) {
            this.rendition = rendition;
            this.field = field;
            this.pindex = pindex;
        }
    }
}

