/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.vcs;

import java.util.EnumMap;
import java.util.Map;
import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;

public class VCSQueueHooksConfig {
    private final HookType type;
    private static Map<HookType, VCSQueueHooksConfig> instances = new EnumMap<HookType, VCSQueueHooksConfig>(HookType.class);
    private static final String HOOK_PREFIX = "vcsqueuehook.";
    private static final String HOOK_AFTER_REFRESH = "_after_refresh";
    private static final String HOOK_QFINISH_ = "_qfinish_hook_";
    private static final String DELIMITER = "<=>###<=>";

    private VCSQueueHooksConfig(HookType type) {
        this.type = type;
    }

    static VCSQueueHooksConfig getInstance(HookType type) {
        VCSQueueHooksConfig instance = instances.get((Object)type);
        if (instance == null) {
            instance = new VCSQueueHooksConfig(type);
            instances.put(type, instance);
        }
        return instance;
    }

    Preferences getPreferences() {
        return NbPreferences.forModule(VCSQueueHooksConfig.class);
    }

    boolean getAfterRefresh() {
        return this.getPreferences().getBoolean(HOOK_PREFIX + (Object)((Object)this.type) + HOOK_AFTER_REFRESH, false);
    }

    void setAfterRefresh(boolean bl) {
        this.getPreferences().putBoolean(HOOK_PREFIX + (Object)((Object)this.type) + HOOK_AFTER_REFRESH, bl);
    }

    void setFinishPatchAction(String patchId, FinishPatchOperation finishPatchAction) {
        this.getPreferences().put(HOOK_PREFIX + (Object)((Object)this.type) + HOOK_QFINISH_ + patchId, finishPatchAction.toString());
    }

    void clearFinishPatchAction(String patchId) {
        this.getPreferences().remove(HOOK_PREFIX + (Object)((Object)this.type) + HOOK_QFINISH_ + patchId);
    }

    FinishPatchOperation popFinishPatchAction(String patchId, boolean clear) {
        String value = this.getPreferences().get(HOOK_PREFIX + (Object)((Object)this.type) + HOOK_QFINISH_ + patchId, null);
        if (value == null) {
            return null;
        }
        String[] values = value.split(DELIMITER);
        if (clear) {
            this.getPreferences().remove(HOOK_PREFIX + (Object)((Object)this.type) + HOOK_QFINISH_ + patchId);
        }
        return values.length < 5 ? null : new FinishPatchOperation(values[0], values[4].isEmpty() ? null : values[4], "1".equals(values[1]), "1".equals(values[2]), "1".equals(values[3]));
    }

    static enum HookType {
        HG("hg");

        private String type;

        private HookType(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }

    static class FinishPatchOperation {
        private final String issueID;
        private final String msg;
        private final boolean close;
        private final boolean addInfo;
        private final boolean afterPush;

        public FinishPatchOperation(String issueID, String msg, boolean close, boolean addInfo, boolean afterPush) {
            this.issueID = issueID;
            this.msg = msg;
            this.close = close;
            this.addInfo = addInfo;
            this.afterPush = afterPush;
        }

        public String getIssueID() {
            return this.issueID;
        }

        public boolean isClose() {
            return this.close;
        }

        public boolean isAddInfo() {
            return this.addInfo;
        }

        public boolean isAfterPush() {
            return this.afterPush;
        }

        public String getMsg() {
            return this.msg;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            String message = this.getMsg();
            sb.append(this.getIssueID());
            sb.append(VCSQueueHooksConfig.DELIMITER);
            sb.append(this.isClose() ? "1" : "0");
            sb.append(VCSQueueHooksConfig.DELIMITER);
            sb.append(this.isAddInfo() ? "1" : "0");
            sb.append(VCSQueueHooksConfig.DELIMITER);
            sb.append(this.isAfterPush() ? "1" : "0");
            sb.append(VCSQueueHooksConfig.DELIMITER);
            sb.append(message != null ? message.trim() : "");
            return sb.toString();
        }
    }
}

