/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.vcs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JPanel;
import org.netbeans.modules.bugtracking.vcs.HookImpl;
import org.netbeans.modules.bugtracking.vcs.HookPanel;
import org.netbeans.modules.bugtracking.vcs.VCSHooksConfig;
import org.netbeans.modules.versioning.hooks.SvnHook;
import org.netbeans.modules.versioning.hooks.SvnHookContext;
import org.openide.util.NbBundle;

public class SvnHookImpl
extends SvnHook {
    private static final String[] SUPPORTED_ISSUE_INFO_VARIABLES = new String[]{"id", "summary"};
    private static final String[] SUPPORTED_REVISION_VARIABLES = new String[]{"revision", "author", "date", "message"};
    private final String name = NbBundle.getMessage(SvnHookImpl.class, (String)"LBL_VCSHook");
    private final HookImpl delegate;

    public SvnHookImpl() {
        VCSHooksConfig config = VCSHooksConfig.getInstance(VCSHooksConfig.HookType.SVN);
        this.delegate = new HookImpl(config, SUPPORTED_ISSUE_INFO_VARIABLES, SUPPORTED_REVISION_VARIABLES);
    }

    public SvnHookContext beforeCommit(SvnHookContext context) throws IOException {
        String msg = this.delegate.beforeCommit(context.getFiles(), context.getMessage());
        return msg != null ? new SvnHookContext(context.getFiles(), msg, new ArrayList()) : null;
    }

    public void afterCommit(SvnHookContext context) {
        List logEntries = context.getLogEntries();
        if (logEntries == null || logEntries.isEmpty()) {
            return;
        }
        SvnHookContext.LogEntry logEntry = (SvnHookContext.LogEntry)logEntries.get(0);
        String author = logEntry.getAuthor();
        long revision = logEntry.getRevision();
        Date date = logEntry.getDate();
        String message = context.getMessage();
        this.delegate.afterCommit(context.getFiles(), author, Long.toString(revision), date, message, "SVN", false);
    }

    public JPanel createComponent(SvnHookContext context) {
        HookPanel panel = this.delegate.createComponent(context.getFiles(), true);
        panel.commitRadioButton.setVisible(false);
        panel.pushRadioButton.setVisible(false);
        return panel;
    }

    public String getDisplayName() {
        return this.name;
    }
}

