/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.utils;

import java.util.Objects;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerInstance;
import org.netbeans.modules.maven.j2ee.utils.Bundle;
import org.netbeans.modules.maven.j2ee.utils.MavenProjectSupport;

public final class Server
implements Comparable<Server> {
    public static final Server NO_SERVER_SELECTED = new Server();
    private final String serverInstanceId;
    private final String serverID;

    private Server() {
        this("DEV-NULL", "DEV-NULL");
    }

    public Server(String serverInstanceId) {
        this(serverInstanceId, MavenProjectSupport.obtainServerID(serverInstanceId));
    }

    public Server(String serverInstanceID, String serverID) {
        this.serverInstanceId = serverInstanceID;
        this.serverID = serverID;
    }

    public String getServerInstanceID() {
        return this.serverInstanceId;
    }

    public String getServerID() {
        return this.serverID;
    }

    @Override
    public int compareTo(Server wrapper) {
        if ("DEV-NULL".equals(this.serverInstanceId)) {
            return 1;
        }
        if (this.serverInstanceId.contains("gf") && !wrapper.serverInstanceId.contains("gf")) {
            return -1;
        }
        if (!this.serverInstanceId.contains("gf") && wrapper.serverInstanceId.contains("gf")) {
            return 1;
        }
        String displayName = this.toString();
        String displayName2 = wrapper != null ? wrapper.toString() : "";
        displayName = displayName != null ? displayName : "";
        displayName2 = displayName2 != null ? displayName2 : "";
        return displayName.compareTo(displayName2);
    }

    public String toString() {
        if (this.serverInstanceId == null || "DEV-NULL".equals(this.serverInstanceId)) {
            return Bundle.MSG_No_Server();
        }
        ServerInstance si = Deployment.getDefault().getServerInstance(this.serverInstanceId);
        if (si != null) {
            try {
                return si.getDisplayName();
            }
            catch (InstanceRemovedException ex) {
                return Bundle.MSG_Invalid_Server();
            }
        }
        return this.serverInstanceId;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Server other = (Server)obj;
        if (!Objects.equals(this.serverInstanceId, other.serverInstanceId)) {
            return false;
        }
        return Objects.equals(this.serverID, other.serverID);
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + Objects.hashCode(this.serverInstanceId);
        hash = 59 * hash + Objects.hashCode(this.serverID);
        return hash;
    }
}

