/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.netbeans.api.xml.services.UserCatalog;
import org.netbeans.modules.xml.util.AbstractUtil;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.windows.WindowManager;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Util
extends AbstractUtil {
    private static final Logger LOG = Logger.getLogger(Util.class.getName());
    private static final String PREFIX_SCHEMA = "SCHEMA:";
    private static final String PROTOCOL_FILE = "file:";
    private static File lastDirectory;
    public static final Util THIS;
    public static final String NO_NAME_SPACE = "NO_NAME_SPACE";
    private static Map namespaces;
    private static Map prefixes;

    private Util() {
    }

    public static File selectSchemaFile(final String extensions) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                StringTokenizer token = new StringTokenizer(extensions, " ");
                while (token.hasMoreElements()) {
                    if (!f.getName().endsWith(token.nextToken())) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String getDescription() {
                return THIS.getString(Util.class, "PROP_schema_mask");
            }
        });
        if (lastDirectory != null) {
            chooser.setCurrentDirectory(lastDirectory);
        }
        chooser.setDialogTitle(THIS.getString(Util.class, "PROP_schema_dialog_name"));
        while (chooser.showDialog(WindowManager.getDefault().getMainWindow(), THIS.getString(Util.class, "PROP_schema_select_button")) == 0) {
            File f = chooser.getSelectedFile();
            lastDirectory = chooser.getCurrentDirectory();
            if (f != null && f.isFile()) {
                StringTokenizer token = new StringTokenizer(extensions, " ");
                while (token.hasMoreElements()) {
                    if (!f.getName().endsWith(token.nextToken())) continue;
                    return f;
                }
            }
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)THIS.getString(Util.class, "MSG_inValidFile"), 2));
        }
        return null;
    }

    public static String[] getKnownDTDPublicIDs() {
        UserCatalog catalog = UserCatalog.getDefault();
        if (catalog != null) {
            TreeSet<String> idSet = new TreeSet<String>();
            Iterator it = catalog.getPublicIDs();
            while (it.hasNext()) {
                String next = (String)it.next();
                String nextLowerCase = next.toLowerCase();
                if (nextLowerCase.startsWith("schema:") || nextLowerCase.endsWith(".xsd")) continue;
                idSet.add(next);
            }
            return idSet.toArray(new String[0]);
        }
        THIS.debug("Note SourceResolver not found!");
        return new String[0];
    }

    public static String getDocumentType() {
        return "xsd";
    }

    public static Map getFiles2NSMappingInProj(File rootFile, String docType) {
        List fileList = Util.getFilesWithExtension(rootFile, docType, new ArrayList());
        HashMap<FileObject, String> result = new HashMap<FileObject, String>();
        String xpathQuery = "//xsd:schema/@targetNamespace";
        for (int i = 0; i < fileList.size(); ++i) {
            File file = (File)fileList.get(i);
            if (Thread.currentThread().isInterrupted()) break;
            List targetNSList = null;
            try {
                targetNSList = Util.runXPathQuery(file, xpathQuery);
                String targetNS = null;
                FileObject fobj = FileUtil.toFileObject((File)file);
                targetNS = targetNSList.size() > 0 ? (String)targetNSList.get(0) : NO_NAME_SPACE;
                if (targetNS == NO_NAME_SPACE) continue;
                result.put(fobj, targetNS);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static FileObject toFileObject(InputSource src) {
        try {
            String sysId = src.getSystemId();
            return FileUtil.toFileObject((File)new File(new URI(sysId)));
        }
        catch (URISyntaxException ex) {
            LOG.log(Level.WARNING, "File URI malformed", ex);
            return null;
        }
    }

    public static Map<InputSource, String> getCatalogSchemaNSMappings() {
        UserCatalog cat = UserCatalog.getDefault();
        Iterator it = cat.getPublicIDs();
        HashMap<InputSource, String> result = new HashMap<InputSource, String>();
        while (it.hasNext()) {
            String uri = (String)it.next();
            if (!uri.startsWith(PREFIX_SCHEMA)) continue;
            uri = uri.substring(PREFIX_SCHEMA.length());
            try {
                FileObject fo;
                String sysId;
                InputSource src = cat.getEntityResolver().resolveEntity(null, uri);
                if (src == null || !(sysId = src.getSystemId()).startsWith(PROTOCOL_FILE) || (fo = Util.toFileObject(src)) == null) continue;
                result.put(src, uri);
            }
            catch (SAXException ex) {
                LOG.log(Level.FINE, "Resolution failed", ex);
            }
            catch (IOException ex) {
                LOG.log(Level.FINE, "Resolution failed", ex);
            }
        }
        return result;
    }

    public static List getFilesWithExtension(File startFile, String fileExtension, List curList) {
        File[] children;
        String extn;
        int index;
        if (Thread.currentThread().isInterrupted()) {
            return curList;
        }
        if (curList == null) {
            curList = new ArrayList<File>();
        }
        if (startFile.isFile() && (index = startFile.getName().lastIndexOf(".")) != -1 && (extn = startFile.getName().substring(index + 1)) != null && extn.equalsIgnoreCase(fileExtension)) {
            curList.add(startFile);
        }
        if (startFile.isDirectory() && (children = startFile.listFiles()) != null) {
            for (int i = 0; i < children.length; ++i) {
                File child = children[i];
                Util.getFilesWithExtension(child, fileExtension, curList);
            }
        }
        return curList;
    }

    public static List runXPathQuery(File parsedFile, String xpathExpr) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(Util.getNamespaceContext());
        InputSource inputSource = new InputSource(new FileInputStream(parsedFile));
        NodeList nodes = (NodeList)xpath.evaluate(xpathExpr, inputSource, XPathConstants.NODESET);
        if (nodes != null && nodes.getLength() > 0) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                result.add(node.getNodeValue());
            }
        }
        return result;
    }

    public static String getRelativePath(File file, File relativeTo) throws IOException {
        int i;
        File origFile = file;
        File origRelativeTo = relativeTo;
        ArrayList<File> filePathStack = new ArrayList<File>();
        String origFilePath = file.getAbsolutePath();
        String relativeFile = relativeTo.getAbsolutePath();
        StringTokenizer str = new StringTokenizer(origFilePath, ":");
        String drive = null;
        String rdrive = null;
        if (str.hasMoreTokens()) {
            drive = str.nextToken();
        }
        if ((str = new StringTokenizer(relativeFile, ":")).hasMoreTokens()) {
            rdrive = str.nextToken();
        }
        if (drive != null && rdrive != null && !drive.equals(rdrive)) {
            return file.toURI().toString();
        }
        ArrayList<File> relativeToPathStack = new ArrayList<File>();
        for (file = file.getCanonicalFile(); file != null; file = file.getParentFile()) {
            filePathStack.add(0, file);
        }
        for (relativeTo = relativeTo.getCanonicalFile(); relativeTo != null; relativeTo = relativeTo.getParentFile()) {
            relativeToPathStack.add(0, relativeTo);
        }
        int count = 0;
        file = (File)filePathStack.get(count);
        relativeTo = (File)relativeToPathStack.get(count);
        while (count < filePathStack.size() - 1 && count < relativeToPathStack.size() - 1 && file.equals(relativeTo)) {
            file = (File)filePathStack.get(++count);
            relativeTo = (File)relativeToPathStack.get(count);
        }
        if (file.equals(relativeTo)) {
            ++count;
        }
        StringBuffer relString = new StringBuffer();
        for (i = count; i < relativeToPathStack.size(); ++i) {
            relString.append("../");
        }
        for (i = count; i < filePathStack.size() - 1; ++i) {
            relString.append(((File)filePathStack.get(i)).getName() + "/");
        }
        relString.append(((File)filePathStack.get(filePathStack.size() - 1)).getName());
        return relString.toString();
    }

    private static NamespaceContext getNamespaceContext() {
        namespaces.put("xsd", "http://www.w3.org/2001/XMLSchema");
        prefixes.put("http://www.w3.org/2001/XMLSchema", "xsd");
        return new HashNamespaceResolver(namespaces, prefixes);
    }

    static {
        THIS = new Util();
        namespaces = new HashMap();
        prefixes = new HashMap();
    }

    public static final class HashNamespaceResolver
    implements NamespaceContext {
        private Map prefixes;
        private Map namespaces;

        public HashNamespaceResolver(Map nsTable) {
            this.namespaces = nsTable;
            this.prefixes = new HashMap();
            Set set = this.namespaces.entrySet();
            for (Map.Entry e : set) {
                this.prefixes.put(e.getValue(), e.getKey());
            }
        }

        public HashNamespaceResolver(Map namespaces, Map prefixes) {
            this.namespaces = namespaces;
            this.prefixes = prefixes;
        }

        public Iterator getPrefixes(String namespaceURI) {
            return Collections.singletonList(this.getPrefix(namespaceURI)).iterator();
        }

        @Override
        public String getPrefix(String namespaceURI) {
            return (String)this.prefixes.get(namespaceURI);
        }

        @Override
        public String getNamespaceURI(String prefix) {
            return (String)this.namespaces.get(prefix);
        }
    }
}

