/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.tasklist.filter.TaskFilter;
import org.netbeans.modules.tasklist.impl.Accessor;
import org.netbeans.modules.tasklist.impl.TaskComparator;
import org.netbeans.modules.tasklist.trampoline.TaskGroup;
import org.netbeans.spi.tasklist.FileTaskScanner;
import org.netbeans.spi.tasklist.PushTaskScanner;
import org.netbeans.spi.tasklist.Task;
import org.openide.filesystems.FileObject;
import org.openide.util.WeakSet;

public class TaskList {
    private TreeSet<Task> sortedTasks;
    private ArrayList<Task> tasksList;
    private Map<PushTaskScanner, List<Task>> pushScanner2tasks = new HashMap<PushTaskScanner, List<Task>>(10);
    private Map<FileTaskScanner, List<Task>> fileScanner2tasks = new HashMap<FileTaskScanner, List<Task>>(10);
    private Map<TaskGroup, List<Task>> group2tasks = new HashMap<TaskGroup, List<Task>>(10);
    private final WeakSet<Listener> listeners = new WeakSet(2);
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private Comparator<Task> comparator;

    public TaskList() {
        this.sortedTasks = new TreeSet<Task>(this.getComparator());
    }

    void setTasks(PushTaskScanner scanner, FileObject resource, List<? extends Task> tasks, TaskFilter filter) throws IOException {
        this.lock.writeLock().lock();
        List<Task> removed = this.clear(scanner, resource);
        HashSet<Task> tasksToAdd = null;
        int currentCount = this.countTasks(scanner);
        for (Task task : tasks) {
            TaskGroup group;
            List<Task> groupTasks;
            List<Task> scannerTasks;
            if (!filter.accept(task) || filter.isTaskCountLimitReached(currentCount)) continue;
            ++currentCount;
            if (this.sortedTasks.contains(task) || tasksToAdd != null && tasksToAdd.contains(task)) continue;
            if (null == tasksToAdd) {
                tasksToAdd = new HashSet<Task>(tasks.size());
            }
            if (null == (scannerTasks = this.pushScanner2tasks.get(scanner))) {
                scannerTasks = new ArrayList<Task>();
                this.pushScanner2tasks.put(scanner, scannerTasks);
            }
            if (null == (groupTasks = this.group2tasks.get(group = Accessor.getGroup(task)))) {
                groupTasks = new ArrayList<Task>();
                this.group2tasks.put(group, groupTasks);
            }
            tasksToAdd.add(task);
            scannerTasks.add(task);
            groupTasks.add(task);
        }
        if (null != tasksToAdd) {
            this.addTasks(tasksToAdd);
        }
        this.lock.writeLock().unlock();
        if (null != removed && !removed.isEmpty()) {
            this.fireTasksRemoved(removed);
        }
        if (null != tasksToAdd && !tasksToAdd.isEmpty()) {
            this.fireTasksAdded(new ArrayList<Task>(tasksToAdd));
        }
    }

    void clear(PushTaskScanner scanner) {
        this.lock.writeLock().lock();
        List<Task> toRemove = this.pushScanner2tasks.get(scanner);
        this.pushScanner2tasks.remove(scanner);
        if (null != toRemove) {
            for (List<Task> groupTasks : this.group2tasks.values()) {
                groupTasks.removeAll(toRemove);
            }
            this.removeTasks(toRemove);
        }
        this.lock.writeLock().unlock();
        if (null != toRemove && !toRemove.isEmpty()) {
            this.fireTasksRemoved(toRemove);
        }
    }

    private int countTasks(PushTaskScanner scanner) {
        List<Task> tasks = this.pushScanner2tasks.get(scanner);
        return null == tasks ? 0 : tasks.size();
    }

    private List<Task> clear(PushTaskScanner scanner, FileObject resource) {
        HashSet<Task> toRemove = null;
        List<Task> tasks = this.pushScanner2tasks.get(scanner);
        if (null != tasks) {
            if (null == resource) {
                toRemove = new HashSet<Task>();
                toRemove.addAll(tasks);
            } else {
                for (Task task : tasks) {
                    if (!resource.equals(Accessor.getFile(task))) continue;
                    if (null == toRemove) {
                        toRemove = new HashSet();
                    }
                    toRemove.add(task);
                }
            }
        }
        if (null != toRemove) {
            this.removeTasks(toRemove);
            tasks.removeAll(toRemove);
            for (List list : this.group2tasks.values()) {
                list.removeAll(toRemove);
            }
        }
        return toRemove == null ? null : new LinkedList(toRemove);
    }

    void update(FileTaskScanner scanner, FileObject resource, List<Task> newTasks, TaskFilter filter) {
        this.lock.writeLock().lock();
        List<Task> removed = this.clear(scanner, resource);
        HashSet<Task> tasksToAdd = new HashSet<Task>(newTasks.size());
        for (Task t : newTasks) {
            TaskGroup group;
            List<Task> groupTasks;
            if (this.sortedTasks.contains(t) || tasksToAdd.contains(t) || filter.isTaskCountLimitReached(this.countTasks(scanner)) || !filter.accept(t)) continue;
            List<Task> scannerTasks = this.fileScanner2tasks.get(scanner);
            if (null == scannerTasks) {
                scannerTasks = new ArrayList<Task>();
                this.fileScanner2tasks.put(scanner, scannerTasks);
            }
            if (null == (groupTasks = this.group2tasks.get(group = Accessor.getGroup(t)))) {
                groupTasks = new ArrayList<Task>();
                this.group2tasks.put(group, groupTasks);
            }
            scannerTasks.add(t);
            groupTasks.add(t);
            tasksToAdd.add(t);
        }
        if (!tasksToAdd.isEmpty()) {
            this.addTasks(tasksToAdd);
        }
        this.lock.writeLock().unlock();
        if (null != removed && !removed.isEmpty()) {
            this.fireTasksRemoved(removed);
        }
        if (!tasksToAdd.isEmpty()) {
            this.fireTasksAdded(new ArrayList<Task>(tasksToAdd));
        }
    }

    public int size() {
        int retValue = 0;
        this.lock.readLock().lock();
        retValue = this.sortedTasks.size();
        this.lock.readLock().unlock();
        return retValue;
    }

    public List<? extends Task> getTasks() {
        this.lock.readLock().lock();
        try {
            ArrayList<Task> arrayList = new ArrayList<Task>(this.sortedTasks);
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    int countTasks(FileTaskScanner scanner) {
        List<Task> tasks = this.fileScanner2tasks.get(scanner);
        return null == tasks ? 0 : tasks.size();
    }

    public int countTasks(TaskGroup group) {
        List<Task> groupTasks = this.group2tasks.get(group);
        return null == groupTasks ? 0 : groupTasks.size();
    }

    public Task getTask(int index) {
        Task retValue = null;
        this.lock.readLock().lock();
        if (index >= 0 && index < this.sortedTasks.size()) {
            retValue = this.getTasksList().get(index);
        }
        this.lock.readLock().unlock();
        return retValue;
    }

    void clear(FileTaskScanner scanner) {
        this.lock.writeLock().lock();
        List<Task> toRemove = this.fileScanner2tasks.get(scanner);
        this.fileScanner2tasks.remove(scanner);
        if (null != toRemove) {
            for (List<Task> groupTasks : this.group2tasks.values()) {
                groupTasks.removeAll(toRemove);
            }
            this.removeTasks(toRemove);
        }
        this.lock.writeLock().unlock();
        if (null != toRemove && !toRemove.isEmpty()) {
            this.fireTasksRemoved(toRemove);
        }
    }

    void clear(FileTaskScanner scanner, FileObject ... resources) throws IOException {
        this.lock.readLock().lock();
        ArrayList<Task> toRemove = null;
        List<Task> tasks = this.fileScanner2tasks.get(scanner);
        if (null != tasks) {
            for (Task task : tasks) {
                for (FileObject rc : resources) {
                    if (!rc.equals(Accessor.getFile(task))) continue;
                    if (null == toRemove) {
                        toRemove = new ArrayList<Task>(resources.length);
                    }
                    toRemove.add(task);
                }
            }
        }
        this.lock.readLock().unlock();
        if (null != toRemove && !toRemove.isEmpty()) {
            this.lock.writeLock().lock();
            this.removeTasks((Collection<Task>)toRemove);
            tasks.removeAll(toRemove);
            for (List list : this.group2tasks.values()) {
                list.removeAll(toRemove);
            }
            this.lock.writeLock().unlock();
            this.fireTasksRemoved((List<Task>)toRemove);
        }
    }

    private List<Task> clear(FileTaskScanner scanner, FileObject resource) {
        List<Task> tasks = this.fileScanner2tasks.get(scanner);
        if (null == tasks) {
            return null;
        }
        HashSet<Task> toRemove = null;
        for (Task task : tasks) {
            if (!resource.equals(Accessor.getFile(task))) continue;
            if (null == toRemove) {
                toRemove = new HashSet<Task>();
            }
            toRemove.add(task);
        }
        if (null != toRemove) {
            this.removeTasks(toRemove);
            tasks.removeAll(toRemove);
            for (List list : this.group2tasks.values()) {
                list.removeAll(toRemove);
            }
        }
        return toRemove == null ? null : new LinkedList(toRemove);
    }

    void clear(FileObject resource) {
        LinkedList<Task> toRemove = null;
        this.lock.writeLock().lock();
        for (List<Task> scannerTasks : this.fileScanner2tasks.values()) {
            for (Task t : scannerTasks) {
                if (!resource.equals(Accessor.getFile(t))) continue;
                if (null == toRemove) {
                    toRemove = new LinkedList<Task>();
                }
                toRemove.add(t);
            }
        }
        if (null != toRemove) {
            this.removeTasks(toRemove);
            for (List<Task> scannerTasks : this.fileScanner2tasks.values()) {
                scannerTasks.removeAll(toRemove);
            }
            for (List<Task> groupTasks : this.group2tasks.values()) {
                groupTasks.removeAll(toRemove);
            }
        }
        this.lock.writeLock().unlock();
        if (null != toRemove) {
            this.fireTasksRemoved(toRemove);
        }
    }

    void clear() {
        this.lock.writeLock().lock();
        this.sortedTasks.clear();
        this.tasksList = null;
        this.fileScanner2tasks.clear();
        this.pushScanner2tasks.clear();
        this.group2tasks.clear();
        this.lock.writeLock().unlock();
        this.fireCleared();
    }

    void clearDeletedFiles() {
        this.lock.writeLock().lock();
        LinkedList<Task> toRemove = new LinkedList<Task>();
        for (Task task : this.sortedTasks) {
            FileObject fo = Accessor.getFile(task);
            if (null == fo || fo.isValid()) continue;
            toRemove.add(task);
        }
        if (!toRemove.isEmpty()) {
            this.removeTasks(toRemove);
            for (List list : this.fileScanner2tasks.values()) {
                list.removeAll(toRemove);
            }
            for (List list : this.group2tasks.values()) {
                list.removeAll(toRemove);
            }
        }
        this.lock.writeLock().unlock();
        if (!toRemove.isEmpty()) {
            this.fireTasksRemoved(toRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Listener l) {
        WeakSet<Listener> weakSet = this.listeners;
        synchronized (weakSet) {
            this.listeners.add((Object)l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Listener l) {
        WeakSet<Listener> weakSet = this.listeners;
        synchronized (weakSet) {
            this.listeners.remove((Object)l);
        }
    }

    public int indexOf(Task t) {
        this.lock.readLock().lock();
        int idx = this.getTasksList().indexOf(t);
        this.lock.readLock().unlock();
        return idx;
    }

    private Comparator<Task> getComparator() {
        if (null == this.comparator) {
            this.comparator = TaskComparator.getDefault();
        }
        return this.comparator;
    }

    public void setComparator(Comparator<Task> comparator) {
        if (this.getComparator().equals(comparator)) {
            return;
        }
        this.lock.writeLock().lock();
        this.comparator = comparator;
        TreeSet<Task> s = this.sortedTasks;
        this.sortedTasks = new TreeSet<Task>(comparator);
        this.addTasks(s);
        this.lock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTasksAdded(List<Task> tasks) {
        Listener[] listenerArray = this.listeners;
        synchronized (this.listeners) {
            Listener[] tmp = (Listener[])this.listeners.toArray((Object[])new Listener[0]);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (Listener l : tmp) {
                l.tasksAdded(tasks);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTasksRemoved(List<Task> tasks) {
        Listener[] listenerArray = this.listeners;
        synchronized (this.listeners) {
            Listener[] tmp = (Listener[])this.listeners.toArray((Object[])new Listener[0]);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (Listener l : tmp) {
                l.tasksRemoved(tasks);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCleared() {
        Listener[] listenerArray = this.listeners;
        synchronized (this.listeners) {
            Listener[] tmp = (Listener[])this.listeners.toArray((Object[])new Listener[0]);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (Listener l : tmp) {
                l.cleared();
            }
            return;
        }
    }

    private List<Task> getTasksList() {
        if (this.tasksList == null) {
            this.tasksList = new ArrayList<Task>(this.sortedTasks);
        }
        return this.tasksList;
    }

    private void addTasks(Collection<Task> tasksToAdd) {
        this.sortedTasks.addAll(tasksToAdd);
        this.tasksList = null;
    }

    private void removeTasks(Collection<Task> toRemove) {
        this.sortedTasks.removeAll(toRemove);
        this.tasksList = null;
    }

    public static interface Listener {
        public void tasksAdded(List<? extends Task> var1);

        public void tasksRemoved(List<? extends Task> var1);

        public void cleared();
    }
}

