/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.tooling.admin;

import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.netbeans.modules.payara.tooling.admin.Command;
import org.netbeans.modules.payara.tooling.admin.CommandException;
import org.netbeans.modules.payara.tooling.admin.CommandJava;
import org.netbeans.modules.payara.tooling.admin.Runner;
import org.netbeans.modules.payara.tooling.data.PayaraConfig;
import org.netbeans.modules.payara.tooling.data.PayaraServer;
import org.netbeans.modules.payara.tooling.logging.Logger;
import org.netbeans.modules.payara.tooling.server.config.ConfigBuilderProvider;
import org.netbeans.modules.payara.tooling.server.config.JavaSEPlatform;
import org.netbeans.modules.payara.tooling.server.config.JavaSESet;
import org.netbeans.modules.payara.tooling.server.config.PayaraConfigManager;
import org.netbeans.modules.payara.tooling.utils.JavaUtils;
import org.netbeans.modules.payara.tooling.utils.ServerUtils;

abstract class RunnerJava
extends Runner {
    private static final Logger LOGGER = new Logger(RunnerJava.class);
    static final String JAR_PARAM = "-jar";
    static final char QUERY_SEPARATOR = ' ';
    static final char PARAM_SEPARATOR = ' ';
    static final char PARAM_ASSIGN_VALUE = ' ';
    final CommandJava command;
    final String javaVMExe;

    static PayaraConfig getServerConfig(PayaraServer server) {
        String METHOD = "getServerConfig";
        PayaraConfig config = PayaraConfigManager.getConfig(ConfigBuilderProvider.getPlatformBuilderConfig(server.getPlatformVersion()));
        if (config == null) {
            throw new CommandException(LOGGER.excMsg("getServerConfig", "noConfig"), server.getPlatformVersion());
        }
        return config;
    }

    static JavaSESet getJavaSEConfig(PayaraConfig config) {
        String METHOD = "getJavaSEConfig";
        JavaSESet javaSEConfig = config.getJavaSE();
        if (javaSEConfig == null) {
            throw new CommandException(LOGGER.excMsg("getJavaSEConfig", "noJavaSEConfig"));
        }
        return javaSEConfig;
    }

    private static String getJavaVM(PayaraServer server, CommandJava command) {
        String METHOD = "getJavaVM";
        String javaVmExe = JavaUtils.javaVmExecutableFullPath(command.javaHome);
        File javaVmFile = new File(javaVmExe);
        if (!javaVmFile.canExecute()) {
            LOGGER.log(Level.INFO, "getJavaVM", "noJavaVMExe", javaVmExe);
            return null;
        }
        return javaVmExe;
    }

    public RunnerJava(PayaraServer server, Command command, String query) {
        super(server, command, null, query);
        String METHOD = "init";
        if (!(command instanceof CommandJava)) {
            throw new CommandException(LOGGER.excMsg("init", "noCommandJava"));
        }
        this.command = (CommandJava)command;
        this.javaVMExe = RunnerJava.getJavaVM(server, this.command);
        if (this.javaVMExe == null) {
            throw new CommandException(LOGGER.excMsg("init", "noJavaVMExe"), this.command.javaHome, server.getName());
        }
    }

    public RunnerJava(PayaraServer server, Command command) {
        this(server, command, null);
    }

    @Override
    public boolean getDoOutput() {
        return false;
    }

    @Override
    public boolean acceptsGzip() {
        return false;
    }

    @Override
    protected String constructCommandUrl() throws CommandException {
        return null;
    }

    @Override
    protected String getRequestMethod() {
        return null;
    }

    @Override
    protected void handleSend(HttpURLConnection hconn) throws IOException {
    }

    boolean verifyJavaVM() {
        String METHOD = "verifyJavaVM";
        JavaUtils.JavaVersion javaVersion = JavaUtils.javaVmVersion(new File(this.javaVMExe));
        if (javaVersion == null) {
            LOGGER.log(Level.INFO, "verifyJavaVM", "unknown", this.javaVMExe);
            return false;
        }
        LOGGER.log(Level.FINEST, "verifyJavaVM", "info", new Object[]{this.javaVMExe, javaVersion.toString()});
        Set<JavaSEPlatform> platforms = RunnerJava.getJavaSEConfig(RunnerJava.getServerConfig(this.server)).platforms();
        if (!platforms.contains((Object)javaVersion.toPlatform())) {
            LOGGER.log(Level.INFO, "verifyJavaVM", "unsupported", new Object[]{this.javaVMExe, this.server.getName()});
            return false;
        }
        return true;
    }

    static void setJavaEnvironment(Map<String, String> env, CommandJava command) {
        env.put("JAVA_HOME", command.javaHome);
        env.put("AS_JAVA", command.javaHome);
    }

    void setProcessCurrentDir(ProcessBuilder pb) {
        File currentDir;
        String METHOD = "setProcessCurrentDir";
        String domainsFolder = this.server.getDomainsFolder();
        if (domainsFolder != null && domainsFolder.length() > 0 && (currentDir = new File(ServerUtils.getDomainConfigPath(domainsFolder))).exists()) {
            LOGGER.log(Level.FINEST, "setProcessCurrentDir", "dir", new Object[]{this.server.getName(), currentDir});
            pb.directory(currentDir);
        }
    }
}

