/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.tooling.admin;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.netbeans.modules.payara.tooling.PayaraIdeException;
import org.netbeans.modules.payara.tooling.admin.Command;
import org.netbeans.modules.payara.tooling.admin.CommandException;
import org.netbeans.modules.payara.tooling.admin.ResultString;
import org.netbeans.modules.payara.tooling.admin.RunnerHttpClass;
import org.netbeans.modules.payara.tooling.admin.RunnerRestClass;
import org.netbeans.modules.payara.tooling.admin.ServerAdmin;
import org.netbeans.modules.payara.tooling.data.PayaraPlatformVersion;
import org.netbeans.modules.payara.tooling.data.PayaraPlatformVersionAPI;
import org.netbeans.modules.payara.tooling.data.PayaraServer;
import org.netbeans.modules.payara.tooling.data.PayaraVersion;
import org.netbeans.modules.payara.tooling.logging.Logger;
import org.netbeans.modules.payara.tooling.utils.ServerUtils;

@RunnerHttpClass
@RunnerRestClass
public class CommandVersion
extends Command {
    private static final Logger LOGGER = new Logger(CommandVersion.class);
    private static final String COMMAND = "version";

    public static ResultString getVersion(PayaraServer server) throws PayaraIdeException {
        String METHOD = "getVersion";
        Future future = ServerAdmin.exec(server, new CommandVersion());
        try {
            return (ResultString)future.get();
        }
        catch (InterruptedException | CancellationException | ExecutionException ee) {
            throw new CommandException(LOGGER.excMsg("getVersion", "exception"), ee.getLocalizedMessage());
        }
    }

    @Deprecated
    public static PayaraVersion getPayaraVersion(PayaraServer server) {
        String value;
        ResultString result;
        try {
            result = CommandVersion.getVersion(server);
        }
        catch (CommandException ce) {
            return null;
        }
        String string = value = result != null ? ServerUtils.getVersionString(result.getValue()) : null;
        if (value != null) {
            return PayaraVersion.toValue(value);
        }
        return null;
    }

    public static PayaraPlatformVersionAPI getPayaraPlatformVersion(PayaraServer server) {
        String value;
        ResultString result;
        try {
            result = CommandVersion.getVersion(server);
        }
        catch (CommandException ce) {
            return null;
        }
        String string = value = result != null ? ServerUtils.getVersionString(result.getValue()) : null;
        if (value != null) {
            return PayaraPlatformVersion.toValue(value);
        }
        return null;
    }

    public static boolean verifyResult(ResultString result, PayaraServer server) {
        boolean verifyResult = false;
        String value = ServerUtils.getVersionString(result.getValue());
        if (value != null) {
            PayaraPlatformVersionAPI valueVersion = PayaraPlatformVersion.toValue(value);
            PayaraPlatformVersionAPI serverVersion = server.getPlatformVersion();
            if (valueVersion != null && serverVersion != null) {
                verifyResult = serverVersion.equals(valueVersion);
            }
        }
        return verifyResult;
    }

    public CommandVersion() {
        super(COMMAND);
    }
}

