/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.ui.actions;

import org.netbeans.modules.websvc.saas.model.Saas;
import org.netbeans.modules.websvc.saas.model.SaasServicesModel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;

public class RefreshServiceAction
extends NodeAction {
    protected boolean enable(Node[] nodes) {
        boolean enabled = true;
        for (Node node : nodes) {
            Saas saas = (Saas)node.getLookup().lookup(Saas.class);
            if (saas != null && saas.getState() != Saas.State.INITIALIZING) continue;
            enabled = false;
            break;
        }
        return enabled;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected String iconResource() {
        return "org/netbeans/modules/websvc/saas/ui/resources/ActionIcon.gif";
    }

    public String getName() {
        return NbBundle.getMessage(RefreshServiceAction.class, (String)"REFRESH");
    }

    protected void performAction(final Node[] nodes) {
        String msg = NbBundle.getMessage(RefreshServiceAction.class, (String)"WS_REFRESH");
        NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)msg, 0);
        Object response = DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
        if (NotifyDescriptor.YES_OPTION.equals(response)) {
            RequestProcessor.getDefault().post(new Runnable(){
                final /* synthetic */ RefreshServiceAction this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    for (Node node : nodes) {
                        Saas saas = (Saas)node.getLookup().lookup(Saas.class);
                        try {
                            SaasServicesModel.getInstance().refreshService(saas);
                        }
                        catch (Exception ex) {
                            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)ex.getMessage());
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                        }
                    }
                }
            });
        }
    }

    protected boolean asynchronous() {
        return false;
    }
}

