/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.nette2;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.spi.phpmodule.ImportantFilesImplementation;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;

public final class ConfigurationFiles
extends FileChangeAdapter
implements ImportantFilesImplementation {
    private final PhpModule phpModule;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private FileObject sourceDirectory = null;

    ConfigurationFiles(PhpModule phpModule) {
        assert (phpModule != null);
        this.phpModule = phpModule;
    }

    public Collection<ImportantFilesImplementation.FileInfo> getFiles() {
        FileObject config;
        FileObject extraIndex;
        FileObject commonIndex;
        FileObject sourceDir = this.getSourceDirectory();
        if (sourceDir == null) {
            return Collections.emptyList();
        }
        ArrayList<ImportantFilesImplementation.FileInfo> files = new ArrayList<ImportantFilesImplementation.FileInfo>();
        FileObject bootstrap = sourceDir.getFileObject("app/bootstrap.php");
        if (bootstrap != null) {
            files.add(new ImportantFilesImplementation.FileInfo(bootstrap));
        }
        if ((commonIndex = sourceDir.getFileObject("www/index.php")) != null) {
            files.add(new ImportantFilesImplementation.FileInfo(commonIndex));
        }
        if ((extraIndex = sourceDir.getFileObject("index.php")) != null) {
            files.add(new ImportantFilesImplementation.FileInfo(extraIndex));
        }
        if ((config = sourceDir.getFileObject("app/config")) != null && config.isFolder() && config.isValid()) {
            ArrayList<ImportantFilesImplementation.FileInfo> configFiles = new ArrayList<ImportantFilesImplementation.FileInfo>();
            for (FileObject child : config.getChildren()) {
                if (!child.isData()) continue;
                configFiles.add(new ImportantFilesImplementation.FileInfo(child));
            }
            configFiles.sort(ImportantFilesImplementation.FileInfo.COMPARATOR);
            files.addAll(configFiles);
        }
        return files;
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    private void fireChange() {
        this.changeSupport.fireChange();
    }

    @CheckForNull
    private synchronized FileObject getSourceDirectory() {
        if (this.sourceDirectory == null) {
            this.sourceDirectory = this.phpModule.getSourceDirectory();
            if (this.sourceDirectory != null) {
                File sources = FileUtil.toFile((FileObject)this.sourceDirectory);
                this.addListener(new File(sources, "app/bootstrap.php"));
                this.addListener(new File(sources, "www/index.php"));
                this.addListener(new File(sources, "index.php"));
                this.addListener(new File(sources, "app/config"));
            }
        }
        return this.sourceDirectory;
    }

    private void addListener(File path) {
        block2: {
            try {
                FileUtil.addFileChangeListener((FileChangeListener)this, (File)path);
            }
            catch (IllegalArgumentException ex) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError(path);
            }
        }
    }

    public void fileRenamed(FileRenameEvent fe) {
        this.fireChange();
    }

    public void fileDeleted(FileEvent fe) {
        this.fireChange();
    }

    public void fileDataCreated(FileEvent fe) {
        this.fireChange();
    }

    public void fileFolderCreated(FileEvent fe) {
        this.fireChange();
    }
}

