/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.refactoring;

import java.awt.EventQueue;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.css.editor.Css3Utils;
import org.netbeans.modules.css.lib.api.CssParserResult;
import org.netbeans.modules.css.lib.api.CssTokenId;
import org.netbeans.modules.css.lib.api.Node;
import org.netbeans.modules.css.lib.api.NodeUtil;
import org.netbeans.modules.css.refactoring.CssRenameRefactoringUI;
import org.netbeans.modules.css.refactoring.WhereUsedUI;
import org.netbeans.modules.css.refactoring.api.CssRefactoringInfo;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.refactoring.spi.ui.ActionsImplementationProvider;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.netbeans.modules.web.common.api.WebUtils;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public class CssActionsImplementationProvider
extends ActionsImplementationProvider {
    private static final RequestProcessor RP = new RequestProcessor(CssActionsImplementationProvider.class);
    private static final Logger LOG = Logger.getLogger(CssActionsImplementationProvider.class.getName());

    public boolean canRename(Lookup lookup) {
        Collection nodes = lookup.lookupAll(org.openide.nodes.Node.class);
        if (nodes.size() != 1) {
            return false;
        }
        org.openide.nodes.Node node = (org.openide.nodes.Node)nodes.iterator().next();
        return CssActionsImplementationProvider.isCssFile(node) || CssActionsImplementationProvider.isRefactorableEditorElement(node);
    }

    public void doRename(Lookup selectedNodes) {
        Runnable task;
        EditorCookie ec = (EditorCookie)selectedNodes.lookup(EditorCookie.class);
        if (CssActionsImplementationProvider.isFromEditor(ec)) {
            task = new TextComponentTask(ec){

                @Override
                protected RefactoringUI createRefactoringUI(String elementName, Object ... lookupContent) {
                    return new CssRenameRefactoringUI(elementName, lookupContent);
                }
            };
        } else {
            Collection nodes = selectedNodes.lookupAll(org.openide.nodes.Node.class);
            assert (nodes.size() == 1);
            org.openide.nodes.Node currentNode = (org.openide.nodes.Node)nodes.iterator().next();
            task = new NodeToFileTask(currentNode){

                @Override
                protected RefactoringUI createRefactoringUI(String elementName, Object ... lookupContent) {
                    return new CssRenameRefactoringUI(elementName, lookupContent);
                }
            };
        }
        RP.post(task);
    }

    public boolean canFindUsages(Lookup lookup) {
        Collection nodes = lookup.lookupAll(org.openide.nodes.Node.class);
        if (nodes.size() != 1) {
            return false;
        }
        org.openide.nodes.Node node = (org.openide.nodes.Node)nodes.iterator().next();
        return CssActionsImplementationProvider.isCssFile(node) || CssActionsImplementationProvider.isRefactorableEditorElement(node);
    }

    public void doFindUsages(Lookup lookup) {
        Runnable task;
        EditorCookie ec = (EditorCookie)lookup.lookup(EditorCookie.class);
        if (CssActionsImplementationProvider.isFromEditor(ec)) {
            task = new TextComponentTask(ec){

                @Override
                protected RefactoringUI createRefactoringUI(String elementName, Object ... lookupContent) {
                    return new WhereUsedUI(lookupContent);
                }
            };
        } else {
            Collection nodes = lookup.lookupAll(org.openide.nodes.Node.class);
            assert (nodes.size() == 1);
            org.openide.nodes.Node currentNode = (org.openide.nodes.Node)nodes.iterator().next();
            task = new NodeToFileTask(currentNode){

                @Override
                protected RefactoringUI createRefactoringUI(String elementName, Object ... lookupContent) {
                    return new WhereUsedUI(lookupContent);
                }
            };
        }
        RP.post(task);
    }

    private static boolean isCssFile(org.openide.nodes.Node node) {
        FileObject fo = CssActionsImplementationProvider.getFileObjectFromNode(node);
        if (fo == null) {
            return false;
        }
        return "text/css".equals(fo.getMIMEType());
    }

    private static boolean isRefactorableEditorElement(org.openide.nodes.Node node) {
        AtomicBoolean result = new AtomicBoolean(false);
        Mutex.EVENT.readAccess(() -> {
            EditorCookie ec = CssActionsImplementationProvider.getEditorCookie(node);
            if (CssActionsImplementationProvider.isFromEditor(ec)) {
                StyledDocument document = ec.getDocument();
                JEditorPane pane = ec.getOpenedPanes()[0];
                int caret = pane.getCaretPosition();
                document.render(() -> {
                    TokenSequence ts = LexerUtils.getTokenSequence((Document)document, (int)caret, (Language)CssTokenId.language(), (boolean)false);
                    result.set(ts != null);
                });
            }
        });
        return result.get();
    }

    private static FileObject getFileObjectFromNode(org.openide.nodes.Node node) {
        DataObject dobj = (DataObject)node.getLookup().lookup(DataObject.class);
        return dobj != null ? dobj.getPrimaryFile() : null;
    }

    private static boolean isFromEditor(EditorCookie ec) {
        TopComponent activetc;
        return ec != null && ec.getOpenedPanes() != null && (activetc = TopComponent.getRegistry().getActivated()) instanceof CloneableEditorSupport.Pane;
    }

    private static EditorCookie getEditorCookie(org.openide.nodes.Node node) {
        return (EditorCookie)node.getLookup().lookup(EditorCookie.class);
    }

    private static CssRefactoringInfo createRefactoringInfo(CssParserResult result, int caretOffset) {
        int astOffset;
        Node root = result.getParseTree();
        Node leaf = NodeUtil.findNodeAtOffset((Node)root, (int)(astOffset = result.getSnapshot().getEmbeddedOffset(caretOffset)));
        if (leaf == null) {
            return null;
        }
        leaf = leaf.parent();
        CssRefactoringInfo.Type type = null;
        switch (leaf.type()) {
            case elementName: {
                type = CssRefactoringInfo.Type.ELEMENT;
                break;
            }
            case cssClass: {
                type = CssRefactoringInfo.Type.CLASS;
                break;
            }
            case cssId: {
                type = CssRefactoringInfo.Type.ID;
                break;
            }
            case hexColor: {
                type = CssRefactoringInfo.Type.HEX_COLOR;
                break;
            }
            case resourceIdentifier: {
                type = CssRefactoringInfo.Type.RESOURCE_IDENTIFIER;
                break;
            }
            case term: {
                if (NodeUtil.getChildTokenNode((Node)leaf, (CssTokenId)CssTokenId.URI) == null) break;
                type = CssRefactoringInfo.Type.URI;
            }
        }
        if (type == null) {
            return null;
        }
        String name = null;
        switch (leaf.type()) {
            case resourceIdentifier: {
                int dotIndex;
                Node string = NodeUtil.getChildTokenNode((Node)leaf, (CssTokenId)CssTokenId.STRING);
                if (string == null || (dotIndex = (name = WebUtils.unquotedValue((CharSequence)string.unescapedImage())).lastIndexOf(46)) == -1) break;
                name = name.substring(0, dotIndex);
                break;
            }
            case term: {
                int groupIndex;
                String content;
                int dotIndex;
                Matcher m;
                Node uri = NodeUtil.getChildTokenNode((Node)leaf, (CssTokenId)CssTokenId.URI);
                if (uri == null || !(m = Css3Utils.URI_PATTERN.matcher(uri.unescapedImage())).matches() || (dotIndex = (name = WebUtils.unquotedValue((CharSequence)(content = m.group(groupIndex = 1)))).lastIndexOf(46)) == -1) break;
                name = name.substring(0, dotIndex);
                break;
            }
            case cssClass: 
            case cssId: {
                name = leaf.unescapedImage().trim().substring(1);
                break;
            }
            default: {
                name = leaf.unescapedImage().trim();
            }
        }
        if (name == null) {
            return null;
        }
        FileObject fileObject = result.getSnapshot().getSource().getFileObject();
        return new CssRefactoringInfo(fileObject, name, type);
    }

    private static abstract class TextComponentTask
    extends UserTask
    implements Runnable {
        private final Document document;
        private final int caretOffset;
        private RefactoringUI ui;

        public TextComponentTask(EditorCookie ec) {
            JEditorPane textC = ec.getOpenedPanes()[0];
            this.document = textC.getDocument();
            this.caretOffset = textC.getCaretPosition();
        }

        public void run(ResultIterator ri) throws ParseException {
            CssParserResult result;
            ResultIterator cssri = WebUtils.getResultIterator((ResultIterator)ri, (String)"text/css");
            if (cssri != null && (result = (CssParserResult)cssri.getParserResult()).getParseTree() != null) {
                CssRefactoringInfo context = CssActionsImplementationProvider.createRefactoringInfo(result, this.caretOffset);
                this.ui = context != null ? this.createRefactoringUI(context.getElementName(), context) : null;
            }
        }

        @Override
        public final void run() {
            try {
                Source source = Source.create((Document)this.document);
                ParserManager.parse(Collections.singleton(source), (UserTask)this);
            }
            catch (ParseException e) {
                LOG.log(Level.WARNING, null, e);
                return;
            }
            EventQueue.invokeLater(() -> {
                TopComponent activetc = TopComponent.getRegistry().getActivated();
                if (this.ui != null) {
                    UI.openRefactoringUI((RefactoringUI)this.ui, (TopComponent)activetc);
                } else {
                    JOptionPane.showMessageDialog(null, NbBundle.getMessage(CssActionsImplementationProvider.class, (String)"ERR_CannotRefactorLoc"));
                }
            });
        }

        protected abstract RefactoringUI createRefactoringUI(String var1, Object ... var2);
    }

    private static abstract class NodeToFileTask
    implements Runnable {
        private final org.openide.nodes.Node node;
        private FileObject fileObject;

        public NodeToFileTask(org.openide.nodes.Node node) {
            this.node = node;
        }

        @Override
        public void run() {
            DataObject dobj = (DataObject)this.node.getLookup().lookup(DataObject.class);
            if (dobj != null) {
                this.fileObject = dobj.getPrimaryFile();
                EventQueue.invokeLater(() -> UI.openRefactoringUI((RefactoringUI)this.createRefactoringUI(this.fileObject.getName(), this.fileObject)));
            }
        }

        protected abstract RefactoringUI createRefactoringUI(String var1, Object ... var2);
    }
}

