/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.csl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.csl.spi.DefaultError;
import org.netbeans.modules.css.lib.api.FilterableError;
import org.openide.filesystems.FileObject;

public class CssErrorFactory {
    public static FilterableError createError(String key, String displayName, String description, FileObject file, int start, int end, boolean lineError, Severity severity, Collection<FilterableError.SetFilterAction> enableFilter, FilterableError.SetFilterAction disableFilter) {
        return new CssDefaultError(key, displayName, description, file, start, end, lineError, severity, enableFilter, disableFilter);
    }

    public static FilterableError createError(String key, String displayName, String description, FileObject file, int start, int end, boolean lineError, Severity severity) {
        return CssErrorFactory.createError(key, displayName, description, file, start, end, lineError, severity, Collections.emptyList(), null);
    }

    private static class CssDefaultError
    extends DefaultError
    implements FilterableError,
    Error.Badging {
        private final Collection<FilterableError.SetFilterAction> enableFilter;
        private final FilterableError.SetFilterAction disableFilter;

        private CssDefaultError(String key, String displayName, String description, FileObject file, int start, int end, boolean lineError, Severity severity, Collection<FilterableError.SetFilterAction> enableFilter, FilterableError.SetFilterAction disableFilter) {
            super(key, displayName, description, file, start, end, lineError, severity);
            this.disableFilter = disableFilter;
            this.enableFilter = enableFilter;
        }

        public boolean showExplorerBadge() {
            return this.getSeverity() == Severity.ERROR || this.getSeverity() == Severity.FATAL;
        }

        public boolean isFiltered() {
            return this.disableFilter != null;
        }

        public Collection<FilterableError.SetFilterAction> getEnableFilterActions() {
            return this.enableFilter;
        }

        public FilterableError.SetFilterAction getDisableFilterAction() {
            return this.disableFilter;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            FilterableError other = (FilterableError)obj;
            if (this.getDisplayName() == null ? other.getDisplayName() != null : !this.getDisplayName().equals(other.getDisplayName())) {
                return false;
            }
            if (this.getDescription() == null ? other.getDescription() != null : !this.getDescription().equals(other.getDescription())) {
                return false;
            }
            if (!(this.getFile() == other.getFile() || this.getFile() != null && this.getFile().equals(other.getFile()))) {
                return false;
            }
            if (this.getStartPosition() != other.getStartPosition()) {
                return false;
            }
            if (this.getEndPosition() != other.getEndPosition()) {
                return false;
            }
            if (this.isLineError() != other.isLineError()) {
                return false;
            }
            if (this.getKey() == null ? other.getKey() != null : !this.getKey().equals(other.getKey())) {
                return false;
            }
            if (this.getSeverity() != other.getSeverity()) {
                return false;
            }
            if (this.isFiltered() != other.isFiltered()) {
                return false;
            }
            return Arrays.deepEquals(this.getParameters(), other.getParameters());
        }

        public int hashCode() {
            int hash = 7;
            hash = 29 * hash + (this.getDisplayName() != null ? this.getDisplayName().hashCode() : 0);
            hash = 29 * hash + (this.getDescription() != null ? this.getDescription().hashCode() : 0);
            hash = 29 * hash + (this.getFile() != null ? this.getFile().hashCode() : 0);
            hash = 29 * hash + this.getStartPosition();
            hash = 29 * hash + this.getEndPosition();
            hash = 29 * hash + (this.isLineError() ? 1 : 0);
            hash = 29 * hash + (this.getKey() != null ? this.getKey().hashCode() : 0);
            hash = 29 * hash + (this.getSeverity() != null ? this.getSeverity().hashCode() : 0);
            hash = 29 * hash + (this.isFiltered() ? 1 : 0);
            hash = 29 * hash + Arrays.deepHashCode(this.getParameters());
            return hash;
        }

        public String toString() {
            return super.toString() + " (file:" + this.getFile() + ", from:" + this.getStartPosition() + ", to:" + this.getEndPosition() + ")";
        }
    }
}

