/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.containerengine.model.ShapeMemoryOptions;
import com.oracle.bmc.containerengine.model.ShapeNetworkBandwidthOptions;
import com.oracle.bmc.containerengine.model.ShapeOcpuOptions;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PodShapeSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="processorDescription")
    private final String processorDescription;
    @JsonProperty(value="ocpuOptions")
    private final List<ShapeOcpuOptions> ocpuOptions;
    @JsonProperty(value="memoryOptions")
    private final List<ShapeMemoryOptions> memoryOptions;
    @JsonProperty(value="networkBandwidthOptions")
    private final List<ShapeNetworkBandwidthOptions> networkBandwidthOptions;

    @Deprecated
    @ConstructorProperties(value={"name", "processorDescription", "ocpuOptions", "memoryOptions", "networkBandwidthOptions"})
    public PodShapeSummary(String name, String processorDescription, List<ShapeOcpuOptions> ocpuOptions, List<ShapeMemoryOptions> memoryOptions, List<ShapeNetworkBandwidthOptions> networkBandwidthOptions) {
        this.name = name;
        this.processorDescription = processorDescription;
        this.ocpuOptions = ocpuOptions;
        this.memoryOptions = memoryOptions;
        this.networkBandwidthOptions = networkBandwidthOptions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public String getProcessorDescription() {
        return this.processorDescription;
    }

    public List<ShapeOcpuOptions> getOcpuOptions() {
        return this.ocpuOptions;
    }

    public List<ShapeMemoryOptions> getMemoryOptions() {
        return this.memoryOptions;
    }

    public List<ShapeNetworkBandwidthOptions> getNetworkBandwidthOptions() {
        return this.networkBandwidthOptions;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PodShapeSummary(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", processorDescription=").append(String.valueOf(this.processorDescription));
        sb.append(", ocpuOptions=").append(String.valueOf(this.ocpuOptions));
        sb.append(", memoryOptions=").append(String.valueOf(this.memoryOptions));
        sb.append(", networkBandwidthOptions=").append(String.valueOf(this.networkBandwidthOptions));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PodShapeSummary)) {
            return false;
        }
        PodShapeSummary other = (PodShapeSummary)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.processorDescription, other.processorDescription) && Objects.equals(this.ocpuOptions, other.ocpuOptions) && Objects.equals(this.memoryOptions, other.memoryOptions) && Objects.equals(this.networkBandwidthOptions, other.networkBandwidthOptions) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.processorDescription == null ? 43 : this.processorDescription.hashCode());
        result = result * 59 + (this.ocpuOptions == null ? 43 : this.ocpuOptions.hashCode());
        result = result * 59 + (this.memoryOptions == null ? 43 : this.memoryOptions.hashCode());
        result = result * 59 + (this.networkBandwidthOptions == null ? 43 : this.networkBandwidthOptions.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="processorDescription")
        private String processorDescription;
        @JsonProperty(value="ocpuOptions")
        private List<ShapeOcpuOptions> ocpuOptions;
        @JsonProperty(value="memoryOptions")
        private List<ShapeMemoryOptions> memoryOptions;
        @JsonProperty(value="networkBandwidthOptions")
        private List<ShapeNetworkBandwidthOptions> networkBandwidthOptions;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder processorDescription(String processorDescription) {
            this.processorDescription = processorDescription;
            this.__explicitlySet__.add("processorDescription");
            return this;
        }

        public Builder ocpuOptions(List<ShapeOcpuOptions> ocpuOptions) {
            this.ocpuOptions = ocpuOptions;
            this.__explicitlySet__.add("ocpuOptions");
            return this;
        }

        public Builder memoryOptions(List<ShapeMemoryOptions> memoryOptions) {
            this.memoryOptions = memoryOptions;
            this.__explicitlySet__.add("memoryOptions");
            return this;
        }

        public Builder networkBandwidthOptions(List<ShapeNetworkBandwidthOptions> networkBandwidthOptions) {
            this.networkBandwidthOptions = networkBandwidthOptions;
            this.__explicitlySet__.add("networkBandwidthOptions");
            return this;
        }

        public PodShapeSummary build() {
            PodShapeSummary model = new PodShapeSummary(this.name, this.processorDescription, this.ocpuOptions, this.memoryOptions, this.networkBandwidthOptions);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PodShapeSummary model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("processorDescription")) {
                this.processorDescription(model.getProcessorDescription());
            }
            if (model.wasPropertyExplicitlySet("ocpuOptions")) {
                this.ocpuOptions(model.getOcpuOptions());
            }
            if (model.wasPropertyExplicitlySet("memoryOptions")) {
                this.memoryOptions(model.getMemoryOptions());
            }
            if (model.wasPropertyExplicitlySet("networkBandwidthOptions")) {
                this.networkBandwidthOptions(model.getNetworkBandwidthOptions());
            }
            return this;
        }
    }
}

