/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.actions;

import javax.swing.text.JTextComponent;
import org.netbeans.modules.websvc.api.support.InvokeOperationCookie;
import org.netbeans.modules.websvc.core.jaxws.actions.JaxWsCodeGenerator;
import org.netbeans.modules.websvc.core.webservices.ui.panels.ClientExplorerPanel;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;

public class JaxWsInvokeOperation
implements InvokeOperationCookie {
    private FileObject targetSource;

    public JaxWsInvokeOperation(FileObject targetSource) {
        this.targetSource = targetSource;
    }

    public void invokeOperation(Lookup sourceNodeLookup, JTextComponent targetComponent) {
        try {
            DataObject dObj = DataObject.find((FileObject)this.targetSource);
            JaxWsCodeGenerator.insertMethodCall(this.getTargetSourceType(dObj), dObj, sourceNodeLookup);
        }
        catch (DataObjectNotFoundException ex) {
            ex.printStackTrace();
        }
    }

    public InvokeOperationCookie.ClientSelectionPanel getDialogDescriptorPanel() {
        return new ClientExplorerPanel(this.targetSource);
    }

    private InvokeOperationCookie.TargetSourceType getTargetSourceType(DataObject dObj) {
        EditorCookie cookie = (EditorCookie)dObj.getCookie(EditorCookie.class);
        if (cookie != null && "text/x-jsp".equals(cookie.getDocument().getProperty("mimeType"))) {
            return InvokeOperationCookie.TargetSourceType.JSP;
        }
        if (cookie != null && "text/x-java".equals(cookie.getDocument().getProperty("mimeType"))) {
            return InvokeOperationCookie.TargetSourceType.JAVA;
        }
        return InvokeOperationCookie.TargetSourceType.UNKNOWN;
    }
}

