/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.retrier;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.io.internal.KeepOpenInputStream;
import com.oracle.bmc.io.internal.ResettableFileInputStream;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.RetryConfiguration;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Retriers {
    private static final Logger LOG = LoggerFactory.getLogger(Retriers.class);
    private static volatile RetryConfiguration DEFAULT_RETRY_CONFIGURATION = null;
    private static volatile boolean SEND_OPC_RETRY_TOKEN = true;
    private static final String OCI_SDK_DEFAULT_RETRY_ENABLED_ENV_VAR = "OCI_SDK_DEFAULT_RETRY_ENABLED";

    public static void setDefaultRetryConfiguration(@Nonnull RetryConfiguration retryConfiguration) {
        if (retryConfiguration == null) {
            throw new NullPointerException("retryConfiguration is marked non-null but is null");
        }
        LOG.info("Setting default retry configuration to {}", (Object)retryConfiguration);
        DEFAULT_RETRY_CONFIGURATION = retryConfiguration;
    }

    public static void shouldSendOpcRetryToken(boolean shouldSendOpcRetryToken) {
        LOG.info("Setting shouldSendOpcRetryToken to {}", (Object)shouldSendOpcRetryToken);
        SEND_OPC_RETRY_TOKEN = shouldSendOpcRetryToken;
    }

    public static boolean shouldSendOpcRetryToken() {
        return SEND_OPC_RETRY_TOKEN;
    }

    public static BmcGenericRetrier createPreferredRetrier(@Nullable RetryConfiguration requestRetryConfiguration, @Nullable RetryConfiguration clientRetryConfiguration) {
        return Retriers.createPreferredRetrier(requestRetryConfiguration, clientRetryConfiguration, false);
    }

    public static BmcGenericRetrier createPreferredRetrier(@Nullable RetryConfiguration requestRetryConfiguration, @Nullable RetryConfiguration clientRetryConfiguration, boolean specBasedDefaultRetryEnabled) {
        Optional<RetryConfiguration> userRetryStrategy = Stream.of(requestRetryConfiguration, clientRetryConfiguration, DEFAULT_RETRY_CONFIGURATION).filter(Objects::nonNull).findFirst();
        RetryConfiguration preferredRetryConfiguration = null;
        preferredRetryConfiguration = userRetryStrategy.isPresent() ? userRetryStrategy.get() : (Retriers.envBasedRetryConfiguration() != null ? Retriers.envBasedRetryConfiguration() : (specBasedDefaultRetryEnabled ? RetryConfiguration.SDK_DEFAULT_RETRY_CONFIGURATION : RetryConfiguration.NO_RETRY_CONFIGURATION));
        LOG.debug("Using retry configuration: {}", (Object)preferredRetryConfiguration);
        return new BmcGenericRetrier(preferredRetryConfiguration);
    }

    private static RetryConfiguration envBasedRetryConfiguration() {
        String defaultRetryEnvVariable = System.getenv(OCI_SDK_DEFAULT_RETRY_ENABLED_ENV_VAR);
        if (defaultRetryEnvVariable != null) {
            if (defaultRetryEnvVariable.equalsIgnoreCase("true")) {
                return RetryConfiguration.SDK_DEFAULT_RETRY_CONFIGURATION;
            }
            if (defaultRetryEnvVariable.equalsIgnoreCase("false")) {
                return RetryConfiguration.NO_RETRY_CONFIGURATION;
            }
        }
        return null;
    }

    @InternalSdk
    public static void tryResetStreamForRetry(InputStream body) {
        Retriers.tryResetStreamForRetry(body, true);
    }

    @InternalSdk
    public static void tryResetStreamForRetry(InputStream body, boolean failIfUnsupported) {
        if (body.markSupported()) {
            LOG.debug("mark/reset is supported, resetting stream {}", (Object)body.getClass().getName());
            try {
                body.reset();
            }
            catch (IOException ioe) {
                throw new RuntimeException("Failed to reset stream for next retry");
            }
        } else {
            if (failIfUnsupported) {
                throw new RuntimeException(String.format("Stream {} does not support mark/reset, retries do not work", body.getClass().getName()));
            }
            LOG.warn("Stream {} does not support mark/reset, retries will not work", (Object)body.getClass().getName());
        }
    }

    @InternalSdk
    public static <T extends BmcRequest<InputStream>> T wrapBodyInputStreamIfNecessary(T request, BmcRequest.Builder<T, InputStream> builder) {
        InputStream body = request.getBody$();
        InputStream wrappedStream = Retriers.wrapInputStreamForRetry(body);
        RetryConfiguration retryConfiguration = (request = builder.copy(request).body$(wrappedStream).build()).getRetryConfiguration();
        if (retryConfiguration != null && retryConfiguration.getRetryOptions() != null) {
            wrappedStream.mark(retryConfiguration.getRetryOptions().getMarkReadLimit());
        } else {
            wrappedStream.mark(Integer.MAX_VALUE);
        }
        return request;
    }

    @InternalSdk
    public static InputStream wrapInputStreamForRetry(InputStream body) {
        KeepOpenInputStream wrappedStream;
        if (body instanceof FileInputStream && ResettableFileInputStream.canBeWrapped((FileInputStream)body)) {
            LOG.debug("Wrapping FileInputStream in a ResettableFileInputStream");
            wrappedStream = new KeepOpenInputStream(new ResettableFileInputStream((FileInputStream)body));
        } else if (!body.markSupported()) {
            LOG.warn("stream does not support mark/reset or is a FileInputStream that doesn't allow changing the position, buffering in memory!");
            wrappedStream = new KeepOpenInputStream(new BufferedInputStream(body));
        } else {
            wrappedStream = new KeepOpenInputStream(body);
        }
        return wrappedStream;
    }

    private Retriers() {
    }
}

