/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.DateRange;
import org.eclipse.mylyn.internal.tasks.core.DayDateRange;
import org.eclipse.mylyn.internal.tasks.core.ITaskListChangeListener;
import org.eclipse.mylyn.internal.tasks.core.TaskActivationHistory;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityUtil;
import org.eclipse.mylyn.internal.tasks.core.TaskContainerDelta;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.internal.tasks.core.WeekDateRange;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskActivationListener;
import org.eclipse.mylyn.tasks.core.ITaskActivityListener;
import org.eclipse.mylyn.tasks.core.ITaskActivityManager2;
import org.eclipse.mylyn.tasks.core.TaskActivationAdapter;
import org.eclipse.osgi.util.NLS;

public class TaskActivityManager
implements ITaskActivityManager2 {
    private final TaskActivationHistory taskActivationHistory = new TaskActivationHistory();
    private final List<ITaskActivityListener> activityListeners = new ArrayList<ITaskActivityListener>();
    private final List<ITaskActivationListener> activationListeners = new ArrayList<ITaskActivationListener>();
    private final Set<ITask> allScheduledTasks = new HashSet<ITask>();
    private final Set<ITask> allDueTasks = new HashSet<ITask>();
    private final SortedMap<DateRange, Set<ITask>> scheduledTasks = Collections.synchronizedSortedMap(new TreeMap());
    private final SortedMap<Calendar, Set<ITask>> dueTasks = Collections.synchronizedSortedMap(new TreeMap());
    private final SortedMap<Calendar, Set<AbstractTask>> activeTasks = Collections.synchronizedSortedMap(new TreeMap());
    private final Map<AbstractTask, SortedMap<Calendar, Long>> taskElapsedTimeMap = new ConcurrentHashMap<AbstractTask, SortedMap<Calendar, Long>>();
    private final Map<String, SortedMap<Calendar, Long>> workingSetElapsedTimeMap = new ConcurrentHashMap<String, SortedMap<Calendar, Long>>();
    private final TaskList taskList;
    private final TaskRepositoryManager repositoryManager;
    private ITask activeTask;
    private int startDay = 2;
    private boolean listenersInitialized = false;
    private final ITaskListChangeListener TASKLIST_CHANGE_LISTENER = new ITaskListChangeListener(){

        @Override
        public void containersChanged(Set<TaskContainerDelta> containers) {
            for (TaskContainerDelta taskContainerDelta : containers) {
                if (taskContainerDelta.getKind() == TaskContainerDelta.Kind.ROOT) {
                    TaskActivityManager.this.reloadPlanningData();
                    continue;
                }
                if (taskContainerDelta.isTransient() || TaskContainerDelta.Kind.DELETED != taskContainerDelta.getKind() || !(taskContainerDelta.getElement() instanceof ITask) || TaskActivityManager.this.taskActivationHistory == null) continue;
                TaskActivityManager.this.taskActivationHistory.removeTask((ITask)taskContainerDelta.getElement());
            }
        }
    };
    private static final String ID_EXTENSION_TASK_ACTIVATION_LISTENERS = "org.eclipse.mylyn.tasks.core.taskActivationListeners";

    public TaskActivityManager(TaskRepositoryManager repositoryManager, TaskList taskList) {
        this.taskList = taskList;
        this.repositoryManager = repositoryManager;
        this.taskList.addChangeListener(this.TASKLIST_CHANGE_LISTENER);
        this.clear();
    }

    private void initTaskListeners() {
        if (!this.listenersInitialized) {
            IExtension[] listenerExtensions;
            this.listenersInitialized = true;
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint listenerExtensionPoint = registry.getExtensionPoint(ID_EXTENSION_TASK_ACTIVATION_LISTENERS);
            IExtension[] iExtensionArray = listenerExtensions = listenerExtensionPoint.getExtensions();
            int n = listenerExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if ("listener".equals(element.getName())) {
                        try {
                            Object object = element.createExecutableExtension("class");
                            if (object instanceof ITaskActivationListener) {
                                this.addActivationListener((ITaskActivationListener)object);
                            } else {
                                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", NLS.bind((String)"Unexpected error registering listener contributed by {0}: ''{1}'' does not extend expected class", (Object)element.getContributor().getName(), (Object)object.getClass().getCanonicalName())));
                            }
                        }
                        catch (Throwable e) {
                            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", NLS.bind((String)"Unexpected error registering listener contributed by {0}", (Object)element.getContributor().getName()), e));
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    public int getWeekStartDay() {
        return this.startDay;
    }

    public void setWeekStartDay(int startDay) {
        TaskActivityUtil.setStartDay(startDay);
        this.startDay = startDay;
        for (ITaskActivityListener listener : this.activityListeners) {
            listener.activityReset();
        }
    }

    @Override
    public void addActivityListener(ITaskActivityListener listener) {
        this.activityListeners.add(listener);
    }

    @Override
    public void removeActivityListener(ITaskActivityListener listener) {
        this.activityListeners.remove(listener);
    }

    @Override
    public void addActivationListener(ITaskActivationListener listener) {
        this.activationListeners.add(listener);
    }

    @Override
    public void removeActivationListener(ITaskActivationListener listener) {
        this.activationListeners.remove(listener);
    }

    public void clear() {
        this.dueTasks.clear();
        this.allDueTasks.clear();
        this.scheduledTasks.clear();
        this.allScheduledTasks.clear();
        this.clearActivity();
    }

    public void clearActivity() {
        this.activeTasks.clear();
        this.taskElapsedTimeMap.clear();
        this.workingSetElapsedTimeMap.clear();
    }

    public void reloadPlanningData() {
        this.reloadScheduledData();
        for (ITaskActivityListener listener : this.activityListeners) {
            listener.activityReset();
        }
    }

    public void removeElapsedTime(ITask task, Date startDate, Date endDate) {
        Assert.isNotNull((Object)task);
        Assert.isNotNull((Object)startDate);
        Assert.isNotNull((Object)endDate);
        SortedMap<Calendar, Long> activityMap = this.taskElapsedTimeMap.get(task);
        if (activityMap != null) {
            Calendar start = TaskActivityUtil.getCalendar();
            start.setTime(startDate);
            TaskActivityUtil.snapStartOfHour(start);
            Calendar end = TaskActivityUtil.getCalendar();
            end.setTime(endDate);
            TaskActivityUtil.snapEndOfHour(end);
            activityMap = activityMap.subMap(start, end);
            for (Calendar cal : new HashSet<Calendar>(activityMap.keySet())) {
                activityMap.remove(cal);
            }
            long elapsedTime = this.getElapsedTime(task);
            for (ITaskActivityListener listener : new ArrayList<ITaskActivityListener>(this.activityListeners)) {
                try {
                    listener.elapsedTimeUpdated(task, elapsedTime);
                }
                catch (Throwable t) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Task activity listener failed: \"" + listener + "\"", t));
                }
            }
        }
    }

    public void addWorkingSetElapsedTime(String workingSetName, Date startDate, Date endDate) {
        Long daysActivity;
        Assert.isNotNull((Object)workingSetName);
        Assert.isNotNull((Object)startDate);
        Assert.isNotNull((Object)endDate);
        long attentionSpan = endDate.getTime() - startDate.getTime();
        if (attentionSpan <= 0L) {
            return;
        }
        Calendar hourOfDay = TaskActivityUtil.getCalendar();
        hourOfDay.setTime(startDate);
        this.snapToStartOfHour(hourOfDay);
        SortedMap<Calendar, Long> noTaskActiveMap = this.workingSetElapsedTimeMap.get(workingSetName);
        if (noTaskActiveMap == null) {
            noTaskActiveMap = Collections.synchronizedSortedMap(new TreeMap());
            this.workingSetElapsedTimeMap.put(workingSetName, noTaskActiveMap);
        }
        if ((daysActivity = (Long)noTaskActiveMap.get(hourOfDay)) == null) {
            daysActivity = new Long(0L);
        }
        daysActivity = daysActivity + attentionSpan;
        noTaskActiveMap.put(hourOfDay, daysActivity);
    }

    public long getElapsedForWorkingSet(String workingSetId, Calendar startDate, Calendar endDate) {
        Calendar startRange = this.snapToStartOfHour(this.getNewInstance(startDate));
        Calendar endRange = this.snapToEndOfHour(this.getNewInstance(endDate));
        long result = 0L;
        SortedMap<Calendar, Long> noTaskActiveMap = this.workingSetElapsedTimeMap.get(workingSetId);
        if (noTaskActiveMap != null) {
            SortedMap<Calendar, Long> subMap = noTaskActiveMap.subMap(startRange, endRange);
            for (Long time : subMap.values()) {
                if (time == null || time <= 0L) continue;
                result += time.longValue();
            }
        }
        return result;
    }

    public Set<String> getWorkingSets() {
        return this.workingSetElapsedTimeMap.keySet();
    }

    public void addElapsedTime(AbstractTask task, Date startDate, Date endDate) {
        long attentionSpan;
        Assert.isNotNull((Object)task);
        Assert.isNotNull((Object)startDate);
        Assert.isNotNull((Object)endDate);
        SortedMap<Calendar, Long> activityMap = this.taskElapsedTimeMap.get(task);
        if (activityMap == null) {
            activityMap = Collections.synchronizedSortedMap(new TreeMap());
            this.taskElapsedTimeMap.put(task, activityMap);
        }
        if ((attentionSpan = endDate.getTime() - startDate.getTime()) <= 0L) {
            return;
        }
        Calendar hourOfDay = TaskActivityUtil.getCalendar();
        hourOfDay.setTime(startDate);
        this.snapToStartOfHour(hourOfDay);
        Long daysActivity = (Long)activityMap.get(hourOfDay);
        if (daysActivity == null) {
            daysActivity = new Long(0L);
        }
        daysActivity = daysActivity + attentionSpan;
        activityMap.put(hourOfDay, daysActivity);
        HashSet<AbstractTask> active = (HashSet<AbstractTask>)this.activeTasks.get(hourOfDay);
        if (active == null) {
            active = new HashSet<AbstractTask>();
            this.activeTasks.put(hourOfDay, active);
        }
        active.add(task);
        long totalElapsed = this.getElapsedTime(activityMap);
        for (ITaskActivityListener listener : new ArrayList<ITaskActivityListener>(this.activityListeners)) {
            try {
                listener.elapsedTimeUpdated(task, totalElapsed);
            }
            catch (Throwable t) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Task activity listener failed: \"" + listener + "\"", t));
            }
        }
    }

    private Calendar getNewInstance(Calendar cal) {
        Calendar newCal = TaskActivityUtil.getCalendar();
        newCal.setTimeInMillis(cal.getTimeInMillis());
        return newCal;
    }

    public void addScheduledTask(AbstractTask task) {
        DateRange range = task.getScheduledForDate();
        if (range != null) {
            CopyOnWriteArraySet<AbstractTask> tasks = (CopyOnWriteArraySet<AbstractTask>)this.scheduledTasks.get(range);
            if (tasks == null) {
                tasks = new CopyOnWriteArraySet<AbstractTask>();
                this.scheduledTasks.put(range, tasks);
            }
            tasks.add(task);
            this.allScheduledTasks.add(task);
        } else {
            this.removeScheduledTask(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeScheduledTask(ITask task) {
        SortedMap<DateRange, Set<ITask>> sortedMap = this.scheduledTasks;
        synchronized (sortedMap) {
            for (Set<ITask> setOfTasks : this.scheduledTasks.values()) {
                setOfTasks.remove(task);
            }
            this.allScheduledTasks.remove(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ITask> getScheduledTasks(DateRange range) {
        HashSet<ITask> resultingTasks = new HashSet<ITask>();
        SortedMap<DateRange, Set<ITask>> sortedMap = this.scheduledTasks;
        synchronized (sortedMap) {
            Set result = (Set)this.scheduledTasks.get(range);
            if (result != null && !result.isEmpty()) {
                resultingTasks.addAll(result);
            } else if (!(range instanceof WeekDateRange)) {
                return this.getScheduledTasks(range.getStartDate(), range.getEndDate());
            }
            if (range instanceof WeekDateRange && TaskActivityUtil.getNextWeek().next().compareTo(range) == 0) {
                resultingTasks.addAll(this.getScheduledTasks(range.getStartDate(), range.getEndDate()));
            }
        }
        return resultingTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ITask> getScheduledTasks(Calendar start, Calendar end) {
        HashSet<ITask> resultingTasks = new HashSet<ITask>();
        SortedMap<DateRange, Set<ITask>> sortedMap = this.scheduledTasks;
        synchronized (sortedMap) {
            DateRange startRange = new DateRange(start);
            Calendar endExclusive = TaskActivityUtil.getCalendar();
            endExclusive.setTimeInMillis(end.getTimeInMillis() + 1L);
            DateRange endRange = new DateRange(endExclusive);
            SortedMap<DateRange, Set<ITask>> result = this.scheduledTasks.subMap(startRange, endRange);
            for (Map.Entry<DateRange, Set<ITask>> entry : result.entrySet()) {
                DateRange range = entry.getKey();
                if (start.compareTo(range.getStartDate()) > 0 || end.compareTo(range.getEndDate()) < 0) continue;
                resultingTasks.addAll((Collection<ITask>)entry.getValue());
            }
        }
        return resultingTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDueTask(ITask task) {
        if (task.getDueDate() == null) {
            this.removeDueTask(task);
            return;
        }
        Calendar time = TaskActivityUtil.getCalendar();
        time.setTime(task.getDueDate());
        this.snapToStartOfHour(time);
        SortedMap<Calendar, Set<ITask>> sortedMap = this.dueTasks;
        synchronized (sortedMap) {
            CopyOnWriteArraySet<ITask> tasks = (CopyOnWriteArraySet<ITask>)this.dueTasks.get(time);
            if (tasks == null) {
                tasks = new CopyOnWriteArraySet<ITask>();
                this.dueTasks.put(time, tasks);
            }
            tasks.add(task);
            this.allDueTasks.add(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDueTask(ITask task) {
        SortedMap<Calendar, Set<ITask>> sortedMap = this.dueTasks;
        synchronized (sortedMap) {
            for (Set<ITask> setOfTasks : this.dueTasks.values()) {
                setOfTasks.remove(task);
            }
            this.allDueTasks.remove(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ITask> getDueTasks(Calendar start, Calendar end) {
        HashSet<ITask> resultingTasks = new HashSet<ITask>();
        SortedMap<Calendar, Set<ITask>> result = this.dueTasks.subMap(start, end);
        SortedMap<Calendar, Set<ITask>> sortedMap = this.dueTasks;
        synchronized (sortedMap) {
            for (Set<ITask> set : result.values()) {
                resultingTasks.addAll(set);
            }
        }
        return resultingTasks;
    }

    @Override
    public void activateTask(ITask task) {
        if (this.activeTask != null) {
            if (!this.shouldDeactivateTask(this.activeTask)) {
                return;
            }
            this.deactivateTaskInternal(this.activeTask);
        }
        this.taskList.addTaskIfAbsent(task);
        this.initTaskListeners();
        for (ITaskActivationListener listener : new ArrayList<ITaskActivationListener>(this.activationListeners)) {
            try {
                listener.preTaskActivated(task);
            }
            catch (Throwable t) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Task activity listener failed: " + listener, t));
            }
        }
        this.activeTask = task;
        ((AbstractTask)this.activeTask).setActive(true);
        for (ITaskActivationListener listener : new ArrayList<ITaskActivationListener>(this.activationListeners)) {
            try {
                listener.taskActivated(task);
            }
            catch (Throwable t) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Task activity listener failed: " + listener, t));
            }
        }
    }

    @Override
    public void deactivateActiveTask() {
        if (this.activeTask != null) {
            this.deactivateTask(this.activeTask);
        }
    }

    @Override
    public void deactivateTask(ITask task) {
        if (task == null || task.isActive() && !this.shouldDeactivateTask(task)) {
            return;
        }
        this.deactivateTaskInternal(task);
    }

    protected void deactivateTaskInternal(ITask task) {
        if (task.isActive() && task == this.activeTask) {
            this.initTaskListeners();
            for (ITaskActivationListener listener : new ArrayList<ITaskActivationListener>(this.activationListeners)) {
                try {
                    listener.preTaskDeactivated(task);
                }
                catch (Throwable t) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Notification failed for: " + listener, t));
                }
            }
            ((AbstractTask)this.activeTask).setActive(false);
            this.activeTask = null;
            for (ITaskActivationListener listener : new ArrayList<ITaskActivationListener>(this.activationListeners)) {
                try {
                    listener.taskDeactivated(task);
                }
                catch (Throwable t) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Notification failed for: " + listener, t));
                }
            }
        } else {
            ((AbstractTask)task).setActive(false);
        }
    }

    protected boolean shouldDeactivateTask(ITask task) {
        for (ITaskActivationListener listener : new ArrayList<ITaskActivationListener>(this.activationListeners)) {
            try {
                if (!(listener instanceof TaskActivationAdapter) || ((TaskActivationAdapter)listener).canDeactivateTask(task)) continue;
                return false;
            }
            catch (Throwable t) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Task activity listener failed: " + listener, t));
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<AbstractTask> getActiveTasks(Calendar start, Calendar end) {
        HashSet<AbstractTask> resultingTasks = new HashSet<AbstractTask>();
        Calendar startInternal = TaskActivityUtil.getCalendar();
        startInternal.setTimeInMillis(start.getTimeInMillis());
        TaskActivityUtil.snapStartOfHour(startInternal);
        Calendar endInternal = TaskActivityUtil.getCalendar();
        endInternal.setTimeInMillis(end.getTimeInMillis());
        TaskActivityUtil.snapStartOfHour(endInternal);
        SortedMap<Calendar, Set<AbstractTask>> sortedMap = this.activeTasks;
        synchronized (sortedMap) {
            SortedMap<Calendar, Set<AbstractTask>> result = this.activeTasks.subMap(startInternal, endInternal);
            for (Set<AbstractTask> set : result.values()) {
                resultingTasks.addAll(set);
            }
        }
        return resultingTasks;
    }

    @Override
    public long getElapsedTime(ITask task) {
        SortedMap<Calendar, Long> activityMap = this.taskElapsedTimeMap.get(task);
        return this.getElapsedTime(activityMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getElapsedTime(SortedMap<Calendar, Long> activityMap) {
        long result = 0L;
        if (activityMap != null) {
            SortedMap<Calendar, Long> sortedMap = activityMap;
            synchronized (sortedMap) {
                for (Long time : activityMap.values()) {
                    if (time == null) continue;
                    result += time.longValue();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getElapsedTime(ITask task, Calendar start, Calendar end) {
        if (task == null) {
            return 0L;
        }
        long result = 0L;
        Calendar startRange = this.snapToStartOfHour(this.getNewInstance(start));
        Calendar endRange = this.snapToEndOfHour(this.getNewInstance(end));
        SortedMap<Calendar, Long> activityMap = this.taskElapsedTimeMap.get(task);
        if (activityMap != null) {
            SortedMap<Calendar, Long> sortedMap = activityMap;
            synchronized (sortedMap) {
                activityMap = activityMap.subMap(startRange, endRange);
                for (Long time : activityMap.values()) {
                    if (time == null) continue;
                    result += time.longValue();
                }
            }
        }
        return result;
    }

    public long getElapsedTime(ITask task, DateRange range) {
        return this.getElapsedTime(task, range.getStartDate(), range.getEndDate());
    }

    private Calendar snapToStartOfHour(Calendar cal) {
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.getTime();
        return cal;
    }

    private Calendar snapToEndOfHour(Calendar cal) {
        cal.set(12, cal.getMaximum(12));
        cal.set(13, cal.getMaximum(13));
        cal.set(14, cal.getMaximum(14));
        cal.getTime();
        return cal;
    }

    @Override
    public ITask getActiveTask() {
        return this.activeTask;
    }

    private void reloadScheduledData() {
        for (AbstractTask task : this.taskList.getAllTasks()) {
            if (task.getScheduledForDate() != null) {
                this.addScheduledTask(task);
            }
            if (task.getDueDate() == null) continue;
            this.addDueTask(task);
        }
    }

    public void setScheduledFor(AbstractTask task, DateRange reminderDate) {
        Assert.isNotNull((Object)task);
        if (reminderDate != null && !reminderDate.equals(task.getScheduledForDate())) {
            task.setReminded(false);
        }
        task.setScheduledForDate(reminderDate);
        if (reminderDate == null) {
            this.removeScheduledTask(task);
        } else {
            this.removeScheduledTask(task);
            this.addScheduledTask(task);
        }
        this.taskList.notifyElementChanged(task);
    }

    public void setDueDate(ITask task, Date dueDate) {
        task.setDueDate(dueDate);
        if (dueDate == null) {
            this.removeDueTask(task);
        } else {
            this.removeDueTask(task);
            this.addDueTask(task);
        }
        this.taskList.notifyElementChanged(task);
    }

    public boolean isCompletedToday(ITask task) {
        if (task != null) {
            boolean isOwnedByUser = this.repositoryManager.isOwnedByUser(task);
            if (!isOwnedByUser) {
                return false;
            }
            Date completionDate = task.getCompletionDate();
            if (completionDate != null) {
                Calendar completedTime = TaskActivityUtil.getCalendar();
                completedTime.setTime(completionDate);
                return TaskActivityUtil.isToday(completedTime);
            }
        }
        return false;
    }

    public boolean isPastReminder(AbstractTask task) {
        if (task == null || task.isCompleted() || task.getScheduledForDate() == null) {
            return false;
        }
        return this.isPastReminder(task.getScheduledForDate(), task.isCompleted());
    }

    public boolean isPastReminder(DateRange date, boolean isComplete) {
        if (date == null || isComplete) {
            return false;
        }
        return date.getEndDate().compareTo(TaskActivityUtil.getCalendar()) < 0 && date instanceof DayDateRange;
    }

    public boolean isDueToday(ITask task) {
        if (this.repositoryManager.isOwnedByUser(task) && !task.isCompleted() && task.getDueDate() != null) {
            Calendar cal = TaskActivityUtil.getCalendar();
            cal.setTimeInMillis(task.getDueDate().getTime());
            if (TaskActivityUtil.isToday(cal)) {
                return true;
            }
        }
        return false;
    }

    public boolean isOverdue(ITask task) {
        return !task.isCompleted() && task.getDueDate() != null && new Date().after(task.getDueDate()) && this.repositoryManager.isOwnedByUser(task);
    }

    public boolean isOverdueForOther(ITask task) {
        return !task.isCompleted() && task.getDueDate() != null && new Date().after(task.getDueDate()) && !this.repositoryManager.isOwnedByUser(task);
    }

    public boolean isOwnedByUser(ITask task) {
        return this.repositoryManager.isOwnedByUser(task);
    }

    public boolean isActiveThisWeek(ITask task) {
        Calendar calStart = TaskActivityUtil.getCalendar();
        TaskActivityUtil.snapStartOfWorkWeek(calStart);
        Calendar calEnd = TaskActivityUtil.getCalendar();
        TaskActivityUtil.snapEndOfWeek(calEnd);
        return this.getElapsedTime(task, calStart, calEnd) > 0L;
    }

    public boolean isScheduledForToday(AbstractTask task) {
        if (task != null && task.getScheduledForDate() != null) {
            return this.isScheduledForToday(task.getScheduledForDate());
        }
        return false;
    }

    public boolean isScheduledForToday(DateRange range) {
        if (range != null) {
            return TaskActivityUtil.getCurrentWeek().getToday().compareTo(range) == 0;
        }
        return false;
    }

    public boolean isScheduledAfterThisWeek(AbstractTask task) {
        if (task != null && task.getScheduledForDate() != null) {
            return this.isScheduledAfterThisWeek(task.getScheduledForDate());
        }
        return false;
    }

    public boolean isScheduledAfterThisWeek(DateRange range) {
        if (range != null) {
            return TaskActivityUtil.isAfterCurrentWeek(range.getStartDate());
        }
        return false;
    }

    public boolean isScheduledForFuture(AbstractTask task) {
        if (task != null && task.getScheduledForDate() != null) {
            return this.isScheduledForFuture(task.getScheduledForDate());
        }
        return false;
    }

    public boolean isScheduledForFuture(DateRange reminder) {
        if (reminder != null) {
            return TaskActivityUtil.isFuture(reminder.getStartDate());
        }
        return false;
    }

    public boolean isScheduledForThisWeek(AbstractTask task) {
        boolean result = false;
        if (task != null && task.getScheduledForDate() != null) {
            result = this.isScheduledForThisWeek(task.getScheduledForDate());
        }
        return result;
    }

    public boolean isScheduledForThisWeek(DateRange range) {
        if (range != null) {
            return TaskActivityUtil.getCurrentWeek().isCurrentWeekDay(range) || TaskActivityUtil.getCurrentWeek().compareTo(range) == 0;
        }
        return false;
    }

    public boolean isSheduledForPastWeek(AbstractTask task) {
        boolean result = false;
        if (task != null && task.getScheduledForDate() != null) {
            result = this.isSheduledForPastWeek(task.getScheduledForDate());
        }
        return result;
    }

    private boolean isSheduledForPastWeek(DateRange range) {
        if (range != null) {
            return range instanceof WeekDateRange && range.isPast();
        }
        return false;
    }

    public boolean isScheduledForNextWeek(AbstractTask task) {
        DateRange range;
        if (task != null && (range = task.getScheduledForDate()) != null) {
            return TaskActivityUtil.isNextWeek(range.getStartDate());
        }
        return false;
    }

    public void scheduleNewTask(AbstractTask newTask) {
        newTask.setCreationDate(new Date());
        this.setScheduledFor(newTask, TaskActivityUtil.getCurrentWeek());
    }

    public boolean isDueThisWeek(ITask task) {
        Date due = task.getDueDate();
        if (due != null && this.repositoryManager.isOwnedByUser(task)) {
            Calendar cal = TaskActivityUtil.getCalendar();
            cal.setTime(due);
            return TaskActivityUtil.isThisWeek(cal);
        }
        return false;
    }

    public Set<ITask> getScheduledForADayThisWeek() {
        WeekDateRange current = TaskActivityUtil.getCurrentWeek();
        return this.getScheduledTasks(current.getStartDate(), current.getEndDate());
    }

    public TaskActivationHistory getTaskActivationHistory() {
        return this.taskActivationHistory;
    }

    @Override
    public Date getFirstActivity(ITask task) {
        SortedMap<Calendar, Long> activityMap = this.taskElapsedTimeMap.get(task);
        if (activityMap != null && !activityMap.isEmpty()) {
            return activityMap.firstKey().getTime();
        }
        return null;
    }

    @Override
    public Date getLastActivity(ITask task) {
        SortedMap<Calendar, Long> activityMap = this.taskElapsedTimeMap.get(task);
        if (activityMap != null && !activityMap.isEmpty()) {
            return activityMap.lastKey().getTime();
        }
        return null;
    }

    public Set<ITask> getAllScheduledTasks() {
        return new HashSet<ITask>(this.allScheduledTasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<AbstractTask> getAllScheduledTasksInternal() {
        HashSet<AbstractTask> tasks = new HashSet<AbstractTask>();
        SortedMap<DateRange, Set<ITask>> sortedMap = this.scheduledTasks;
        synchronized (sortedMap) {
            for (ITask task : this.allScheduledTasks) {
                if (!(task instanceof AbstractTask)) continue;
                tasks.add((AbstractTask)task);
            }
        }
        return tasks;
    }

    @Override
    public Set<ITask> getAllDueTasks() {
        return new HashSet<ITask>(this.allDueTasks);
    }

    public Set<ITask> getOverScheduledTasks() {
        HashSet<ITask> children = new HashSet<ITask>();
        Calendar start = TaskActivityUtil.getCalendar();
        start.setTimeInMillis(0L);
        Calendar end = TaskActivityUtil.getCalendar();
        TaskActivityUtil.snapStartOfDay(end);
        for (ITask task : this.getScheduledTasks(start, end)) {
            if (task.isCompleted()) continue;
            children.add(task);
        }
        return children;
    }

    public Collection<? extends ITask> getOverDueTasks() {
        HashSet<ITask> children = new HashSet<ITask>();
        Calendar start = TaskActivityUtil.getCalendar();
        start.setTimeInMillis(0L);
        Calendar end = TaskActivityUtil.getCalendar();
        TaskActivityUtil.snapStartOfHour(end);
        for (ITask task : this.getDueTasks(start, end)) {
            if (task.isCompleted() || !this.repositoryManager.isOwnedByUser(task)) continue;
            children.add(task);
        }
        return children;
    }

    public Collection<AbstractTask> getUnscheduled() {
        HashSet<AbstractTask> allTasks = new HashSet<AbstractTask>(this.taskList.getAllTasks());
        for (ITask abstractTask : this.getAllScheduledTasks()) {
            allTasks.remove(abstractTask);
        }
        return allTasks;
    }

    @Override
    public boolean isActive(ITask task) {
        Assert.isNotNull((Object)task);
        return task.equals(this.getActiveTask());
    }
}

