/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.text.CharacterIterator;

class CharSequenceCharacterIterator
implements CharacterIterator {
    private final CharSequence charSequence;
    private int index;

    public CharSequenceCharacterIterator(CharSequence charSequence) {
        if (charSequence == null) {
            throw new NullPointerException();
        }
        this.charSequence = charSequence;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public char setIndex(int position) {
        if (position < this.getBeginIndex() || position > this.getEndIndex()) {
            throw new IllegalArgumentException();
        }
        this.index = position;
        return this.current();
    }

    @Override
    public char current() {
        return this.index == this.getEndIndex() ? (char)'\uffff' : this.charSequence.charAt(this.index);
    }

    @Override
    public char first() {
        return this.setIndex(this.getBeginIndex());
    }

    @Override
    public char last() {
        int endIndex = this.getEndIndex();
        return this.setIndex(this.charSequence.length() == 0 ? endIndex : endIndex - 1);
    }

    @Override
    public char next() {
        if (this.index < this.getEndIndex()) {
            ++this.index;
        }
        return this.current();
    }

    @Override
    public char previous() {
        if (this.index > this.getBeginIndex()) {
            --this.index;
            return this.current();
        }
        return '\uffff';
    }

    @Override
    public int getBeginIndex() {
        return 0;
    }

    @Override
    public int getEndIndex() {
        return this.charSequence.length();
    }

    @Override
    public Object clone() {
        CharSequenceCharacterIterator ret = new CharSequenceCharacterIterator(this.charSequence);
        ret.setIndex(this.index);
        return ret;
    }
}

