/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.jpacontroller;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.Project;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;
import org.netbeans.spi.queries.FileEncodingQueryImplementation;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.util.Utilities;

public class JpaControllerUtil {
    public static final int REL_NONE = 0;
    public static final int REL_TO_ONE = 1;
    public static final int REL_TO_MANY = 2;

    public static Charset getProjectEncoding(Project project, FileObject file) {
        Charset encoding = ((FileEncodingQueryImplementation)project.getLookup().lookup(FileEncodingQueryImplementation.class)).getEncoding(file);
        if (encoding == null) {
            encoding = FileEncodingQuery.getDefaultEncoding();
            if (encoding == null) {
                return StandardCharsets.UTF_8;
            }
            return encoding;
        }
        return encoding;
    }

    public static String getProjectEncodingAsString(Project project, FileObject file) {
        Charset encoding = ((FileEncodingQueryImplementation)project.getLookup().lookup(FileEncodingQueryImplementation.class)).getEncoding(file);
        if (encoding == null) {
            encoding = FileEncodingQuery.getDefaultEncoding();
            if (encoding == null) {
                return "UTF-8";
            }
            return encoding.name();
        }
        return encoding.name();
    }

    public static String simpleClassName(String fqn) {
        int lastDot = fqn.lastIndexOf(46);
        return lastDot > 0 ? fqn.substring(lastDot + 1) : fqn;
    }

    public static String readResource(InputStream is, String encoding) throws IOException {
        StringBuilder sbuffer = new StringBuilder();
        String lineSep = System.getProperty("line.separator");
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is, encoding));){
            String line = br.readLine();
            while (line != null) {
                sbuffer.append(line);
                sbuffer.append(lineSep);
                line = br.readLine();
            }
        }
        return sbuffer.toString();
    }

    public static void createFile(FileObject target, String content, String encoding) throws IOException {
        try (FileLock lock = target.lock();
             BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(target.getOutputStream(lock), encoding));){
            bw.write(content);
        }
    }

    public static boolean isFieldAccess(TypeElement clazz) {
        boolean fieldAccess = false;
        boolean accessTypeDetected = false;
        TypeElement typeElement = clazz;
        Name qualifiedName = typeElement.getQualifiedName();
        block0: while (typeElement != null) {
            if (JpaControllerUtil.isAnnotatedWith(typeElement, "jakarta.persistence.Entity") || JpaControllerUtil.isAnnotatedWith(typeElement, "jakarta.persistence.MappedSuperclass") || JpaControllerUtil.isAnnotatedWith(typeElement, "javax.persistence.Entity") || JpaControllerUtil.isAnnotatedWith(typeElement, "javax.persistence.MappedSuperclass")) {
                for (Element element : typeElement.getEnclosedElements()) {
                    if (!JpaControllerUtil.isAnnotatedWith(element, "jakarta.persistence.Id") && !JpaControllerUtil.isAnnotatedWith(element, "jakarta.persistence.EmbeddedId") && !JpaControllerUtil.isAnnotatedWith(element, "javax.persistence.Id") && !JpaControllerUtil.isAnnotatedWith(element, "javax.persistence.EmbeddedId")) continue;
                    if (ElementKind.FIELD == element.getKind()) {
                        fieldAccess = true;
                    }
                    accessTypeDetected = true;
                    break block0;
                }
            }
            typeElement = JpaControllerUtil.getSuperclassTypeElement(typeElement);
        }
        if (!accessTypeDetected) {
            Logger.getLogger(JpaControllerUtil.class.getName()).log(Level.WARNING, "Failed to detect correct access type for class: {0}", qualifiedName);
        }
        return fieldAccess;
    }

    public static boolean isAnnotatedWith(Element element, String annotationFqn) {
        return JpaControllerUtil.findAnnotation(element, annotationFqn) != null;
    }

    public static AnnotationMirror findAnnotation(Element element, String annotationFqn) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            String annotationQualifiedName = JpaControllerUtil.getAnnotationQualifiedName(annotationMirror);
            if (!annotationQualifiedName.equals(annotationFqn)) continue;
            return annotationMirror;
        }
        return null;
    }

    public static String getAnnotationQualifiedName(AnnotationMirror annotationMirror) {
        DeclaredType annotationDeclaredType = annotationMirror.getAnnotationType();
        TypeElement annotationTypeElement = (TypeElement)annotationDeclaredType.asElement();
        Name name = annotationTypeElement.getQualifiedName();
        return name.toString();
    }

    public static TypeElement getSuperclassTypeElement(TypeElement typeElement) {
        DeclaredType superclassDeclaredType;
        Element superclassElement;
        TypeElement superclass = null;
        TypeMirror superclassMirror = typeElement.getSuperclass();
        if (superclassMirror.getKind() == TypeKind.DECLARED && (superclassElement = (superclassDeclaredType = (DeclaredType)superclassMirror).asElement()).getKind() == ElementKind.CLASS && superclassElement instanceof TypeElement) {
            superclass = (TypeElement)superclassElement;
        }
        return superclass;
    }

    public static String findAnnotationValueAsString(AnnotationMirror annotation, String annotationKey) {
        String value = null;
        Map<? extends ExecutableElement, ? extends AnnotationValue> annotationMap = annotation.getElementValues();
        for (ExecutableElement executableElement : annotationMap.keySet()) {
            if (!annotationKey.equals(executableElement.getSimpleName().toString())) continue;
            AnnotationValue annotationValue = annotationMap.get(executableElement);
            value = annotationValue.getValue().toString();
            break;
        }
        return value;
    }

    public static List<AnnotationMirror> findNestedAnnotations(AnnotationMirror annotationMirror, String annotationFqn) {
        ArrayList<AnnotationMirror> result = new ArrayList<AnnotationMirror>();
        JpaControllerUtil.findNestedAnnotationsInternal(annotationMirror, annotationFqn, result);
        return result;
    }

    private static void findNestedAnnotationsInternal(Object object, String annotationFqn, List<AnnotationMirror> result) {
        Collection<? extends AnnotationValue> annotationValueCollection = null;
        if (object instanceof AnnotationMirror) {
            AnnotationMirror annotationMirror = (AnnotationMirror)object;
            String string = JpaControllerUtil.getAnnotationQualifiedName(annotationMirror);
            if (string.equals(annotationFqn)) {
                result.add(annotationMirror);
            } else {
                Map<? extends ExecutableElement, ? extends AnnotationValue> annotationMap = annotationMirror.getElementValues();
                annotationValueCollection = annotationMap.values();
            }
        } else if (object instanceof List) {
            annotationValueCollection = (Collection<? extends AnnotationValue>)object;
        }
        if (annotationValueCollection != null) {
            for (AnnotationValue annotationValue : annotationValueCollection) {
                Object value = annotationValue.getValue();
                JpaControllerUtil.findNestedAnnotationsInternal(value, annotationFqn, result);
            }
        }
    }

    public static String fieldFromClassName(String className) {
        String candidate;
        boolean makeFirstLower = className.length() == 1 || !Character.isUpperCase(className.charAt(1));
        String string = candidate = makeFirstLower ? className.substring(0, 1).toLowerCase() + className.substring(1) : className;
        if (!Utilities.isJavaIdentifier((String)candidate)) {
            candidate = candidate + "1";
        }
        return candidate;
    }

    public static String getPropNameFromMethod(String name) {
        if (!name.startsWith("get") && !name.startsWith("set")) {
            return name + "()";
        }
        boolean makeFirstLower = name.length() < 5 || !Character.isUpperCase(name.charAt(4));
        return makeFirstLower ? name.substring(3, 4).toLowerCase() + name.substring(4) : name.substring(3);
    }

    public static boolean isEmbeddableClass(TypeElement typeElement) {
        return JpaControllerUtil.isAnnotatedWith(typeElement, "jakarta.persistence.Embeddable") || JpaControllerUtil.isAnnotatedWith(typeElement, "javax.persistence.Embeddable");
    }

    public static int isRelationship(ExecutableElement method, boolean isFieldAccess) {
        Element element;
        Element element2 = element = isFieldAccess ? JpaControllerUtil.guessField(method) : method;
        if (element != null) {
            if (JpaControllerUtil.isAnnotatedWith(element, "jakarta.persistence.OneToOne") || JpaControllerUtil.isAnnotatedWith(element, "jakarta.persistence.ManyToOne") || JpaControllerUtil.isAnnotatedWith(element, "javax.persistence.OneToOne") || JpaControllerUtil.isAnnotatedWith(element, "javax.persistence.ManyToOne")) {
                return 1;
            }
            if (JpaControllerUtil.isAnnotatedWith(element, "jakarta.persistence.OneToMany") || JpaControllerUtil.isAnnotatedWith(element, "jakarta.persistence.ManyToMany") || JpaControllerUtil.isAnnotatedWith(element, "javax.persistence.OneToMany") || JpaControllerUtil.isAnnotatedWith(element, "javax.persistence.ManyToMany")) {
                return 2;
            }
        }
        return 0;
    }

    public static ExecutableElement getOtherSideOfRelation(CompilationController controller, ExecutableElement executableElement, boolean isFieldAccess) {
        TypeMirror passedReturnType = executableElement.getReturnType();
        if (TypeKind.DECLARED != passedReturnType.getKind() || !(passedReturnType instanceof DeclaredType)) {
            return null;
        }
        Types types = controller.getTypes();
        TypeMirror passedReturnTypeStripped = JpaControllerUtil.stripCollection((DeclaredType)passedReturnType, types);
        if (passedReturnTypeStripped == null) {
            return null;
        }
        TypeElement passedReturnTypeStrippedElement = (TypeElement)types.asElement(passedReturnTypeStripped);
        Element possiblyAnnotatedElement = isFieldAccess ? JpaControllerUtil.guessField(executableElement) : executableElement;
        String mappedBy = null;
        AnnotationMirror persistenceAnnotation = JpaControllerUtil.findAnnotation(possiblyAnnotatedElement, "jakarta.persistence.OneToOne");
        if (persistenceAnnotation == null) {
            persistenceAnnotation = JpaControllerUtil.findAnnotation(possiblyAnnotatedElement, "jakarta.persistence.OneToMany");
        }
        if (persistenceAnnotation == null) {
            persistenceAnnotation = JpaControllerUtil.findAnnotation(possiblyAnnotatedElement, "jakarta.persistence.ManyToOne");
        }
        if (persistenceAnnotation == null) {
            persistenceAnnotation = JpaControllerUtil.findAnnotation(possiblyAnnotatedElement, "jakarta.persistence.ManyToMany");
        }
        if (persistenceAnnotation == null) {
            persistenceAnnotation = JpaControllerUtil.findAnnotation(possiblyAnnotatedElement, "javax.persistence.OneToOne");
        }
        if (persistenceAnnotation == null) {
            persistenceAnnotation = JpaControllerUtil.findAnnotation(possiblyAnnotatedElement, "javax.persistence.OneToMany");
        }
        if (persistenceAnnotation == null) {
            persistenceAnnotation = JpaControllerUtil.findAnnotation(possiblyAnnotatedElement, "javax.persistence.ManyToOne");
        }
        if (persistenceAnnotation == null) {
            persistenceAnnotation = JpaControllerUtil.findAnnotation(possiblyAnnotatedElement, "javax.persistence.ManyToMany");
        }
        if (persistenceAnnotation != null) {
            mappedBy = JpaControllerUtil.findAnnotationValueAsString(persistenceAnnotation, "mappedBy");
        }
        for (ExecutableElement method : JpaControllerUtil.getEntityMethods(passedReturnTypeStrippedElement)) {
            if (mappedBy != null && mappedBy.length() > 0) {
                String tail = mappedBy.length() > 1 ? mappedBy.substring(1) : "";
                String getterName = "get" + mappedBy.substring(0, 1).toUpperCase() + tail;
                if (!getterName.equals(method.getSimpleName().toString())) continue;
                return method;
            }
            TypeMirror iteratedReturnType = method.getReturnType();
            iteratedReturnType = JpaControllerUtil.stripCollection(iteratedReturnType, types);
            TypeMirror executableElementEnclosingType = executableElement.getEnclosingElement().asType();
            if (!types.isSameType(executableElementEnclosingType, iteratedReturnType)) continue;
            return method;
        }
        return null;
    }

    public static TypeMirror stripCollection(TypeMirror passedType, Types types) {
        if (TypeKind.DECLARED != passedType.getKind() || !(passedType instanceof DeclaredType)) {
            return passedType;
        }
        TypeElement passedTypeElement = (TypeElement)types.asElement(passedType);
        String passedTypeQualifiedName = passedTypeElement.getQualifiedName().toString();
        Class<?> passedTypeClass = null;
        try {
            passedTypeClass = Class.forName(passedTypeQualifiedName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (passedTypeClass != null && Collection.class.isAssignableFrom(passedTypeClass)) {
            List<? extends TypeMirror> passedTypeArgs = ((DeclaredType)passedType).getTypeArguments();
            if (passedTypeArgs.isEmpty()) {
                return passedType;
            }
            return passedTypeArgs.get(0);
        }
        return passedType;
    }

    public static boolean isFieldOptionalAndNullable(ExecutableElement method, boolean fieldAccess) {
        String[] fieldAnnotationFqns;
        Boolean isFieldOptionalBoolean;
        Element fieldElement;
        boolean isFieldOptional = true;
        Element element = fieldElement = fieldAccess ? JpaControllerUtil.guessField(method) : method;
        if (fieldElement == null) {
            fieldElement = method;
        }
        if ((isFieldOptionalBoolean = JpaControllerUtil.findAnnotationValueAsBoolean(fieldElement, fieldAnnotationFqns = new String[]{"jakarta.persistence.ManyToOne", "jakarta.persistence.OneToOne", "jakarta.persistence.Basic", "javax.persistence.ManyToOne", "javax.persistence.OneToOne", "javax.persistence.Basic"}, "optional")) != null) {
            isFieldOptional = isFieldOptionalBoolean;
        }
        if (!isFieldOptional) {
            return false;
        }
        fieldAnnotationFqns = new String[]{"jakarta.persistence.Column", "jakarta.persistence.JoinColumn", "javax.persistence.Column", "javax.persistence.JoinColumn"};
        Boolean isFieldNullable = JpaControllerUtil.findAnnotationValueAsBoolean(fieldElement, fieldAnnotationFqns, "nullable");
        if (isFieldNullable != null) {
            return isFieldNullable;
        }
        boolean result = true;
        AnnotationMirror fieldAnnotation = JpaControllerUtil.findAnnotation(fieldElement, "jakarta.persistence.JoinColumns");
        if (fieldAnnotation == null) {
            fieldAnnotation = JpaControllerUtil.findAnnotation(fieldElement, "javax.persistence.JoinColumns");
        }
        if (fieldAnnotation != null) {
            ArrayList<AnnotationMirror> joinColumnAnnotations = new ArrayList<AnnotationMirror>();
            joinColumnAnnotations.addAll(JpaControllerUtil.findNestedAnnotations(fieldAnnotation, "jakarta.persistence.JoinColumn"));
            joinColumnAnnotations.addAll(JpaControllerUtil.findNestedAnnotations(fieldAnnotation, "javax.persistence.JoinColumn"));
            for (AnnotationMirror joinColumnAnnotation : joinColumnAnnotations) {
                String columnNullableValue = JpaControllerUtil.findAnnotationValueAsString(joinColumnAnnotation, "nullable");
                if (columnNullableValue != null) {
                    result = Boolean.parseBoolean(columnNullableValue);
                    if (!result) continue;
                    break;
                }
                result = true;
                break;
            }
        }
        return result;
    }

    private static Boolean findAnnotationValueAsBoolean(Element fieldElement, String[] fieldAnnotationFqns, String annotationKey) {
        Boolean isFieldXable = null;
        for (int i = 0; i < fieldAnnotationFqns.length; ++i) {
            String fieldAnnotationFqn = fieldAnnotationFqns[i];
            AnnotationMirror fieldAnnotation = JpaControllerUtil.findAnnotation(fieldElement, fieldAnnotationFqn);
            if (fieldAnnotation == null) continue;
            String annotationValueString = JpaControllerUtil.findAnnotationValueAsString(fieldAnnotation, annotationKey);
            if (annotationValueString != null) {
                isFieldXable = Boolean.valueOf(annotationValueString);
                break;
            }
            isFieldXable = Boolean.TRUE;
            break;
        }
        return isFieldXable;
    }

    public static boolean haveId(TypeElement clazz) {
        boolean idDetected = false;
        TypeElement typeElement = clazz;
        while (typeElement != null && !idDetected) {
            if (JpaControllerUtil.isAnnotatedWith(typeElement, "jakarta.persistence.Entity") || JpaControllerUtil.isAnnotatedWith(typeElement, "jakarta.persistence.MappedSuperclass") || JpaControllerUtil.isAnnotatedWith(typeElement, "javax.persistence.Entity") || JpaControllerUtil.isAnnotatedWith(typeElement, "javax.persistence.MappedSuperclass")) {
                for (Element element : typeElement.getEnclosedElements()) {
                    if (!JpaControllerUtil.isAnnotatedWith(element, "jakarta.persistence.Id") && !JpaControllerUtil.isAnnotatedWith(element, "jakarta.persistence.EmbeddedId") && !JpaControllerUtil.isAnnotatedWith(element, "javax.persistence.Id") && !JpaControllerUtil.isAnnotatedWith(element, "javax.persistence.EmbeddedId")) continue;
                    idDetected = true;
                }
            }
            typeElement = JpaControllerUtil.getSuperclassTypeElement(typeElement);
        }
        return idDetected;
    }

    public static ExecutableElement getIdGetter(boolean isFieldAccess, TypeElement typeElement) {
        ExecutableElement[] methods;
        for (ExecutableElement method : methods = JpaControllerUtil.getEntityMethods(typeElement)) {
            Element element;
            String methodName = method.getSimpleName().toString();
            if (!methodName.startsWith("get")) continue;
            Element element2 = element = isFieldAccess ? JpaControllerUtil.guessField(method) : method;
            if (element == null || !JpaControllerUtil.isAnnotatedWith(element, "jakarta.persistence.Id") && !JpaControllerUtil.isAnnotatedWith(element, "jakarta.persistence.EmbeddedId") && !JpaControllerUtil.isAnnotatedWith(element, "javax.persistence.Id") && !JpaControllerUtil.isAnnotatedWith(element, "javax.persistence.EmbeddedId")) continue;
            return method;
        }
        Logger.getLogger(JpaControllerUtil.class.getName()).log(Level.WARNING, "Cannot find ID getter in class: {0}", typeElement.getQualifiedName());
        return null;
    }

    public static boolean isGenerated(ExecutableElement method, boolean isFieldAccess) {
        Element element;
        Element element2 = element = isFieldAccess ? JpaControllerUtil.guessField(method) : method;
        return element != null && (JpaControllerUtil.isAnnotatedWith(element, "jakarta.persistence.GeneratedValue") || JpaControllerUtil.isAnnotatedWith(element, "javax.persistence.GeneratedValue"));
    }

    public static boolean exceptionsThrownIncludes(WorkingCopy workingCopy, String fqClass, String methodName, List<String> formalParamFqTypes, String exceptionFqClassMaybeIncluded) {
        List<String> exceptionsThrown = JpaControllerUtil.getExceptionsThrown(workingCopy, fqClass, methodName, formalParamFqTypes);
        for (String exception : exceptionsThrown) {
            if (!exceptionFqClassMaybeIncluded.equals(exception)) continue;
            return true;
        }
        return false;
    }

    public static List<String> getExceptionsThrown(WorkingCopy workingCopy, String fqClass, String methodName, List<String> formalParamFqTypes) {
        TypeElement suppliedTypeElement;
        if (formalParamFqTypes == null) {
            formalParamFqTypes = Collections.emptyList();
        }
        ExecutableElement desiredMethodElement = null;
        TypeElement typeElement = suppliedTypeElement = workingCopy.getElements().getTypeElement(fqClass);
        block0: while (typeElement != null) {
            for (ExecutableElement methodElement : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
                List<? extends VariableElement> formalParamElements;
                if (!methodElement.getSimpleName().contentEquals(methodName) || (formalParamElements = methodElement.getParameters()).size() != formalParamFqTypes.size()) continue;
                desiredMethodElement = methodElement;
                break block0;
            }
            typeElement = JpaControllerUtil.getSuperclassTypeElement(typeElement);
        }
        if (desiredMethodElement == null) {
            throw new IllegalArgumentException("Could not find " + methodName + " in " + fqClass);
        }
        ArrayList<String> result = new ArrayList<String>();
        List<? extends TypeMirror> thrownTypes = desiredMethodElement.getThrownTypes();
        for (TypeMirror typeMirror : thrownTypes) {
            if (typeMirror.getKind() == TypeKind.DECLARED) {
                DeclaredType thrownDeclaredType = (DeclaredType)typeMirror;
                TypeElement thrownElement = (TypeElement)thrownDeclaredType.asElement();
                String thrownFqClass = thrownElement.getQualifiedName().toString();
                result.add(thrownFqClass);
                continue;
            }
            result.add(null);
        }
        return result;
    }

    public static ExecutableElement[] getEntityMethods(TypeElement entityTypeElement) {
        LinkedList<ExecutableElement> result = new LinkedList<ExecutableElement>();
        TypeElement typeElement = entityTypeElement;
        while (typeElement != null) {
            if (JpaControllerUtil.isAnnotatedWith(typeElement, "jakarta.persistence.Entity") || JpaControllerUtil.isAnnotatedWith(typeElement, "jakarta.persistence.MappedSuperclass") || JpaControllerUtil.isAnnotatedWith(typeElement, "javax.persistence.Entity") || JpaControllerUtil.isAnnotatedWith(typeElement, "javax.persistence.MappedSuperclass")) {
                result.addAll(ElementFilter.methodsIn(typeElement.getEnclosedElements()));
            }
            typeElement = JpaControllerUtil.getSuperclassTypeElement(typeElement);
        }
        return result.toArray(new ExecutableElement[0]);
    }

    public static VariableElement guessField(ExecutableElement getter) {
        String name = getter.getSimpleName().toString().substring(3);
        String guessFieldName = name.substring(0, 1).toLowerCase() + name.substring(1);
        TypeElement typeElement = (TypeElement)getter.getEnclosingElement();
        for (VariableElement variableElement : ElementFilter.fieldsIn(typeElement.getEnclosedElements())) {
            if (!variableElement.getSimpleName().contentEquals(guessFieldName)) continue;
            return variableElement;
        }
        Logger.getLogger(JpaControllerUtil.class.getName()).log(Level.WARNING, "Cannot detect the field associated with property: {0}", guessFieldName);
        return null;
    }

    public static VariableElement guessGetter(ExecutableElement setter) {
        String name = setter.getSimpleName().toString().substring(3);
        String guessGetterName = "set" + name;
        TypeElement typeElement = (TypeElement)setter.getEnclosingElement();
        for (VariableElement variableElement : ElementFilter.fieldsIn(typeElement.getEnclosedElements())) {
            if (!variableElement.getSimpleName().contentEquals(guessGetterName)) continue;
            return variableElement;
        }
        Logger.getLogger(JpaControllerUtil.class.getName()).log(Level.INFO, "Cannot detect setter associated with getter: {0}", guessGetterName);
        return null;
    }

    public static class AnnotationInfo {
        private String type;
        private String[] argNames;
        private Object[] argValues;

        public AnnotationInfo(String type) {
            if (type == null) {
                throw new IllegalArgumentException();
            }
            this.type = type;
        }

        public AnnotationInfo(String type, String[] argNames, Object[] argValues) {
            if (type == null) {
                throw new IllegalArgumentException();
            }
            this.type = type;
            if (argNames == null ? argValues != null : argValues == null || argValues.length != argNames.length) {
                throw new IllegalArgumentException();
            }
            this.argNames = argNames;
            this.argValues = argValues;
        }

        public String getType() {
            return this.type;
        }

        public String[] getArgNames() {
            return this.argNames;
        }

        public Object[] getArgValues() {
            return this.argValues;
        }
    }

    public static class MethodInfo {
        private String name;
        private int modifiers;
        private TypeInfo returnType;
        private TypeInfo[] exceptionTypes;
        private TypeInfo[] parameterTypes;
        private String[] parameterNames;
        private String methodBodyText;
        private AnnotationInfo[] annotations;
        private String commentText;

        public MethodInfo(String name, int modifiers, TypeInfo returnType, TypeInfo[] exceptionTypes, TypeInfo[] parameterTypes, String[] parameterNames, String methodBodyText, AnnotationInfo[] annotations, String commentText) {
            this.name = name;
            this.modifiers = modifiers;
            this.returnType = returnType;
            this.exceptionTypes = exceptionTypes;
            this.parameterTypes = parameterTypes;
            this.parameterNames = parameterNames;
            this.methodBodyText = methodBodyText;
            this.annotations = annotations;
            this.commentText = commentText;
        }

        public MethodInfo(String name, int modifiers, String returnType, String[] exceptionTypes, String[] parameterTypes, String[] parameterNames, String methodBodyText, AnnotationInfo[] annotations, String commentText) {
            this.name = name;
            this.modifiers = modifiers;
            this.returnType = new TypeInfo(returnType);
            this.exceptionTypes = TypeInfo.fromStrings(exceptionTypes);
            this.parameterTypes = TypeInfo.fromStrings(parameterTypes);
            this.parameterNames = parameterNames;
            this.methodBodyText = methodBodyText;
            this.annotations = annotations;
            this.commentText = commentText;
        }

        public String getName() {
            return this.name;
        }

        public int getModifiers() {
            return this.modifiers;
        }

        public TypeInfo getReturnType() {
            return this.returnType;
        }

        public TypeInfo[] getExceptionTypes() {
            return this.exceptionTypes;
        }

        public String getMethodBodyText() {
            return this.methodBodyText;
        }

        public TypeInfo[] getParameterTypes() {
            return this.parameterTypes;
        }

        public String[] getParameterNames() {
            return this.parameterNames;
        }

        public AnnotationInfo[] getAnnotations() {
            return this.annotations;
        }

        public String getCommentText() {
            return this.commentText;
        }
    }

    public static class TypeInfo {
        private String rawType;
        private TypeInfo[] declaredTypeParameters;

        public String getRawType() {
            return this.rawType;
        }

        public TypeInfo[] getDeclaredTypeParameters() {
            return this.declaredTypeParameters;
        }

        public TypeInfo(String rawType) {
            if (rawType == null) {
                throw new IllegalArgumentException();
            }
            this.rawType = rawType;
        }

        public TypeInfo(String rawType, TypeInfo[] declaredTypeParameters) {
            if (rawType == null) {
                throw new IllegalArgumentException();
            }
            this.rawType = rawType;
            if (declaredTypeParameters == null || declaredTypeParameters.length == 0) {
                return;
            }
            this.declaredTypeParameters = declaredTypeParameters;
        }

        public TypeInfo(String rawType, String[] declaredTypeParamStrings) {
            if (rawType == null) {
                throw new IllegalArgumentException();
            }
            this.rawType = rawType;
            if (declaredTypeParamStrings == null || declaredTypeParamStrings.length == 0) {
                return;
            }
            this.declaredTypeParameters = TypeInfo.fromStrings(declaredTypeParamStrings);
        }

        public static TypeInfo[] fromStrings(String[] strings) {
            if (strings == null || strings.length == 0) {
                return null;
            }
            TypeInfo[] typeInfos = new TypeInfo[strings.length];
            for (int i = 0; i < strings.length; ++i) {
                typeInfos[i] = new TypeInfo(strings[i]);
            }
            return typeInfos;
        }
    }

    public static class TreeMakerUtils {
        public static ClassTree addVariable(ClassTree classTree, WorkingCopy wc, String name, TypeInfo type, int modifiers, Object initializer, AnnotationInfo[] annotations) {
            Tree typeTree = TreeMakerUtils.createType(wc, type);
            ModifiersTree modTree = TreeMakerUtils.createModifiers(wc, modifiers, annotations);
            TreeMaker make = wc.getTreeMaker();
            VariableTree tree = make.Variable(modTree, (CharSequence)name, typeTree, (ExpressionTree)make.Literal(initializer));
            return make.addClassMember(classTree, (Tree)tree);
        }

        public static ClassTree addVariable(ClassTree classTree, WorkingCopy wc, String name, String type, int modifiers, Object initializer, AnnotationInfo[] annotations) {
            return TreeMakerUtils.addVariable(classTree, wc, name, new TypeInfo(type), modifiers, initializer, annotations);
        }

        private static VariableTree createVariable(WorkingCopy wc, String name, TypeInfo type) {
            return TreeMakerUtils.createVariable(wc, name, TreeMakerUtils.createType(wc, type));
        }

        private static VariableTree createVariable(WorkingCopy wc, String name, Tree type) {
            TreeMaker make = wc.getTreeMaker();
            return make.Variable(TreeMakerUtils.createModifiers(wc), (CharSequence)name, type, null);
        }

        public static ClassTree addMethod(ClassTree classTree, WorkingCopy wc, MethodInfo mInfo) {
            MethodTree tree = TreeMakerUtils.createMethod(wc, mInfo);
            return wc.getTreeMaker().addClassMember(classTree, (Tree)tree);
        }

        public static ClassTree modifyDefaultConstructor(ClassTree classTree, ClassTree modifiedClassTree, WorkingCopy wc, MethodInfo modifiedConstructorInfo) {
            if (!"<init>".equals(modifiedConstructorInfo.getName())) {
                throw new IllegalArgumentException("modifiedConstructorInfo name must be <init>");
            }
            MethodTree modifiedConstructor = TreeMakerUtils.createMethod(wc, modifiedConstructorInfo);
            MethodTree constructor = null;
            for (Tree tree : modifiedClassTree.getMembers()) {
                if (Tree.Kind.METHOD != tree.getKind()) continue;
                MethodTree mtree = (MethodTree)tree;
                List<? extends VariableTree> mTreeParameters = mtree.getParameters();
                if (!mtree.getName().toString().equals("<init>") || mTreeParameters != null && !mTreeParameters.isEmpty() || wc.getTreeUtilities().isSynthetic(wc.getTrees().getPath(wc.getCompilationUnit(), classTree))) continue;
                constructor = mtree;
                break;
            }
            if (constructor == null) {
                modifiedClassTree = wc.getTreeMaker().addClassMember(modifiedClassTree, (Tree)modifiedConstructor);
            } else {
                wc.rewrite(constructor, (Tree)modifiedConstructor);
            }
            return modifiedClassTree;
        }

        private static MethodTree createMethod(WorkingCopy wc, MethodInfo mInfo) {
            TreeMaker make = wc.getTreeMaker();
            TypeInfo[] pTypes = mInfo.getParameterTypes();
            String[] pNames = mInfo.getParameterNames();
            ArrayList<VariableTree> params = new ArrayList<VariableTree>();
            for (int i = 0; pTypes != null && i < pTypes.length; ++i) {
                VariableTree vtree = TreeMakerUtils.createVariable(wc, pNames[i], pTypes[i]);
                params.add(vtree);
            }
            TypeInfo[] excepTypes = mInfo.getExceptionTypes();
            ArrayList<ExpressionTree> throwsList = new ArrayList<ExpressionTree>();
            for (int i = 0; excepTypes != null && i < excepTypes.length; ++i) {
                throwsList.add((ExpressionTree)TreeMakerUtils.createType(wc, excepTypes[i]));
            }
            String body = mInfo.getMethodBodyText();
            if (body == null) {
                body = "";
            }
            MethodTree mtree = make.Method(TreeMakerUtils.createModifiers(wc, mInfo.getModifiers(), mInfo.getAnnotations()), (CharSequence)mInfo.getName(), TreeMakerUtils.createType(wc, mInfo.getReturnType()), Collections.emptyList(), params, throwsList, "{" + body + "}", null);
            return mtree;
        }

        private static Tree createType(WorkingCopy wc, TypeInfo type) {
            if (type == null) {
                return null;
            }
            String rawType = type.getRawType();
            TreeMaker make = wc.getTreeMaker();
            if (rawType.endsWith("[]")) {
                String rawTypeName = rawType.substring(0, rawType.length() - 2);
                TypeInfo scalarTypeInfo = new TypeInfo(rawTypeName, type.getDeclaredTypeParameters());
                return make.ArrayType(TreeMakerUtils.createType(wc, scalarTypeInfo));
            }
            TypeKind primitiveTypeKind = null;
            switch (rawType) {
                case "boolean": {
                    primitiveTypeKind = TypeKind.BOOLEAN;
                    break;
                }
                case "byte": {
                    primitiveTypeKind = TypeKind.BYTE;
                    break;
                }
                case "short": {
                    primitiveTypeKind = TypeKind.SHORT;
                    break;
                }
                case "int": {
                    primitiveTypeKind = TypeKind.INT;
                    break;
                }
                case "long": {
                    primitiveTypeKind = TypeKind.LONG;
                    break;
                }
                case "char": {
                    primitiveTypeKind = TypeKind.CHAR;
                    break;
                }
                case "float": {
                    primitiveTypeKind = TypeKind.FLOAT;
                    break;
                }
                case "double": {
                    primitiveTypeKind = TypeKind.DOUBLE;
                    break;
                }
                case "void": {
                    primitiveTypeKind = TypeKind.VOID;
                    break;
                }
            }
            if (primitiveTypeKind != null) {
                return make.PrimitiveType(primitiveTypeKind);
            }
            TypeInfo[] declaredTypeParameters = type.getDeclaredTypeParameters();
            if (declaredTypeParameters == null || declaredTypeParameters.length == 0) {
                TypeElement typeElement = wc.getElements().getTypeElement(rawType);
                if (typeElement == null) {
                    throw new IllegalArgumentException("Type " + rawType + " cannot be found");
                }
                return make.QualIdent((Element)typeElement);
            }
            TypeMirror typeMirror = TreeMakerUtils.getTypeMirror(wc, type);
            return make.Type(typeMirror);
        }

        private static TypeMirror getTypeMirror(WorkingCopy wc, TypeInfo type) {
            TreeMaker make = wc.getTreeMaker();
            String rawType = type.getRawType();
            TypeElement rawTypeElement = wc.getElements().getTypeElement(rawType);
            if (rawTypeElement == null) {
                throw new IllegalArgumentException("Type " + rawType + " cannot be found");
            }
            TypeInfo[] declaredTypeParameters = type.getDeclaredTypeParameters();
            if (declaredTypeParameters == null || declaredTypeParameters.length == 0) {
                make.QualIdent((Element)rawTypeElement);
                return rawTypeElement.asType();
            }
            TypeMirror[] declaredTypeMirrors = new TypeMirror[declaredTypeParameters.length];
            for (int i = 0; i < declaredTypeParameters.length; ++i) {
                declaredTypeMirrors[i] = TreeMakerUtils.getTypeMirror(wc, declaredTypeParameters[i]);
            }
            DeclaredType declaredType = wc.getTypes().getDeclaredType(rawTypeElement, declaredTypeMirrors);
            return declaredType;
        }

        private static ModifiersTree createModifiers(WorkingCopy wc) {
            return wc.getTreeMaker().Modifiers(Collections.emptySet(), Collections.emptyList());
        }

        private static ModifiersTree createModifiers(WorkingCopy wc, long flags, AnnotationInfo[] annotations) {
            if (annotations == null || annotations.length == 0) {
                return wc.getTreeMaker().Modifiers(flags, Collections.emptyList());
            }
            GenerationUtils generationUtils = GenerationUtils.newInstance((WorkingCopy)wc);
            ArrayList<AnnotationTree> annotationTrees = new ArrayList<AnnotationTree>();
            for (AnnotationInfo annotation : annotations) {
                String[] argNames = annotation.getArgNames();
                if (argNames != null && argNames.length > 0) {
                    Object[] argValues = annotation.getArgValues();
                    ArrayList<ExpressionTree> argTrees = new ArrayList<ExpressionTree>();
                    for (int i = 0; i < argNames.length; ++i) {
                        ExpressionTree argTree = generationUtils.createAnnotationArgument(argNames[i], argValues[i]);
                        argTrees.add(argTree);
                    }
                    AnnotationTree annotationTree = generationUtils.createAnnotation(annotation.getType(), argTrees);
                    annotationTrees.add(annotationTree);
                    continue;
                }
                AnnotationTree annotationTree = generationUtils.createAnnotation(annotation.getType());
                annotationTrees.add(annotationTree);
            }
            return wc.getTreeMaker().Modifiers(flags, annotationTrees);
        }

        public static CompilationUnitTree createImport(WorkingCopy wc, CompilationUnitTree modifiedCut, String fq) {
            if (modifiedCut == null) {
                modifiedCut = wc.getCompilationUnit();
            }
            List<? extends ImportTree> imports = modifiedCut.getImports();
            boolean found = false;
            for (ImportTree importTree : imports) {
                if (!fq.equals(importTree.getQualifiedIdentifier().toString())) continue;
                found = true;
                break;
            }
            if (!found) {
                TreeMaker make = wc.getTreeMaker();
                CompilationUnitTree compilationUnitTree = make.addCompUnitImport(modifiedCut, make.Import((Tree)make.Identifier((CharSequence)fq), false));
                wc.rewrite((Tree)wc.getCompilationUnit(), (Tree)compilationUnitTree);
                return compilationUnitTree;
            }
            return modifiedCut;
        }
    }

    private static class EmbeddedPkSupportInfo {
        private Map<String, ExecutableElement> joinColumnNameToRelationshipMethod = new HashMap<String, ExecutableElement>();
        private Map<ExecutableElement, List<String>> relationshipMethodToJoinColumnNames = new HashMap<ExecutableElement, List<String>>();
        private Map<String, String> joinColumnNameToReferencedColumnName = new HashMap<String, String>();
        private Map<String, String> columnNameToAccessorString = new HashMap<String, String>();
        private Map<String, String> columnNameToSetterString = new HashMap<String, String>();
        private Map<ExecutableElement, String> pkAccessorMethodToColumnName = new HashMap<ExecutableElement, String>();
        private Map<ExecutableElement, String> pkSetterMethodToColumnName = new HashMap<ExecutableElement, String>();
        private Map<ExecutableElement, String> pkAccessorMethodToPopulationCode = new HashMap<ExecutableElement, String>();
        private boolean isFieldAccess;

        public Set<ExecutableElement> getPkAccessorMethods() {
            return this.pkAccessorMethodToColumnName.keySet();
        }

        public ExecutableElement getRelationshipMethod(ExecutableElement pkAccessorMethod) {
            String columnName = this.pkAccessorMethodToColumnName.get(pkAccessorMethod);
            if (columnName == null) {
                return null;
            }
            return this.joinColumnNameToRelationshipMethod.get(columnName);
        }

        public String getReferencedColumnName(ExecutableElement pkAccessorMethod) {
            String columnName = this.pkAccessorMethodToColumnName.get(pkAccessorMethod);
            if (columnName == null) {
                return null;
            }
            return this.joinColumnNameToReferencedColumnName.get(columnName);
        }

        public String getAccessorString(String columnName) {
            return this.columnNameToAccessorString.get(columnName);
        }

        public String getSetterString(String columnName) {
            return this.columnNameToSetterString.get(columnName);
        }

        public String getCodeToPopulatePkField(ExecutableElement pkAccessorMethod) {
            return this.pkAccessorMethodToPopulationCode.get(pkAccessorMethod);
        }

        public void putCodeToPopulatePkField(ExecutableElement pkAccessorMethod, String code) {
            this.pkAccessorMethodToPopulationCode.put(pkAccessorMethod, code);
        }

        public boolean isRedundantWithPkFields(ExecutableElement relationshipMethod) {
            List<String> joinColumnNameList = this.relationshipMethodToJoinColumnNames.get(relationshipMethod);
            if (joinColumnNameList == null) {
                return false;
            }
            Collection<String> pkColumnNames = this.pkAccessorMethodToColumnName.values();
            for (String columnName : joinColumnNameList) {
                if (pkColumnNames.contains(columnName)) continue;
                return false;
            }
            return true;
        }

        EmbeddedPkSupportInfo(TypeElement type) {
            this.isFieldAccess = JpaControllerUtil.isFieldAccess(type);
            for (ExecutableElement method : JpaControllerUtil.getEntityMethods(type)) {
                String columnName;
                Element f;
                String methodName = method.getSimpleName().toString();
                if (!methodName.startsWith("get")) continue;
                Element element = f = this.isFieldAccess ? JpaControllerUtil.guessField(method) : method;
                if (f == null) continue;
                int a = -1;
                AnnotationMirror columnAnnotation = null;
                String[] columnAnnotationFqns = new String[]{"jakarta.persistence.EmbeddedId", "jakarta.persistence.JoinColumns", "jakarta.persistence.JoinColumn", "jakarta.persistence.Column", "javax.persistence.EmbeddedId", "javax.persistence.JoinColumns", "javax.persistence.JoinColumn", "javax.persistence.Column"};
                for (int i = 0; i < columnAnnotationFqns.length; ++i) {
                    String columnAnnotationFqn = columnAnnotationFqns[i];
                    AnnotationMirror columnAnnotationMirror = JpaControllerUtil.findAnnotation(f, columnAnnotationFqn);
                    if (columnAnnotationMirror == null) continue;
                    a = i;
                    columnAnnotation = columnAnnotationMirror;
                    break;
                }
                if (a == 0 || a == 4) {
                    this.populateMapsForEmbedded(method);
                    continue;
                }
                if ((a == 1 || a == 2) && (JpaControllerUtil.isAnnotatedWith(f, "jakarta.persistence.OneToOne") || JpaControllerUtil.isAnnotatedWith(f, "jakarta.persistence.ManyToOne"))) {
                    this.populateJoinColumnNameMaps(method, columnAnnotationFqns[a], columnAnnotation);
                    continue;
                }
                if ((a == 5 || a == 6) && (JpaControllerUtil.isAnnotatedWith(f, "javax.persistence.OneToOne") || JpaControllerUtil.isAnnotatedWith(f, "javax.persistence.ManyToOne"))) {
                    this.populateJoinColumnNameMaps(method, columnAnnotationFqns[a], columnAnnotation);
                    continue;
                }
                if (a != 3 && a != 7 || (columnName = JpaControllerUtil.findAnnotationValueAsString(columnAnnotation, "name")) == null) continue;
                this.columnNameToAccessorString.put(columnName, method.getSimpleName().toString() + "()");
            }
        }

        private void populateMapsForEmbedded(ExecutableElement idGetterElement) {
            TypeMirror idType = idGetterElement.getReturnType();
            if (TypeKind.DECLARED != idType.getKind()) {
                return;
            }
            DeclaredType declaredType = (DeclaredType)idType;
            TypeElement idClass = (TypeElement)declaredType.asElement();
            for (ExecutableElement pkMethod : ElementFilter.methodsIn(idClass.getEnclosedElements())) {
                String columnName;
                VariableElement pkFieldElement;
                String pkMethodName = pkMethod.getSimpleName().toString();
                if (pkMethodName.startsWith("get")) {
                    String columnName2 = this.guessColumnName(pkMethod);
                    if (columnName2 == null || columnName2.length() <= 0) continue;
                    this.pkAccessorMethodToColumnName.put(pkMethod, columnName2);
                    this.columnNameToAccessorString.put(columnName2, idGetterElement.getSimpleName().toString() + "()." + pkMethod.getSimpleName() + "()");
                    continue;
                }
                if (!pkMethodName.startsWith("set") || (pkFieldElement = this.isFieldAccess ? JpaControllerUtil.guessField(pkMethod) : JpaControllerUtil.guessGetter(pkMethod)) == null || (columnName = this.guessColumnName(pkMethod)) == null || columnName.length() <= 0) continue;
                this.pkSetterMethodToColumnName.put(pkMethod, columnName);
                this.columnNameToSetterString.put(columnName, idGetterElement.getSimpleName().toString() + "()." + pkMethod.getSimpleName() + "()");
            }
        }

        private String guessColumnName(ExecutableElement pkMethod) {
            VariableElement pkFieldElement;
            VariableElement pkFieldvariable = JpaControllerUtil.guessField(pkMethod);
            VariableElement variableElement = pkFieldElement = this.isFieldAccess ? pkFieldvariable : JpaControllerUtil.guessGetter(pkMethod);
            if (pkFieldElement == null) {
                return null;
            }
            String pkMethodName = pkMethod.getSimpleName().toString();
            String columnName = null;
            AnnotationMirror columnAnnotation = JpaControllerUtil.findAnnotation(pkFieldElement, "jakarta.persistence.Column");
            if (columnAnnotation == null) {
                columnAnnotation = JpaControllerUtil.findAnnotation(pkFieldElement, "javax.persistence.Column");
            }
            if (columnAnnotation != null) {
                columnName = JpaControllerUtil.findAnnotationValueAsString(columnAnnotation, "name");
            }
            if (columnName == null) {
                if (pkFieldvariable.getModifiers().contains((Object)Modifier.TRANSIENT)) {
                    return null;
                }
                columnName = this.isFieldAccess ? pkFieldvariable.getSimpleName().toString().toUpperCase() : pkMethodName.substring(3).toUpperCase();
            }
            return columnName;
        }

        private void populateJoinColumnNameMaps(ExecutableElement m, String columnAnnotationFqn, AnnotationMirror columnAnnotation) {
            ArrayList<AnnotationMirror> joinColumnAnnotations = new ArrayList<AnnotationMirror>();
            if ("jakarta.persistence.JoinColumn".equals(columnAnnotationFqn)) {
                joinColumnAnnotations.add(columnAnnotation);
            } else if ("javax.persistence.JoinColumn".equals(columnAnnotationFqn)) {
                joinColumnAnnotations.add(columnAnnotation);
            } else if ("jakarta.persistence.JoinColumns".equals(columnAnnotationFqn)) {
                joinColumnAnnotations.addAll(JpaControllerUtil.findNestedAnnotations(columnAnnotation, "jakarta.persistence.JoinColumn"));
            } else if ("javax.persistence.JoinColumns".equals(columnAnnotationFqn)) {
                joinColumnAnnotations.addAll(JpaControllerUtil.findNestedAnnotations(columnAnnotation, "javax.persistence.JoinColumn"));
            } else {
                throw new IllegalStateException("Unsupported annotation: " + columnAnnotationFqn);
            }
            for (AnnotationMirror joinColumnAnnotation : joinColumnAnnotations) {
                String columnName = JpaControllerUtil.findAnnotationValueAsString(joinColumnAnnotation, "name");
                if (columnName == null) continue;
                String referencedColumnName = JpaControllerUtil.findAnnotationValueAsString(joinColumnAnnotation, "referencedColumnName");
                this.joinColumnNameToRelationshipMethod.put(columnName, m);
                this.joinColumnNameToReferencedColumnName.put(columnName, referencedColumnName);
                List<String> joinColumnNameList = this.relationshipMethodToJoinColumnNames.get(m);
                if (joinColumnNameList == null) {
                    joinColumnNameList = new ArrayList<String>();
                    this.relationshipMethodToJoinColumnNames.put(m, joinColumnNameList);
                }
                joinColumnNameList.add(columnName);
            }
        }
    }

    public static class EmbeddedPkSupport {
        private Map<TypeElement, EmbeddedPkSupportInfo> typeToInfo = new HashMap<TypeElement, EmbeddedPkSupportInfo>();

        public Set<ExecutableElement> getPkAccessorMethods(TypeElement type) {
            EmbeddedPkSupportInfo info = this.getInfo(type);
            return info.getPkAccessorMethods();
        }

        public boolean getPkSetterMethodExist(TypeElement type, ExecutableElement getter) {
            String column;
            EmbeddedPkSupportInfo info = this.getInfo(type);
            return info.getSetterString(column = info.getReferencedColumnName(getter)) != null;
        }

        public String getCodeToPopulatePkField(TypeElement type, ExecutableElement pkAccessorMethod) {
            EmbeddedPkSupportInfo info = this.getInfo(type);
            String code = info.getCodeToPopulatePkField(pkAccessorMethod);
            if (code != null) {
                return code;
            }
            code = "";
            ExecutableElement relationshipMethod = info.getRelationshipMethod(pkAccessorMethod);
            String referencedColumnName = info.getReferencedColumnName(pkAccessorMethod);
            if (relationshipMethod == null || referencedColumnName == null) {
                info.putCodeToPopulatePkField(pkAccessorMethod, code);
                return code;
            }
            TypeMirror relationshipTypeMirror = relationshipMethod.getReturnType();
            if (TypeKind.DECLARED != relationshipTypeMirror.getKind()) {
                info.putCodeToPopulatePkField(pkAccessorMethod, code);
                return code;
            }
            DeclaredType declaredType = (DeclaredType)relationshipTypeMirror;
            TypeElement relationshipType = (TypeElement)declaredType.asElement();
            EmbeddedPkSupportInfo relatedInfo = this.getInfo(relationshipType);
            String accessorString = relatedInfo.getAccessorString(referencedColumnName);
            if (accessorString == null) {
                info.putCodeToPopulatePkField(pkAccessorMethod, code);
                return code;
            }
            code = relationshipMethod.getSimpleName().toString() + "()." + accessorString;
            info.putCodeToPopulatePkField(pkAccessorMethod, code);
            return code;
        }

        public boolean isRedundantWithRelationshipField(TypeElement type, ExecutableElement pkAccessorMethod) {
            return this.getCodeToPopulatePkField(type, pkAccessorMethod).length() > 0;
        }

        public boolean isRedundantWithPkFields(TypeElement type, ExecutableElement relationshipMethod) {
            EmbeddedPkSupportInfo info = this.getInfo(type);
            return info.isRedundantWithPkFields(relationshipMethod);
        }

        private EmbeddedPkSupportInfo getInfo(TypeElement type) {
            EmbeddedPkSupportInfo info = this.typeToInfo.get(type);
            if (info == null) {
                info = new EmbeddedPkSupportInfo(type);
                this.typeToInfo.put(type, info);
            }
            return info;
        }
    }
}

