/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.jpqleditor.ui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.IntrospectionException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.j2ee.persistence.api.PersistenceEnvironment;
import org.netbeans.modules.j2ee.persistence.dd.common.Persistence;
import org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.editor.JPAEditorUtil;
import org.netbeans.modules.j2ee.persistence.jpqleditor.JPQLEditorController;
import org.netbeans.modules.j2ee.persistence.jpqleditor.JPQLExecutor;
import org.netbeans.modules.j2ee.persistence.jpqleditor.JPQLResult;
import org.netbeans.modules.j2ee.persistence.jpqleditor.Utils;
import org.netbeans.modules.j2ee.persistence.jpqleditor.ui.ReflectionInfo;
import org.netbeans.modules.j2ee.persistence.jpqleditor.ui.ReflectiveTableModel;
import org.netbeans.modules.j2ee.persistence.jpqleditor.ui.ResultTableCellRenderer;
import org.netbeans.modules.j2ee.persistence.provider.Provider;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.openide.awt.Mnemonics;
import org.openide.awt.MouseUtils;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public final class JPQLEditorTopComponent
extends TopComponent {
    static final String ICON_PATH = "org/netbeans/modules/j2ee/persistence/jpqleditor/ui/resources/queryEditor16X16.png";
    private static final Logger logger = Logger.getLogger(JPQLEditorTopComponent.class.getName());
    private PUDataObject puObject;
    private HashMap<String, PersistenceUnit> puConfigMap = new HashMap();
    private static List<Integer> windowCounts = new ArrayList<Integer>();
    private Integer thisWindowCount = 0;
    private JPQLEditorController controller = null;
    private ProgressHandle ph = null;
    private ProgressHandle ph2 = null;
    private RequestProcessor requestProcessor;
    private RequestProcessor.Task hqlParserTask;
    private boolean isSqlTranslationProcessDone = false;
    private DatabaseConnection dbconn = null;
    private JPanel containerPanel;
    private JTextArea errorTextArea;
    private JPanel executionPanel;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JEditorPane jpqlEditor;
    private JComboBox puComboBox;
    private JPanel resultContainerPanel;
    private JToggleButton resultToggleButton;
    private JPanel resultsOrErrorPanel;
    private JTable resultsTable;
    private JButton runJPQLButton;
    private JLabel sessionLabel;
    private JComboBox setMaxRowCountComboBox;
    private JLabel setMaxRowCountLabel;
    private JPanel setMaxRowCountPanel;
    private JPanel spacerPanel1;
    private JPanel spacerPanel2;
    private JSplitPane splitPane;
    private JTextPane sqlEditorPane;
    private JToggleButton sqlToggleButton;
    private JLabel statusLabel;
    private JPanel statusPanel;
    private JToolBar toolBar;
    private JToolBar toolBar2;
    private JToolBar.Separator toolbarSeparator;
    private JToolBar.Separator toolbarSeparator1;

    private static int getNextWindowCount() {
        int count = 0;
        while (windowCounts.contains(count)) {
            ++count;
        }
        windowCounts.add(count);
        return count;
    }

    public static JPQLEditorTopComponent getInstance() {
        return new JPQLEditorTopComponent(null);
    }

    public PUDataObject getDataObject() {
        return this.puObject;
    }

    public JPQLEditorTopComponent(JPQLEditorController controller) {
        FontMetrics metrics;
        this.controller = controller;
        this.initComponents();
        int height = this.resultsTable.getRowHeight();
        Font cellFont = UIManager.getFont("TextField.font");
        if (cellFont != null && (metrics = this.resultsTable.getFontMetrics(cellFont)) != null) {
            height = metrics.getHeight() + 2;
        }
        this.resultsTable.setRowHeight(Math.max(this.resultsTable.getRowHeight(), height));
        this.puComboBox.addActionListener(e -> this.puComboboxActionPerformed());
        this.thisWindowCount = JPQLEditorTopComponent.getNextWindowCount();
        this.setName(NbBundle.getMessage(JPQLEditorTopComponent.class, (String)"CTL_JPQLEditorTopComponent") + this.thisWindowCount);
        this.setToolTipText(NbBundle.getMessage(JPQLEditorTopComponent.class, (String)"HINT_JPQLEditorTopComponent"));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
        this.sqlToggleButton.setSelected(true);
        this.jpqlEditor.getDocument().addDocumentListener(new JPQLDocumentListener());
        ((NbEditorDocument)this.jpqlEditor.getDocument()).runAtomic(() -> {});
        this.jpqlEditor.addMouseListener((MouseListener)((Object)new JPQLEditorPopupMouseAdapter()));
        this.showSQL(NbBundle.getMessage(JPQLEditorTopComponent.class, (String)"BuildHint"));
        this.resultsTable.setDefaultRenderer(Object.class, new ResultTableCellRenderer());
    }

    public void setFocusToEditor() {
        if (!this.jpqlEditor.isFocusOwner()) {
            this.jpqlEditor.requestFocus();
        }
    }

    private void showSQL(String sql) {
        this.sqlEditorPane.setText(sql);
        this.switchToSQLView();
    }

    private void showSQLError(String errorResourceKey, String queryProblems) {
        if (queryProblems != null) {
            this.sqlEditorPane.setText(queryProblems);
        } else {
            this.sqlEditorPane.setText(NbBundle.getMessage(JPQLEditorTopComponent.class, (String)errorResourceKey));
        }
        this.switchToSQLView();
    }

    protected void componentActivated() {
        super.componentActivated();
        this.setFocusToEditor();
        this.requestProcessor = new RequestProcessor("hql-parser", 1, true);
    }

    protected void componentDeactivated() {
        super.componentDeactivated();
        this.requestProcessor.stop();
    }

    public void fillPersistenceConfigurations(Node[] activatedNodes) {
        Node node = activatedNodes[0];
        DataObject dO = (DataObject)node.getLookup().lookup(DataObject.class);
        this.puObject = null;
        if (dO instanceof PUDataObject) {
            this.puObject = (PUDataObject)dO;
            dO.addPropertyChangeListener(evt -> {
                if ("valid".equals(evt.getPropertyName()) && Boolean.FALSE.equals(evt.getNewValue())) {
                    if (SwingUtilities.isEventDispatchThread()) {
                        this.close();
                    } else {
                        SwingUtilities.invokeLater(() -> this.close());
                    }
                }
            });
            Persistence persistence = this.puObject.getPersistence();
            if (persistence == null) {
                logger.warning("corrupted persistence.xml in enclosing project.");
            } else if (persistence.getPersistenceUnit().length > 0) {
                for (PersistenceUnit unit : persistence.getPersistenceUnit()) {
                    String configName = unit.getName();
                    this.puConfigMap.put(configName, unit);
                }
                this.puComboBox.setModel(new DefaultComboBoxModel<Object>(this.puConfigMap.keySet().toArray()));
                this.puComboBox.setSelectedIndex(0);
            }
        }
    }

    public void setResult(JPQLResult result, ClassLoader ccl) {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(ccl);
        if (result.getSqlQuery() != null) {
            this.sqlEditorPane.setText(result.getSqlQuery());
        }
        if (result.getExceptions().isEmpty()) {
            this.switchToResultView();
            StringBuilder strBuffer = new StringBuilder();
            String space = " ";
            String separator = "; ";
            strBuffer.append(result.getUpdateOrDeleteResult());
            strBuffer.append(space);
            strBuffer.append(NbBundle.getMessage(JPQLEditorTopComponent.class, (String)"queryUpdatedOrDeleted"));
            strBuffer.append(separator);
            strBuffer.append(space);
            strBuffer.append(result.getQueryResults().size());
            strBuffer.append(space);
            strBuffer.append(NbBundle.getMessage(JPQLEditorTopComponent.class, (String)"rowsSelected"));
            this.setStatus(strBuffer.toString());
            AbstractTableModel tm = new DefaultTableModel();
            if (!result.getQueryResults().isEmpty()) {
                try {
                    List<ReflectionInfo> info = ReflectionInfo.prepare(result.getQueryResults());
                    tm = new ReflectiveTableModel(info, result.getQueryResults());
                }
                catch (IntrospectionException ex) {
                    logger.log(Level.WARNING, "Failed to reflect while building table model for JPA display", ex);
                }
            }
            this.resultsTable.clearSelection();
            this.resultsTable.setModel(tm);
        } else {
            logger.log(Level.INFO, "JPQL query execution resulted in {0} errors.", result.getExceptions().size());
            this.switchToErrorView();
            this.setStatus(NbBundle.getMessage(JPQLEditorTopComponent.class, (String)"queryExecutionError"));
            this.errorTextArea.setText("");
            for (Throwable t : result.getExceptions()) {
                StringWriter sWriter = new StringWriter();
                PrintWriter pWriter = new PrintWriter(sWriter);
                t.printStackTrace(pWriter);
                this.errorTextArea.append(this.removePersistenceModuleCodelines(sWriter.toString()));
            }
            if (result.getQueryProblems() != null) {
                this.sqlEditorPane.setText(result.getQueryProblems());
            }
        }
        this.ph.progress(99);
        this.ph.setDisplayName(NbBundle.getMessage(JPQLEditorTopComponent.class, (String)"queryExecutionDone"));
        this.runJPQLButton.setEnabled(true);
        this.ph.finish();
        Thread.currentThread().setContextClassLoader(oldClassLoader);
    }

    private void setStatus(String message) {
        this.statusLabel.setText(message);
    }

    private String removePersistenceModuleCodelines(String exceptionTrace) {
        StringTokenizer tokenizer = new StringTokenizer(exceptionTrace, "\n");
        StringBuilder filteredExceptionTrace = new StringBuilder();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.contains("org.netbeans.modules.j2ee.persistence")) continue;
            filteredExceptionTrace.append(token).append("\n");
        }
        return filteredExceptionTrace.toString();
    }

    private void initComponents() {
        this.toolBar = new JToolBar();
        this.sessionLabel = new JLabel();
        this.puComboBox = new JComboBox();
        this.toolbarSeparator = new JToolBar.Separator();
        this.runJPQLButton = new JButton();
        this.toolbarSeparator1 = new JToolBar.Separator();
        this.splitPane = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.jpqlEditor = new JEditorPane();
        this.containerPanel = new JPanel();
        this.toolBar2 = new JToolBar();
        this.resultToggleButton = new JToggleButton();
        this.sqlToggleButton = new JToggleButton();
        this.spacerPanel1 = new JPanel();
        this.spacerPanel2 = new JPanel();
        this.setMaxRowCountPanel = new JPanel();
        this.setMaxRowCountLabel = new JLabel();
        this.setMaxRowCountComboBox = new JComboBox();
        this.executionPanel = new JPanel();
        this.resultContainerPanel = new JPanel();
        this.statusPanel = new JPanel();
        this.statusLabel = new JLabel();
        this.resultsOrErrorPanel = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.errorTextArea = new JTextArea();
        this.jScrollPane3 = new JScrollPane();
        this.resultsTable = new JTable(){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                Dimension size = super.getPreferredScrollableViewportSize();
                return new Dimension(Math.min(this.getPreferredSize().width, size.width), size.height);
            }
        };
        this.jScrollPane2 = new JScrollPane();
        this.sqlEditorPane = new JTextPane();
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        Mnemonics.setLocalizedText((JLabel)this.sessionLabel, (String)NbBundle.getMessage(JPQLEditorTopComponent.class, (String)"JPQLEditorTopComponent.sessionLabel.text"));
        this.toolBar.add(this.sessionLabel);
        this.toolBar.add(this.puComboBox);
        this.toolBar.add(this.toolbarSeparator);
        this.runJPQLButton.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/org/netbeans/modules/j2ee/persistence/jpqleditor/ui/resources/run_jpql_query_16.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.runJPQLButton, (String)NbBundle.getMessage(JPQLEditorTopComponent.class, (String)"JPQLEditorTopComponent.runJPQLButton.text"));
        this.runJPQLButton.setToolTipText(NbBundle.getMessage(JPQLEditorTopComponent.class, (String)"runJPQLQueryButtonToolTip"));
        this.runJPQLButton.setFocusable(false);
        this.runJPQLButton.setHorizontalTextPosition(0);
        this.runJPQLButton.setVerticalTextPosition(3);
        this.runJPQLButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPQLEditorTopComponent.this.runJPQLButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.runJPQLButton);
        this.toolbarSeparator1.setSeparatorSize(new Dimension(300, 10));
        this.toolBar.add(this.toolbarSeparator1);
        this.splitPane.setBorder(null);
        this.splitPane.setDividerLocation(180);
        this.splitPane.setDividerSize(7);
        this.splitPane.setOrientation(0);
        this.jpqlEditor.setContentType("text/x-jpql");
        this.jScrollPane1.setViewportView(this.jpqlEditor);
        this.splitPane.setTopComponent(this.jScrollPane1);
        this.toolBar2.setFloatable(false);
        this.toolBar2.setRollover(true);
        Mnemonics.setLocalizedText((AbstractButton)this.resultToggleButton, (String)NbBundle.getMessage(JPQLEditorTopComponent.class, (String)"JPQLEditorTopComponent.resultToggleButton.text"));
        this.resultToggleButton.setToolTipText(NbBundle.getMessage(JPQLEditorTopComponent.class, (String)"showResultTooltipText"));
        this.resultToggleButton.setFocusable(false);
        this.resultToggleButton.setHorizontalTextPosition(0);
        this.resultToggleButton.setVerticalTextPosition(3);
        this.resultToggleButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                JPQLEditorTopComponent.this.resultToggleButtonItemStateChanged(evt);
            }
        });
        this.toolBar2.add(this.resultToggleButton);
        Mnemonics.setLocalizedText((AbstractButton)this.sqlToggleButton, (String)NbBundle.getMessage(JPQLEditorTopComponent.class, (String)"JPQLEditorTopComponent.sqlToggleButton.text"));
        this.sqlToggleButton.setToolTipText(NbBundle.getMessage(JPQLEditorTopComponent.class, (String)"showSQLTooltipText"));
        this.sqlToggleButton.setHorizontalTextPosition(0);
        this.sqlToggleButton.setVerticalTextPosition(3);
        this.sqlToggleButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                JPQLEditorTopComponent.this.sqlToggleButtonItemStateChanged(evt);
            }
        });
        this.toolBar2.add(this.sqlToggleButton);
        GroupLayout spacerPanel1Layout = new GroupLayout(this.spacerPanel1);
        this.spacerPanel1.setLayout(spacerPanel1Layout);
        spacerPanel1Layout.setHorizontalGroup(spacerPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 224, Short.MAX_VALUE));
        spacerPanel1Layout.setVerticalGroup(spacerPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 27, Short.MAX_VALUE));
        this.toolBar2.add(this.spacerPanel1);
        GroupLayout spacerPanel2Layout = new GroupLayout(this.spacerPanel2);
        this.spacerPanel2.setLayout(spacerPanel2Layout);
        spacerPanel2Layout.setHorizontalGroup(spacerPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 150, Short.MAX_VALUE));
        spacerPanel2Layout.setVerticalGroup(spacerPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 27, Short.MAX_VALUE));
        this.toolBar2.add(this.spacerPanel2);
        Mnemonics.setLocalizedText((JLabel)this.setMaxRowCountLabel, (String)NbBundle.getMessage(JPQLEditorTopComponent.class, (String)"JPQLEditorTopComponent.setMaxRowCountLabel.text"));
        this.setMaxRowCountComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"100", "1000", "10000", "100000"}));
        this.setMaxRowCountComboBox.setToolTipText(NbBundle.getMessage(JPQLEditorTopComponent.class, (String)"setMaxRowToolTip"));
        GroupLayout setMaxRowCountPanelLayout = new GroupLayout(this.setMaxRowCountPanel);
        this.setMaxRowCountPanel.setLayout(setMaxRowCountPanelLayout);
        setMaxRowCountPanelLayout.setHorizontalGroup(setMaxRowCountPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(setMaxRowCountPanelLayout.createSequentialGroup().addComponent(this.setMaxRowCountLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.setMaxRowCountComboBox, -2, -1, -2)));
        setMaxRowCountPanelLayout.setVerticalGroup(setMaxRowCountPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(setMaxRowCountPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.setMaxRowCountLabel).addComponent(this.setMaxRowCountComboBox, -2, -1, -2)));
        this.toolBar2.add(this.setMaxRowCountPanel);
        this.executionPanel.setLayout(new CardLayout());
        this.resultContainerPanel.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((JLabel)this.statusLabel, (String)NbBundle.getMessage(JPQLEditorTopComponent.class, (String)"JPQLEditorTopComponent.statusLabel.text"));
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 607, Short.MAX_VALUE).addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addGap(0, 303, Short.MAX_VALUE).addComponent(this.statusLabel).addGap(0, 304, Short.MAX_VALUE))));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE).addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.statusLabel).addGap(0, 0, Short.MAX_VALUE))));
        this.resultContainerPanel.add((Component)this.statusPanel, "North");
        this.resultsOrErrorPanel.setLayout(new CardLayout());
        this.errorTextArea.setColumns(20);
        this.errorTextArea.setEditable(false);
        this.errorTextArea.setForeground(new Color(255, 102, 102));
        this.errorTextArea.setRows(5);
        this.jScrollPane4.setViewportView(this.errorTextArea);
        this.resultsOrErrorPanel.add((Component)this.jScrollPane4, "card2");
        this.resultsTable.setModel(new DefaultTableModel(new Object[][]{new Object[0], new Object[0], new Object[0], new Object[0]}, new String[0]));
        this.resultsTable.setAutoResizeMode(0);
        this.jScrollPane3.setViewportView(this.resultsTable);
        this.resultsOrErrorPanel.add((Component)this.jScrollPane3, "card3");
        this.resultContainerPanel.add((Component)this.resultsOrErrorPanel, "Center");
        this.executionPanel.add((Component)this.resultContainerPanel, "card2");
        this.sqlEditorPane.setEditable(false);
        this.jScrollPane2.setViewportView(this.sqlEditorPane);
        this.executionPanel.add((Component)this.jScrollPane2, "card1");
        GroupLayout containerPanelLayout = new GroupLayout(this.containerPanel);
        this.containerPanel.setLayout(containerPanelLayout);
        containerPanelLayout.setHorizontalGroup(containerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.toolBar2, -1, -1, Short.MAX_VALUE).addComponent(this.executionPanel, -1, -1, Short.MAX_VALUE));
        containerPanelLayout.setVerticalGroup(containerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(containerPanelLayout.createSequentialGroup().addComponent(this.toolBar2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.executionPanel, -1, 286, Short.MAX_VALUE)));
        this.splitPane.setRightComponent(this.containerPanel);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.toolBar, -2, 0, Short.MAX_VALUE).addComponent(this.splitPane));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.toolBar, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.splitPane, -1, 508, Short.MAX_VALUE)));
    }

    private int getMaxRowCount() {
        String selectedMaxCount = this.setMaxRowCountComboBox.getSelectedItem().toString();
        try {
            return Integer.parseInt(selectedMaxCount);
        }
        catch (NumberFormatException e) {
            logger.warning("Number Format Error during parsing the max. row count");
            return 1000;
        }
    }

    private void resultToggleButtonItemStateChanged(ItemEvent evt) {
        if (this.resultToggleButton.isSelected()) {
            ((CardLayout)this.executionPanel.getLayout()).first(this.executionPanel);
            this.sqlToggleButton.setSelected(false);
        }
    }

    private void sqlToggleButtonItemStateChanged(ItemEvent evt) {
        if (this.sqlToggleButton.isSelected()) {
            ((CardLayout)this.executionPanel.getLayout()).last(this.executionPanel);
            this.resultToggleButton.setSelected(false);
        }
    }

    private void runJPQLButtonActionPerformed(ActionEvent evt) {
        if (this.jpqlEditor.getText().trim().equals("")) {
            this.switchToResultView();
            this.setStatus(NbBundle.getMessage(JPQLEditorTopComponent.class, (String)"emptyQuery"));
            return;
        }
        if (this.puComboBox.getSelectedItem() == null) {
            logger.info("hibernate configuration combo box is empty.");
            this.switchToResultView();
            this.setStatus(NbBundle.getMessage(JPQLEditorTopComponent.class, (String)"emptyConfiguration"));
            return;
        }
        this.runJPQLButton.setEnabled(false);
        try {
            FileObject pXml;
            this.ph = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(JPQLEditorTopComponent.class, (String)"progressTaskname"));
            this.isSqlTranslationProcessDone = true;
            if (this.hqlParserTask != null && !this.hqlParserTask.isFinished() && this.hqlParserTask.getDelay() != 0) {
                this.hqlParserTask.cancel();
            }
            Project project = (pXml = this.puObject.getPrimaryFile()) != null ? FileOwnerQuery.getOwner((FileObject)pXml) : null;
            PersistenceEnvironment pe = project != null ? (PersistenceEnvironment)project.getLookup().lookup(PersistenceEnvironment.class) : null;
            PersistenceUnit pu = this.puConfigMap.get(this.puComboBox.getSelectedItem());
            this.ph.start(100);
            this.controller.executeJPQLQuery(this.jpqlEditor.getText(), pu, pe, this.getMaxRowCount(), this.ph);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public int getPersistenceType() {
        return 2;
    }

    protected void componentClosed() {
        windowCounts.remove(this.thisWindowCount);
    }

    private void switchToResultView() {
        this.resultToggleButton.setSelected(true);
        ((CardLayout)this.resultsOrErrorPanel.getLayout()).last(this.resultsOrErrorPanel);
    }

    private void switchToSQLView() {
        this.sqlToggleButton.setSelected(true);
    }

    private void switchToErrorView() {
        this.resultToggleButton.setSelected(true);
        ((CardLayout)this.resultsOrErrorPanel.getLayout()).first(this.resultsOrErrorPanel);
    }

    private void puComboboxActionPerformed() {
        if (this.puComboBox.getSelectedItem() != null) {
            FileObject pXml = this.puObject.getPrimaryFile();
            Project project = pXml != null ? FileOwnerQuery.getOwner((FileObject)pXml) : null;
            PersistenceEnvironment pe = project != null ? (PersistenceEnvironment)project.getLookup().lookup(PersistenceEnvironment.class) : null;
            PersistenceUnit pu = this.puConfigMap.get(this.puComboBox.getSelectedItem());
            this.dbconn = JPAEditorUtil.findDatabaseConnection(pu, pe.getProject());
            if (this.dbconn != null && this.dbconn.getJDBCConnection() == null) {
                Mutex.EVENT.readAccess(() -> {
                    ConnectionManager.getDefault().showConnectionDialog(this.dbconn);
                    return this.dbconn;
                });
            }
        }
    }

    private class JPQLDocumentListener
    implements DocumentListener {
        private JPQLDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.process();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.process();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.process();
        }

        private void process() {
            if (JPQLEditorTopComponent.this.hqlParserTask != null && !JPQLEditorTopComponent.this.hqlParserTask.isFinished() && JPQLEditorTopComponent.this.hqlParserTask.getDelay() != 0) {
                JPQLEditorTopComponent.this.hqlParserTask.cancel();
            } else if (!JPQLEditorTopComponent.this.requestProcessor.isShutdown()) {
                JPQLEditorTopComponent.this.hqlParserTask = JPQLEditorTopComponent.this.requestProcessor.post((Runnable)new ParseJPQL(), 2000);
                JPQLEditorTopComponent.this.isSqlTranslationProcessDone = false;
            }
        }
    }

    private class JPQLEditorPopupMouseAdapter
    extends MouseUtils.PopupMouseAdapter {
        private JPopupMenu popupMenu;
        private JMenuItem runJPQLMenuItem;
        private JMenuItem cutMenuItem;
        private JMenuItem copyMenuItem;
        private JMenuItem pasteMenuItem;
        private JMenuItem selectAllMenuItem;
        private final String RUN_JPQL_COMMAND = NbBundle.getMessage(JPQLEditorTopComponent.class, (String)"CTL_RUN_JPQL_COMMAND");
        private final String CUT_COMMAND = NbBundle.getMessage(JPQLEditorTopComponent.class, (String)"CTL_CUT_COMMAND");
        private final String COPY_COMMAND = NbBundle.getMessage(JPQLEditorTopComponent.class, (String)"CTL_COPY_COMMAND");
        private final String PASTE_COMMAND = NbBundle.getMessage(JPQLEditorTopComponent.class, (String)"CTL_PASTE_COMMAND");
        private final String SELECT_ALL_COMMAND = NbBundle.getMessage(JPQLEditorTopComponent.class, (String)"CTL_SELECT_ALL_COMMAND");
        private Clipboard systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();

        public JPQLEditorPopupMouseAdapter() {
            this.popupMenu = new JPopupMenu();
            PopupActionListener actionListener = new PopupActionListener();
            this.runJPQLMenuItem = this.popupMenu.add(this.RUN_JPQL_COMMAND);
            this.runJPQLMenuItem.setMnemonic('Q');
            this.runJPQLMenuItem.setAccelerator(KeyStroke.getKeyStroke(72, 9, false));
            this.runJPQLMenuItem.addActionListener(actionListener);
            this.popupMenu.addSeparator();
            this.cutMenuItem = this.popupMenu.add(this.CUT_COMMAND);
            this.cutMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2, true));
            this.cutMenuItem.setMnemonic('t');
            this.cutMenuItem.addActionListener(actionListener);
            this.copyMenuItem = this.popupMenu.add(this.COPY_COMMAND);
            this.copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2, true));
            this.copyMenuItem.setMnemonic('y');
            this.copyMenuItem.addActionListener(actionListener);
            this.pasteMenuItem = this.popupMenu.add(this.PASTE_COMMAND);
            this.pasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2, true));
            this.pasteMenuItem.setMnemonic('P');
            this.pasteMenuItem.addActionListener(actionListener);
            this.popupMenu.addSeparator();
            this.selectAllMenuItem = this.popupMenu.add(this.SELECT_ALL_COMMAND);
            this.selectAllMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2, true));
            this.selectAllMenuItem.setMnemonic('A');
            this.selectAllMenuItem.addActionListener(actionListener);
        }

        protected void showPopup(MouseEvent evt) {
            if (JPQLEditorTopComponent.this.jpqlEditor.getText().trim().isEmpty()) {
                this.runJPQLMenuItem.setEnabled(false);
                this.selectAllMenuItem.setEnabled(false);
            } else {
                this.runJPQLMenuItem.setEnabled(true);
                this.selectAllMenuItem.setEnabled(true);
            }
            if (JPQLEditorTopComponent.this.jpqlEditor.getSelectedText() == null || JPQLEditorTopComponent.this.jpqlEditor.getSelectedText().trim().isEmpty()) {
                this.cutMenuItem.setEnabled(false);
                this.copyMenuItem.setEnabled(false);
            } else {
                this.cutMenuItem.setEnabled(true);
                this.copyMenuItem.setEnabled(true);
            }
            Transferable transferable = this.systemClipboard.getContents(null);
            if (transferable.getTransferDataFlavors().length == 0) {
                this.pasteMenuItem.setEnabled(false);
            } else {
                this.pasteMenuItem.setEnabled(true);
            }
            this.popupMenu.show(JPQLEditorTopComponent.this.jpqlEditor, evt.getX(), evt.getY());
        }

        private class PopupActionListener
        implements ActionListener {
            private PopupActionListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals(JPQLEditorPopupMouseAdapter.this.RUN_JPQL_COMMAND)) {
                    JPQLEditorTopComponent.this.runJPQLButtonActionPerformed(e);
                } else if (e.getActionCommand().equals(JPQLEditorPopupMouseAdapter.this.SELECT_ALL_COMMAND)) {
                    JPQLEditorTopComponent.this.jpqlEditor.selectAll();
                } else if (e.getActionCommand().equals(JPQLEditorPopupMouseAdapter.this.CUT_COMMAND)) {
                    StringSelection stringSelection = new StringSelection(JPQLEditorTopComponent.this.jpqlEditor.getSelectedText());
                    JPQLEditorPopupMouseAdapter.this.systemClipboard.setContents(stringSelection, stringSelection);
                    JPQLEditorTopComponent.this.jpqlEditor.setText(JPQLEditorTopComponent.this.jpqlEditor.getText().substring(0, JPQLEditorTopComponent.this.jpqlEditor.getSelectionStart()) + JPQLEditorTopComponent.this.jpqlEditor.getText().substring(JPQLEditorTopComponent.this.jpqlEditor.getSelectionEnd()));
                } else if (e.getActionCommand().equals(JPQLEditorPopupMouseAdapter.this.COPY_COMMAND)) {
                    StringSelection stringSelection = new StringSelection(JPQLEditorTopComponent.this.jpqlEditor.getSelectedText());
                    JPQLEditorPopupMouseAdapter.this.systemClipboard.setContents(stringSelection, stringSelection);
                } else if (e.getActionCommand().equals(JPQLEditorPopupMouseAdapter.this.PASTE_COMMAND)) {
                    Transferable transferable = JPQLEditorPopupMouseAdapter.this.systemClipboard.getContents(null);
                    String clipboardContents = "";
                    try {
                        if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                            clipboardContents = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                        } else if (transferable.isDataFlavorSupported(DataFlavor.getTextPlainUnicodeFlavor())) {
                            clipboardContents = (String)transferable.getTransferData(DataFlavor.getTextPlainUnicodeFlavor());
                        }
                    }
                    catch (UnsupportedFlavorException ex) {
                        logger.log(Level.INFO, "Unsupported transfer flavor", ex);
                    }
                    catch (IOException ex) {
                        logger.log(Level.INFO, "IOException during paste operation", ex);
                    }
                    if (!clipboardContents.isEmpty()) {
                        if (JPQLEditorTopComponent.this.jpqlEditor.getSelectedText() != null) {
                            JPQLEditorTopComponent.this.jpqlEditor.replaceSelection(clipboardContents);
                        } else {
                            JPQLEditorTopComponent.this.jpqlEditor.setText(JPQLEditorTopComponent.this.jpqlEditor.getText().substring(0, JPQLEditorTopComponent.this.jpqlEditor.getCaretPosition()) + clipboardContents + JPQLEditorTopComponent.this.jpqlEditor.getText().substring(JPQLEditorTopComponent.this.jpqlEditor.getCaretPosition()));
                        }
                    }
                }
            }
        }
    }

    private class ParseJPQL
    extends Thread {
        private ParseJPQL() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!JPQLEditorTopComponent.this.isSqlTranslationProcessDone) {
                String jpql = JPQLEditorTopComponent.this.jpqlEditor.getText().trim();
                if (jpql.isEmpty()) {
                    return;
                }
                if (JPQLEditorTopComponent.this.puComboBox.getSelectedItem() == null) {
                    logger.info("persistence unit selection combo box is empty.");
                    return;
                }
                PersistenceUnit selectedConfigObject = (PersistenceUnit)JPQLEditorTopComponent.this.puConfigMap.get(JPQLEditorTopComponent.this.puComboBox.getSelectedItem().toString());
                if (Thread.interrupted() || JPQLEditorTopComponent.this.isSqlTranslationProcessDone) {
                    return;
                }
                if (selectedConfigObject == null) continue;
                if (Thread.interrupted() || JPQLEditorTopComponent.this.isSqlTranslationProcessDone) {
                    return;
                }
                JPQLEditorTopComponent.this.ph2 = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(JPQLEditorTopComponent.class, (String)"progressTaskname"));
                JPQLEditorTopComponent.this.ph2.start(100);
                FileObject pXml = JPQLEditorTopComponent.this.puObject.getPrimaryFile();
                Project project = pXml != null ? FileOwnerQuery.getOwner((FileObject)pXml) : null;
                PersistenceEnvironment pe = project != null ? (PersistenceEnvironment)project.getLookup().lookup(PersistenceEnvironment.class) : null;
                ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
                ArrayList<URL> localResourcesURLList = new ArrayList<URL>();
                HashMap<String, String> props = new HashMap<String, String>();
                boolean containerManaged = Util.isSupportedJavaEEVersion(pe.getProject());
                Provider provider = ProviderUtil.getProvider(selectedConfigObject.getProvider(), pe.getProject());
                ArrayList<String> initialProblems = new ArrayList<String>();
                if (containerManaged && provider != null) {
                    Utils.substitutePersistenceProperties(pe, selectedConfigObject, JPQLEditorTopComponent.this.dbconn, props);
                }
                try {
                    initialProblems.addAll(Utils.collectClassPathURLs(pe, selectedConfigObject, JPQLEditorTopComponent.this.dbconn, localResourcesURLList));
                    if (initialProblems.isEmpty()) {
                        ClassLoader customClassLoader = pe.getProjectClassLoader(localResourcesURLList.toArray(new URL[0]));
                        Thread.currentThread().setContextClassLoader(customClassLoader);
                        JPQLExecutor queryExecutor = new JPQLExecutor();
                        JPQLResult jpqlResult = new JPQLResult();
                        try {
                            JPQLEditorTopComponent.this.ph2.progress(50);
                            JPQLEditorTopComponent.this.ph2.setDisplayName(NbBundle.getMessage(JPQLEditorTopComponent.class, (String)"queryParsingPassControlToProvider"));
                            jpqlResult = queryExecutor.execute(jpql, selectedConfigObject, pe, props, provider, 0, JPQLEditorTopComponent.this.ph2, false);
                            JPQLEditorTopComponent.this.ph2.progress(80);
                            JPQLEditorTopComponent.this.ph2.setDisplayName(NbBundle.getMessage(JPQLEditorTopComponent.class, (String)"queryParsingProcessResults"));
                        }
                        catch (Exception | NoClassDefFoundError e) {
                            logger.log(Level.INFO, "Problem in executing JPQL", e);
                            jpqlResult.getExceptions().add(e);
                        }
                        if (Thread.interrupted() || JPQLEditorTopComponent.this.isSqlTranslationProcessDone) {
                            return;
                        }
                        if (jpqlResult.getExceptions() != null && !jpqlResult.getExceptions().isEmpty()) {
                            logger.log(Level.INFO, "", jpqlResult.getExceptions());
                            JPQLEditorTopComponent.this.showSQLError("GeneralError", jpqlResult.getQueryProblems());
                            continue;
                        }
                        if (jpqlResult.getSqlQuery() == null || jpqlResult.getSqlQuery().length() == 0) {
                            JPQLEditorTopComponent.this.showSQLError("UnsupportedProvider", jpqlResult.getQueryProblems());
                            continue;
                        }
                        JPQLEditorTopComponent.this.showSQL(jpqlResult.getSqlQuery());
                        continue;
                    }
                    StringBuilder sb = new StringBuilder();
                    for (String txt : initialProblems) {
                        sb.append(txt).append("\n");
                    }
                    JPQLEditorTopComponent.this.showSQLError(null, sb.toString());
                }
                catch (Exception e) {
                    logger.log(Level.INFO, "", e);
                    JPQLEditorTopComponent.this.showSQLError("GeneralError", null);
                }
                finally {
                    JPQLEditorTopComponent.this.isSqlTranslationProcessDone = true;
                    JPQLEditorTopComponent.this.ph2.finish();
                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                }
            }
        }
    }
}

