/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.browser.webview.ext;

import com.sun.javafx.scene.web.Debugger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.scene.web.WebEngine;
import javafx.util.Callback;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;
import org.netbeans.core.browser.webview.TransportImplementationWithURLToLoad;
import org.netbeans.core.browser.webview.ext.WebBrowserImpl;
import org.netbeans.modules.web.webkit.debugging.spi.Command;
import org.netbeans.modules.web.webkit.debugging.spi.Response;
import org.netbeans.modules.web.webkit.debugging.spi.ResponseCallback;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class WebKitDebuggingTransport
implements TransportImplementationWithURLToLoad {
    private static final Logger LOGGER = Logger.getLogger(WebKitDebuggingTransport.class.getName());
    private static final RequestProcessor RP = new RequestProcessor("JavaFX debugging callback");
    private WebBrowserImpl browserImpl;
    private Debugger debugger;
    private FXCallback fxCallback;
    private ResponseCallback callback;
    private volatile String urlToLoad;

    public WebKitDebuggingTransport(WebBrowserImpl browserImpl) {
        this.browserImpl = browserImpl;
    }

    public boolean attach() {
        this.debugger = this.getDebugger();
        this.fxCallback = new FXCallback(this.callback);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                WebKitDebuggingTransport.this.debugger.setMessageCallback((Callback)WebKitDebuggingTransport.this.fxCallback);
                WebKitDebuggingTransport.this.debugger.setEnabled(true);
            }
        });
        return true;
    }

    private Debugger getDebugger() {
        Method getDebuggerImpl = null;
        try {
            getDebuggerImpl = WebEngine.class.getDeclaredMethod("impl_getDebugger", new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException ex) {
            LOGGER.log(Level.FINE, "Method impl_getDebugger not found on javafx.scene.web.WebEngine", ex);
        }
        try {
            getDebuggerImpl = WebEngine.class.getDeclaredMethod("getDebugger", new Class[0]);
            getDebuggerImpl.setAccessible(true);
        }
        catch (NoSuchMethodException | SecurityException ex) {
            LOGGER.log(Level.FINE, "Method getDebugger not found on javafx.scene.web.WebEngine", ex);
        }
        if (getDebuggerImpl == null) {
            throw new UnsupportedOperationException("Failed to fetch debugger from WebEngine (unsupported JavaFX version?)");
        }
        try {
            return (Debugger)Debugger.class.cast(getDebuggerImpl.invoke((Object)this.browserImpl.getEngine(), new Object[0]));
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw new UnsupportedOperationException("Failed to invoke " + getDebuggerImpl.getName(), ex);
        }
    }

    public boolean detach() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (WebKitDebuggingTransport.this.debugger != null) {
                    WebKitDebuggingTransport.this.debugger.setEnabled(false);
                }
            }
        });
        return true;
    }

    public void sendCommand(final Command command) {
        Platform.runLater((Runnable)new Runnable(){
            final /* synthetic */ WebKitDebuggingTransport this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    if (this.this$0.debugger != null && this.this$0.debugger.isEnabled()) {
                        this.this$0.debugger.sendMessage(command.toString());
                    }
                }
                catch (Throwable t) {
                    LOGGER.log(Level.WARNING, "sending commend triggered exception. command=" + command.toString(), t);
                }
            }
        });
    }

    public void registerResponseCallback(ResponseCallback callback) {
        this.callback = callback;
    }

    public String getConnectionName() {
        return this.browserImpl.getURL();
    }

    @Override
    public void setURLToLoad(String urlToLoad) {
        this.urlToLoad = urlToLoad;
    }

    public URL getConnectionURL() {
        String urlStr = this.urlToLoad;
        if (urlStr == null) {
            urlStr = this.browserImpl.getURL();
        }
        if (urlStr != null) {
            try {
                return new URL(urlStr);
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    public String getVersion() {
        return "version 1.0";
    }

    private static class FXCallback
    implements Callback<String, Void> {
        private ResponseCallback responseCallback;

        public FXCallback(ResponseCallback responseCallback) {
            this.responseCallback = responseCallback;
        }

        public Void call(final String p) {
            RP.post(new Runnable(){
                final /* synthetic */ FXCallback this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        JSONObject json = (JSONObject)JSONValue.parseWithException((String)p);
                        this.this$0.responseCallback.handleResponse(new Response(json));
                    }
                    catch (ParseException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
            return null;
        }
    }
}

