/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.runtime;

import com.oracle.truffle.runtime.FixedPointMath;
import com.oracle.truffle.runtime.OptimizedTruffleRuntime;
import com.oracle.truffle.runtime.TraversingBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

final class DynamicThresholdsQueue
extends TraversingBlockingQueue {
    private final int threads;
    private final double minScale;
    private final int minNormalLoad;
    private final int maxNormalLoad;
    private final double slope;

    DynamicThresholdsQueue(int threads, double minScale, int minNormalLoad, int maxNormalLoad, BlockingQueue<Runnable> entries) {
        super(entries);
        this.threads = threads;
        this.minScale = minScale;
        this.minNormalLoad = minNormalLoad;
        this.maxNormalLoad = maxNormalLoad;
        this.slope = (1.0 - minScale) / (double)minNormalLoad;
    }

    private double load() {
        return (double)this.entries.size() / (double)this.threads;
    }

    @Override
    public boolean add(Runnable e) {
        this.scaleThresholds();
        return super.add(e);
    }

    @Override
    public boolean offer(Runnable e) {
        this.scaleThresholds();
        return super.offer(e);
    }

    @Override
    public boolean offer(Runnable e, long timeout, TimeUnit unit) throws InterruptedException {
        this.scaleThresholds();
        return super.offer(e, timeout, unit);
    }

    @Override
    public Runnable poll(long timeout, TimeUnit unit) throws InterruptedException {
        this.scaleThresholds();
        return super.poll(timeout, unit);
    }

    @Override
    public Runnable poll() {
        this.scaleThresholds();
        return super.poll();
    }

    private void scaleThresholds() {
        OptimizedTruffleRuntime.getRuntime().setCompilationThresholdScale(FixedPointMath.toFixedPoint(this.scale()));
    }

    private double scale() {
        double x = this.load();
        if ((double)this.minNormalLoad <= x && x <= (double)this.maxNormalLoad) {
            return 1.0;
        }
        if (x < (double)this.minNormalLoad) {
            return this.slope * x + this.minScale;
        }
        return this.slope * x + (1.0 - this.slope * (double)this.maxNormalLoad);
    }
}

