/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.customizer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.modules.php.spi.framework.PhpModuleCustomizerExtender;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.util.HelpCtx;

public final class CustomizerFramework
extends JPanel
implements ChangeListener,
HelpCtx.Provider {
    private static final long serialVersionUID = 19349854609829890L;
    private static final Logger LOGGER = Logger.getLogger(CustomizerFramework.class.getName());
    private final ProjectCustomizer.Category category;
    private final PhpModuleCustomizerExtender extender;

    public CustomizerFramework(ProjectCustomizer.Category category, PhpModuleCustomizerExtender extender, PhpProjectProperties uiProps) {
        assert (category != null);
        assert (extender != null);
        assert (uiProps != null);
        this.category = category;
        this.extender = extender;
        uiProps.addCustomizerExtender(extender);
        this.initComponents();
        this.add((Component)extender.getComponent(), "Center");
        this.validateData();
    }

    @Override
    public void addNotify() {
        this.extender.addChangeListener((ChangeListener)this);
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        this.extender.removeChangeListener((ChangeListener)this);
        super.removeNotify();
    }

    void validateData() {
        String error = this.extender.getErrorMessage();
        if (!this.extender.isValid()) {
            assert (error != null) : "Customizer extender " + this.category.getDisplayName() + " returns no error even if it is not valid";
            this.category.setErrorMessage(error);
            this.category.setValid(false);
            return;
        }
        if (error != null) {
            LOGGER.log(Level.INFO, "Customizer extender {0} returns error even if it is valid.", this.category.getDisplayName());
        }
        this.category.setErrorMessage(this.extender.getWarningMessage());
        this.category.setValid(true);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.validateData();
    }

    public HelpCtx getHelpCtx() {
        HelpCtx help = this.extender.getHelp();
        return help != null ? help : HelpCtx.DEFAULT_HELP;
    }
}

