/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.prep.ui.customizer;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.project.Project;
import org.netbeans.modules.css.prep.CssPreprocessorType;
import org.netbeans.modules.css.prep.ui.customizer.Bundle;
import org.netbeans.modules.css.prep.util.CssPreprocessorUtils;
import org.netbeans.modules.web.common.api.CssPreprocessor;
import org.netbeans.modules.web.common.api.CssPreprocessors;
import org.netbeans.modules.web.common.api.ValidationResult;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;
import org.openide.util.Pair;

public class OptionsPanel
extends JPanel {
    private static final long serialVersionUID = 16987546576769L;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final CssPreprocessorType type;
    private final Project project;
    private final MappingsTableModel mappingsTableModel;
    private final List<Pair<String, String>> mappings = new CopyOnWriteArrayList<Pair<String, String>>();
    volatile boolean configured = false;
    volatile boolean enabled;
    volatile String compilerOptions;
    private boolean recompileButtonDisabled = false;
    private JButton addButton;
    private JLabel compilerOptionsInfoLabel;
    private JLabel compilerOptionsLabel;
    private JTextField compilerOptionsTextField;
    private JButton configureExecutablesButton;
    private JCheckBox enabledCheckBox;
    private JLabel mappingsInfoLabel;
    private JScrollPane mappingsScrollPane;
    private JTable mappingsTable;
    private JButton moveDownButton;
    private JButton moveUpButton;
    private JButton recompileButton;
    private JButton removeButton;
    private JLabel watchLabel;

    public OptionsPanel(CssPreprocessorType type, Project project, boolean initialEnabled, List<Pair<String, String>> initialMappings, String initialCompilerOptions) {
        assert (EventQueue.isDispatchThread());
        assert (type != null);
        assert (project != null);
        this.type = type;
        this.project = project;
        this.mappingsTableModel = new MappingsTableModel(this.mappings);
        this.enabled = initialEnabled;
        this.compilerOptions = initialCompilerOptions;
        this.initComponents();
        this.init(initialEnabled, initialMappings, initialCompilerOptions);
    }

    private void init(boolean initialEnabled, List<Pair<String, String>> initialMappings, String initialCompilerOptions) {
        assert (EventQueue.isDispatchThread());
        this.configureExecutablesButton.setVisible(false);
        Mnemonics.setLocalizedText((AbstractButton)this.enabledCheckBox, (String)Bundle.OptionsPanel_compilationEnabled_label(this.type.getDisplayName()));
        this.mappingsTable.setModel(this.mappingsTableModel);
        this.setCompilationEnabled(initialEnabled);
        this.setMappings(initialMappings);
        this.setCompilerOptions(initialCompilerOptions);
        this.enablePanel(initialEnabled);
        this.enableRemoveButton();
        this.enableMoveButtons();
        if ("Mac OS X".equals(UIManager.getLookAndFeel().getName())) {
            this.mappingsTable.setShowGrid(true);
            this.mappingsTable.setGridColor(Color.GRAY);
        }
        this.enabledCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                OptionsPanel.this.enabled = e.getStateChange() == 1;
                OptionsPanel.this.configured = true;
                OptionsPanel.this.enablePanel(OptionsPanel.this.enabled);
                OptionsPanel.this.fireChange(false);
            }
        });
        this.mappingsTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                OptionsPanel.this.fireChange(true);
            }
        });
        this.mappingsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                OptionsPanel.this.enableRemoveButton();
                OptionsPanel.this.enableMoveButtons();
            }
        });
        this.compilerOptionsTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.processChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.processChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.processChange();
            }

            private void processChange() {
                OptionsPanel.this.compilerOptions = OptionsPanel.this.compilerOptionsTextField.getText();
                OptionsPanel.this.fireChange(true);
            }
        });
    }

    public void showConfigureExecutableButton() {
        this.configureExecutablesButton.setVisible(true);
    }

    public boolean isConfigured() {
        return this.configured;
    }

    public boolean isCompilationEnabled() {
        return this.enabled;
    }

    public void setCompilationEnabled(boolean enabled) {
        assert (EventQueue.isDispatchThread());
        this.enabledCheckBox.setSelected(enabled);
    }

    public List<Pair<String, String>> getMappings() {
        return Collections.unmodifiableList(this.mappings);
    }

    public void setMappings(List<Pair<String, String>> mappings) {
        assert (EventQueue.isDispatchThread());
        this.mappings.clear();
        this.mappings.addAll(mappings);
        this.mappingsTableModel.fireMappingsChange();
    }

    public String getCompilerOptions() {
        assert (this.compilerOptions != null);
        return this.compilerOptions;
    }

    public void setCompilerOptions(String compilerOptions) {
        assert (EventQueue.isDispatchThread());
        this.compilerOptionsTextField.setText(compilerOptions);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    void fireChange(boolean disableRecompile) {
        assert (EventQueue.isDispatchThread());
        this.changeSupport.fireChange();
        if (disableRecompile) {
            boolean refresh = !this.recompileButtonDisabled;
            this.recompileButtonDisabled = true;
            if (refresh) {
                this.enableRecompileButton();
            }
        }
    }

    void enablePanel(boolean enabled) {
        if (enabled) {
            this.enableRecompileButton();
        } else {
            this.recompileButton.setEnabled(false);
        }
        this.watchLabel.setEnabled(enabled);
        this.mappingsTable.setEnabled(enabled);
        this.mappingsInfoLabel.setEnabled(enabled);
        this.addButton.setEnabled(enabled);
        this.configureExecutablesButton.setEnabled(enabled);
        if (enabled) {
            this.enableRemoveButton();
            this.enableMoveButtons();
        } else {
            this.removeButton.setEnabled(false);
            this.moveDownButton.setEnabled(false);
            this.moveUpButton.setEnabled(false);
        }
        this.compilerOptionsLabel.setEnabled(enabled);
        this.compilerOptionsTextField.setEnabled(enabled);
        this.compilerOptionsInfoLabel.setEnabled(enabled);
    }

    void enableRecompileButton() {
        assert (EventQueue.isDispatchThread());
        FileObject webRoot = CssPreprocessorUtils.getWebRoot(this.project);
        if (webRoot == null) {
            this.recompileButton.setEnabled(false);
            this.recompileButton.setToolTipText(Bundle.OptionsPanel_recompile_error_noWebRoot());
            return;
        }
        if (this.recompileButtonDisabled) {
            this.recompileButton.setEnabled(false);
            this.recompileButton.setToolTipText(Bundle.OptionsPanel_recompile_error_changeDetected());
            return;
        }
        ValidationResult result = this.type.getPreferencesValidator().validateMappings(webRoot, true, this.mappings).getResult();
        this.recompileButton.setEnabled(result.isFaultless());
        this.recompileButton.setToolTipText(null);
    }

    void enableRemoveButton() {
        this.removeButton.setEnabled(this.mappingsTable.getSelectedRowCount() > 0);
    }

    void enableMoveButtons() {
        int[] selectedRows = this.mappingsTable.getSelectedRows();
        if (selectedRows.length == 0) {
            this.moveDownButton.setEnabled(false);
            this.moveUpButton.setEnabled(false);
            return;
        }
        this.moveDownButton.setEnabled(Arrays.binarySearch(selectedRows, this.mappingsTable.getRowCount() - 1) < 0);
        this.moveUpButton.setEnabled(Arrays.binarySearch(selectedRows, 0) < 0);
    }

    private void selectRows(int[] selectedRows, int delta) {
        ListSelectionModel listSelectionModel = this.mappingsTable.getSelectionModel();
        listSelectionModel.clearSelection();
        for (int selectedRow : selectedRows) {
            listSelectionModel.addSelectionInterval(selectedRow + delta, selectedRow + delta);
        }
    }

    private void initComponents() {
        this.enabledCheckBox = new JCheckBox();
        this.configureExecutablesButton = new JButton();
        this.watchLabel = new JLabel();
        this.recompileButton = new JButton();
        this.mappingsScrollPane = new JScrollPane();
        this.mappingsTable = new JTable();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.moveUpButton = new JButton();
        this.moveDownButton = new JButton();
        this.mappingsInfoLabel = new JLabel();
        this.compilerOptionsLabel = new JLabel();
        this.compilerOptionsTextField = new JTextField();
        this.compilerOptionsInfoLabel = new JLabel();
        Mnemonics.setLocalizedText((AbstractButton)this.enabledCheckBox, (String)"COMPILATION_ON_SAVE");
        Mnemonics.setLocalizedText((AbstractButton)this.configureExecutablesButton, (String)NbBundle.getMessage(OptionsPanel.class, (String)"OptionsPanel.configureExecutablesButton.text"));
        this.configureExecutablesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsPanel.this.configureExecutablesButtonActionPerformed(evt);
            }
        });
        this.watchLabel.setLabelFor(this.mappingsTable);
        Mnemonics.setLocalizedText((JLabel)this.watchLabel, (String)NbBundle.getMessage(OptionsPanel.class, (String)"OptionsPanel.watchLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.recompileButton, (String)NbBundle.getMessage(OptionsPanel.class, (String)"OptionsPanel.recompileButton.text"));
        this.recompileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsPanel.this.recompileButtonActionPerformed(evt);
            }
        });
        this.mappingsScrollPane.setViewportView(this.mappingsTable);
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(OptionsPanel.class, (String)"OptionsPanel.addButton.text"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsPanel.this.addButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(OptionsPanel.class, (String)"OptionsPanel.removeButton.text"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsPanel.this.removeButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.moveUpButton, (String)NbBundle.getMessage(OptionsPanel.class, (String)"OptionsPanel.moveUpButton.text"));
        this.moveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsPanel.this.moveUpButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.moveDownButton, (String)NbBundle.getMessage(OptionsPanel.class, (String)"OptionsPanel.moveDownButton.text"));
        this.moveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsPanel.this.moveDownButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.mappingsInfoLabel, (String)NbBundle.getMessage(OptionsPanel.class, (String)"OptionsPanel.mappingsInfoLabel.text"));
        this.compilerOptionsLabel.setLabelFor(this.compilerOptionsTextField);
        Mnemonics.setLocalizedText((JLabel)this.compilerOptionsLabel, (String)NbBundle.getMessage(OptionsPanel.class, (String)"OptionsPanel.compilerOptionsLabel.text"));
        this.compilerOptionsTextField.setColumns(20);
        Mnemonics.setLocalizedText((JLabel)this.compilerOptionsInfoLabel, (String)NbBundle.getMessage(OptionsPanel.class, (String)"OptionsPanel.compilerOptionsInfoLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.enabledCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.configureExecutablesButton)).addGroup(layout.createSequentialGroup().addComponent(this.mappingsScrollPane, -2, 0, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.addButton).addComponent(this.removeButton).addComponent(this.moveDownButton, GroupLayout.Alignment.LEADING).addComponent(this.moveUpButton))).addGroup(layout.createSequentialGroup().addComponent(this.compilerOptionsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.compilerOptionsInfoLabel).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.compilerOptionsTextField))).addGroup(layout.createSequentialGroup().addComponent(this.watchLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.recompileButton)).addGroup(layout.createSequentialGroup().addComponent(this.mappingsInfoLabel).addGap(0, 0, Short.MAX_VALUE)));
        layout.linkSize(0, this.addButton, this.moveDownButton, this.moveUpButton, this.removeButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.enabledCheckBox).addComponent(this.configureExecutablesButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.watchLabel).addComponent(this.recompileButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mappingsScrollPane, -1, 195, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.moveUpButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.moveDownButton).addGap(0, 0, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mappingsInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.compilerOptionsLabel).addComponent(this.compilerOptionsTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.compilerOptionsInfoLabel)));
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        assert (EventQueue.isDispatchThread());
        this.mappings.add((Pair<String, String>)Pair.of((Object)"", (Object)""));
        this.mappingsTableModel.fireMappingsChange();
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        assert (EventQueue.isDispatchThread());
        int[] selectedRows = this.mappingsTable.getSelectedRows();
        assert (selectedRows.length > 0);
        for (int i = selectedRows.length - 1; i >= 0; --i) {
            this.mappings.remove(selectedRows[i]);
        }
        this.mappingsTableModel.fireMappingsChange();
    }

    private void configureExecutablesButtonActionPerformed(ActionEvent evt) {
        OptionsDisplayer.getDefault().open("Html5/CssPreprocessors");
    }

    private void recompileButtonActionPerformed(ActionEvent evt) {
        assert (EventQueue.isDispatchThread());
        CssPreprocessor cssPreprocessor = CssPreprocessors.getDefault().getCssPreprocessor(this.type.getIdentifier());
        assert (cssPreprocessor != null) : "CSS preprocessor must be found for identifier: " + this.type.getIdentifier();
        FileObject webRoot = CssPreprocessorUtils.getWebRoot(this.project);
        assert (webRoot != null) : "No web root found for project: " + this.project.getProjectDirectory();
        for (Pair<String, String> mapping : this.mappings) {
            FileObject input = FileUtil.toFileObject((File)CssPreprocessorUtils.resolveInput(webRoot, mapping));
            if (input == null) continue;
            CssPreprocessors.getDefault().process(cssPreprocessor, this.project, input);
        }
    }

    private void moveUpButtonActionPerformed(ActionEvent evt) {
        int[] selectedRows;
        assert (EventQueue.isDispatchThread());
        for (int selectedRow : selectedRows = this.mappingsTable.getSelectedRows()) {
            Pair<String, String> up = this.mappings.get(selectedRow);
            Pair<String, String> down = this.mappings.get(selectedRow - 1);
            this.mappings.set(selectedRow - 1, up);
            this.mappings.set(selectedRow, down);
        }
        this.mappingsTableModel.fireMappingsChange();
        this.selectRows(selectedRows, -1);
    }

    private void moveDownButtonActionPerformed(ActionEvent evt) {
        assert (EventQueue.isDispatchThread());
        int[] selectedRows = this.mappingsTable.getSelectedRows();
        for (int i = selectedRows.length - 1; i >= 0; --i) {
            int selectedRow = selectedRows[i];
            Pair<String, String> down = this.mappings.get(selectedRow);
            Pair<String, String> up = this.mappings.get(selectedRow + 1);
            this.mappings.set(selectedRow + 1, down);
            this.mappings.set(selectedRow, up);
        }
        this.mappingsTableModel.fireMappingsChange();
        this.selectRows(selectedRows, 1);
    }

    private static final class MappingsTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -65325657686411L;
        private final List<Pair<String, String>> mappings;

        public MappingsTableModel(List<Pair<String, String>> mappings) {
            assert (mappings != null);
            this.mappings = mappings;
        }

        @Override
        public int getRowCount() {
            return this.mappings.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Pair<String, String> pair = this.mappings.get(rowIndex);
            if (columnIndex == 0) {
                return pair.first();
            }
            if (columnIndex == 1) {
                return pair.second();
            }
            throw new IllegalStateException("Unknown column index: " + columnIndex);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            String path = (String)aValue;
            Pair<String, String> pair = this.mappings.get(rowIndex);
            if (columnIndex == 0) {
                this.mappings.set(rowIndex, (Pair<String, String>)Pair.of((Object)path, (Object)((String)pair.second())));
            } else if (columnIndex == 1) {
                this.mappings.set(rowIndex, (Pair<String, String>)Pair.of((Object)((String)pair.first()), (Object)path));
            } else {
                throw new IllegalStateException("Unknown column index: " + columnIndex);
            }
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return Bundle.MappingsTableModel_column_input_title();
            }
            if (columnIndex == 1) {
                return Bundle.MappingsTableModel_column_output_title();
            }
            throw new IllegalStateException("Unknown column index: " + columnIndex);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0 || columnIndex == 1) {
                return String.class;
            }
            throw new IllegalStateException("Unknown column index: " + columnIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex == 0 || columnIndex == 1) {
                return true;
            }
            throw new IllegalStateException("Unknown column index: " + columnIndex);
        }

        public void fireMappingsChange() {
            assert (EventQueue.isDispatchThread());
            this.fireTableDataChanged();
        }
    }
}

