/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.developer;

import com.oracle.bmc.artifacts.ArtifactsClient;
import com.oracle.bmc.artifacts.requests.DeleteContainerImageRequest;
import com.oracle.bmc.artifacts.requests.ListContainerImagesRequest;
import com.oracle.bmc.artifacts.responses.DeleteContainerImageResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.swing.Action;
import org.netbeans.modules.cloud.oracle.ChildrenProvider;
import org.netbeans.modules.cloud.oracle.NodeProvider;
import org.netbeans.modules.cloud.oracle.NotificationUtils;
import org.netbeans.modules.cloud.oracle.OCIManager;
import org.netbeans.modules.cloud.oracle.OCINode;
import org.netbeans.modules.cloud.oracle.developer.Bundle;
import org.netbeans.modules.cloud.oracle.developer.ContainerRepositoryItem;
import org.netbeans.modules.cloud.oracle.developer.ContainerTagItem;
import org.netbeans.modules.cloud.oracle.items.OCID;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.openide.actions.DeleteAction;
import org.openide.nodes.Children;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;

public class ContainerTagNode
extends OCINode {
    private static final String CONTAINER_TAG_ICON = "org/netbeans/modules/cloud/oracle/resources/containertag.svg";

    public ContainerTagNode(ContainerTagItem tag) {
        super((OCIItem)tag, Children.LEAF);
        this.setName(tag.getName());
        this.setDisplayName(tag.getName());
        this.setIconBaseWithExtension(CONTAINER_TAG_ICON);
        this.setShortDescription(Bundle.ContainerTagDesc(tag.getUrl(), tag.getVersion(), tag.getDigest()));
    }

    public static NodeProvider<ContainerTagItem> createNode() {
        return ContainerTagNode::new;
    }

    @Override
    public Action[] getActions(boolean context) {
        Action[] actions = super.getActions(context);
        ArrayList<Action> actionList = new ArrayList<Action>(Arrays.asList(actions));
        actionList.add((Action)SystemAction.get(DeleteAction.class));
        return (Action[])actionList.toArray(Action[]::new);
    }

    public boolean canDestroy() {
        return true;
    }

    public void destroy() throws IOException {
        RequestProcessor.getDefault().post(() -> {
            DeleteContainerImageResponse response;
            if (!NotificationUtils.confirmAction(Bundle.MSG_ConfirmDeleteAction(this.getName()))) {
                return;
            }
            ArtifactsClient client = OCIManager.getDefault().getActiveProfile(this.getItem()).newClient(ArtifactsClient.class);
            DeleteContainerImageRequest request = DeleteContainerImageRequest.builder().imageId(this.getItem().getKey().getValue()).build();
            try {
                response = client.deleteContainerImage(request);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                NotificationUtils.showErrorMessage(Bundle.MSG_DeleteActionFailed(this.getName()));
                return;
            }
            if (response.get__httpStatusCode__() != 204) {
                NotificationUtils.showErrorMessage(Bundle.MSG_DeleteActionFailed(this.getName()));
                return;
            }
            if (this.getParentNode() instanceof OCINode) {
                ((OCINode)this.getParentNode()).refresh();
            }
            NotificationUtils.showMessage(Bundle.MSG_DeleteActionSuccess(this.getName()));
        });
    }

    public static ChildrenProvider.SessionAware<ContainerRepositoryItem, ContainerTagItem> getContainerTags() {
        return (containerRepository, session) -> {
            ArtifactsClient client = session.newClient(ArtifactsClient.class);
            ListContainerImagesRequest listContainerImagesRequest = ListContainerImagesRequest.builder().compartmentId(containerRepository.getCompartmentId()).repositoryId(containerRepository.getKey().getValue()).build();
            String tenancyId = session.getTenancy().isPresent() ? session.getTenancy().get().getKey().getValue() : null;
            return client.listContainerImages(listContainerImagesRequest).getContainerImageCollection().getItems().stream().map(d -> new ContainerTagItem(OCID.of(d.getId(), "ContainerTag"), containerRepository.getCompartmentId(), containerRepository.getName(), containerRepository.getRegionCode(), containerRepository.getNamespace(), d.getVersion(), d.getDigest().trim(), tenancyId)).collect(Collectors.toList());
        };
    }
}

