/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.database;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.cloud.oracle.adm.URLProvider;
import org.netbeans.modules.cloud.oracle.assets.CloudAssets;
import org.netbeans.modules.cloud.oracle.items.OCID;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.netbeans.modules.cloud.oracle.vault.SensitiveData;
import org.openide.util.Exceptions;

public class DatabaseItem
extends OCIItem
implements SensitiveData,
URLProvider {
    private static final String DEFAULT_REF_NAME = "DEFAULT";
    private final String serviceUrl;
    private final String connectionName;

    public DatabaseItem(OCID id, String compartmentId, String name, String serviceUrl, String connectionName, String tenancyId, String regionCode) {
        super(id, compartmentId, name, tenancyId, regionCode);
        this.serviceUrl = serviceUrl;
        this.connectionName = connectionName;
    }

    public DatabaseItem() {
        this.serviceUrl = null;
        this.connectionName = null;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    @Override
    public int maxInProject() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Map<String, String> getSecrets() {
        HashMap<String, String> secrets = new HashMap<String, String>();
        DatabaseConnection conn = this.getCorrespondingConnection();
        if (conn == null) {
            return secrets;
        }
        String refName = this.getFormattedRefName();
        secrets.put("DATASOURCES_" + refName + "_USERNAME", conn.getUser());
        secrets.put("DATASOURCES_" + refName + "_PASSWORD", conn.getPassword());
        secrets.put("DATASOURCES_" + refName + "_WALLET_PASSWORD", UUID.randomUUID().toString());
        secrets.put("DATASOURCES_" + refName + "_COMPARTMENTOCID", (String)conn.getConnectionProperties().get("CompartmentOCID"));
        String ocid = (String)conn.getConnectionProperties().get("OCID");
        if (ocid != null && !ocid.isEmpty()) {
            secrets.put("DATASOURCES_" + refName + "_OCID", ocid);
        }
        return secrets;
    }

    private String getFormattedRefName() {
        String refName = CloudAssets.getDefault().getReferenceName(this);
        if (refName == null) {
            return DEFAULT_REF_NAME;
        }
        return refName.toUpperCase();
    }

    public DatabaseConnection getCorrespondingConnection() {
        DatabaseConnection[] connections = ConnectionManager.getDefault().getConnections();
        for (int i = 0; i < connections.length; ++i) {
            if (!this.getKey().getValue().equals(connections[i].getConnectionProperties().get("OCID"))) continue;
            return connections[i];
        }
        return null;
    }

    @Override
    public URL getURL() {
        if (this.getKey().getValue() != null && this.getRegion() != null) {
            try {
                URI uri = new URI(String.format("https://cloud.oracle.com/db/adbs/%s?region=%s", this.getKey().getValue(), this.getRegion()));
                return uri.toURL();
            }
            catch (MalformedURLException | URISyntaxException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }
}

