/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.assets.k8s;

import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretList;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.ServiceAccountBuilder;
import io.fabric8.kubernetes.api.model.ServiceAccountFluent;
import io.fabric8.kubernetes.api.model.ServiceAccountList;
import io.fabric8.kubernetes.api.model.batch.v1.CronJob;
import io.fabric8.kubernetes.api.model.batch.v1.CronJobBuilder;
import io.fabric8.kubernetes.api.model.batch.v1.CronJobFluent;
import io.fabric8.kubernetes.api.model.batch.v1.CronJobList;
import io.fabric8.kubernetes.api.model.batch.v1.CronJobSpecFluent;
import io.fabric8.kubernetes.api.model.batch.v1.JobBuilder;
import io.fabric8.kubernetes.api.model.batch.v1.JobFluent;
import io.fabric8.kubernetes.api.model.batch.v1.JobTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.rbac.ClusterRole;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBinding;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingBuilder;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingFluent;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingList;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBuilder;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleFluent;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.ScalableResource;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.netbeans.modules.cloud.oracle.NotificationUtils;
import org.netbeans.modules.cloud.oracle.assets.CloudAssets;
import org.netbeans.modules.cloud.oracle.assets.k8s.Bundle;
import org.netbeans.modules.cloud.oracle.assets.k8s.ClusterItem;
import org.netbeans.modules.cloud.oracle.assets.k8s.KubernetesUtils;
import org.netbeans.spi.lsp.CommandProvider;

public class CreateSecretRotationCronJobCommand
implements CommandProvider {
    private static final String COMMAND_CREATE_CRONJOB = "nbls.cloud.assets.cluster.cronjob.create";
    private static final String SECRET_NAME = "docker-bearer-vscode-generated-ocirsecret";
    private static final String CRONJOB_NAME = "secret-rotation-cronjob";
    private static final String CLUSTER_ROLE_BINDING_NAME = "secret-manager-binding";
    private static final String CLUSTER_ROLE_NAME = "secret-manager";
    private static final String SERVICE_ACCOUNT_NAME = "create-secret-svc-account";
    private static final String BASE_IMAGE = "ghcr.io/oracle/oci-cli:latest";
    private static final String CONTAINER_NAME = "create-secret";
    private static final int WAITING_TIMEOUT = 60;
    private static final Set COMMANDS = new HashSet<String>(Arrays.asList("nbls.cloud.assets.cluster.cronjob.create"));
    private ClusterItem cluster;

    public Set<String> getCommands() {
        return Collections.unmodifiableSet(COMMANDS);
    }

    public CompletableFuture<Object> runCommand(String command, List<Object> arguments) {
        return this.createSecretRotationCronJob();
    }

    public CompletableFuture<Object> createSecretRotationCronJob() {
        CompletableFuture<Object> completableFuture = new CompletableFuture<Object>();
        this.cluster = CloudAssets.getDefault().getItem(ClusterItem.class);
        KubernetesUtils.runWithClient(this.cluster, client -> {
            try {
                ServiceAccount serviceAccount = this.createServiceAccountIfNotExist((KubernetesClient)client);
                this.createClusterRoleIfNotExist((KubernetesClient)client);
                this.createClusterRoleBindingIfNotExist((KubernetesClient)client);
                this.createCronJobIfNotExist((KubernetesClient)client, serviceAccount);
                completableFuture.complete(null);
            }
            catch (Exception ex) {
                completableFuture.completeExceptionally(ex);
                NotificationUtils.showErrorMessage(Bundle.CronJobCreationError());
            }
        });
        return completableFuture;
    }

    private void createCronJobIfNotExist(KubernetesClient client, ServiceAccount serviceAccount) {
        CronJobList existingCronJobs = (CronJobList)((NonNamespaceOperation)client.batch().v1().cronjobs().inNamespace(this.cluster.getNamespace())).list();
        CronJob cronJob = (CronJob)KubernetesUtils.findResource(client, (KubernetesResourceList<? extends HasMetadata>)existingCronJobs, CRONJOB_NAME);
        if (cronJob != null) {
            if (!this.secretExist(client)) {
                this.invokeCronJob(client, cronJob);
            }
            return;
        }
        cronJob = ((CronJobBuilder)((CronJobFluent.SpecNested)((CronJobSpecFluent.JobTemplateNested)((JobTemplateSpecFluent.SpecNested)((JobTemplateSpecFluent.SpecNested)((CronJobFluent.SpecNested)((CronJobBuilder)((CronJobFluent.MetadataNested)((CronJobFluent.MetadataNested)new CronJobBuilder().withNewMetadata().withName(CRONJOB_NAME)).withNamespace(this.cluster.getNamespace())).endMetadata()).withNewSpec().withSchedule(this.getCronExpression())).withNewJobTemplate().withNewSpec().withBackoffLimit(Integer.valueOf(0))).withTemplate(this.cronJobPodTemplate(serviceAccount))).endSpec()).endJobTemplate()).endSpec()).build();
        ((Resource)((NonNamespaceOperation)client.batch().v1().cronjobs().inNamespace(this.cluster.getNamespace())).resource((Object)cronJob)).create();
        this.invokeCronJob(client, cronJob);
    }

    private boolean secretExist(KubernetesClient client) {
        SecretList existingSecrets = (SecretList)((NonNamespaceOperation)client.secrets().inNamespace(this.cluster.getNamespace())).list();
        Secret secret = (Secret)KubernetesUtils.findResource(client, (KubernetesResourceList<? extends HasMetadata>)existingSecrets, SECRET_NAME);
        return secret != null;
    }

    private void invokeCronJob(KubernetesClient client, CronJob cronJob) {
        ((ScalableResource)((NonNamespaceOperation)client.batch().v1().jobs().inNamespace(this.cluster.getNamespace())).resource((Object)((JobBuilder)((JobBuilder)((JobFluent.MetadataNested)new JobBuilder().withNewMetadata().withName("cronjob-invocation-" + String.valueOf(UUID.randomUUID()))).endMetadata()).withSpec(cronJob.getSpec().getJobTemplate().getSpec())).build())).create();
        this.waitForConditionWithTimeout(() -> this.secretExist(client), 60L).join();
    }

    private CompletableFuture<Void> waitForConditionWithTimeout(Supplier<Boolean> condition, long timeout) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
        ScheduledFuture<?> checkTask = executor.scheduleAtFixedRate(() -> {
            if (((Boolean)condition.get()).booleanValue()) {
                future.complete(null);
            }
        }, 0L, 5L, TimeUnit.SECONDS);
        executor.schedule(() -> {
            if (!future.isDone()) {
                future.completeExceptionally(new TimeoutException("Condition was not met within the timeout."));
            }
            checkTask.cancel(true);
            executor.shutdown();
        }, timeout, TimeUnit.SECONDS);
        return future;
    }

    private String getCronExpression() {
        Calendar calendar = Calendar.getInstance();
        int currentMinute = calendar.get(12);
        return currentMinute + " * * * *";
    }

    private PodTemplateSpec cronJobPodTemplate(ServiceAccount serviceAccount) {
        return ((PodTemplateSpecBuilder)((PodTemplateSpecFluent.SpecNested)((PodTemplateSpecFluent.SpecNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodTemplateSpecFluent.SpecNested)new PodTemplateSpecBuilder().withNewSpec().withHostNetwork(Boolean.TRUE)).addNewContainer().withName(CONTAINER_NAME)).withImage(BASE_IMAGE)).addNewEnv().withName("OCI_CLI_AUTH")).withValue("instance_principal")).endEnv()).withCommand(new String[]{"/bin/bash", "-c", this.createSecretCommand()})).endContainer()).withRestartPolicy("Never")).withServiceAccountName(serviceAccount.getMetadata().getName())).endSpec()).build();
    }

    private ServiceAccount createServiceAccountIfNotExist(KubernetesClient client) {
        ServiceAccountList existingServiceAccounts = (ServiceAccountList)((NonNamespaceOperation)client.serviceAccounts().inNamespace(this.cluster.getNamespace())).list();
        ServiceAccount serviceAccount = (ServiceAccount)KubernetesUtils.findResource(client, (KubernetesResourceList<? extends HasMetadata>)existingServiceAccounts, SERVICE_ACCOUNT_NAME);
        if (serviceAccount != null) {
            return serviceAccount;
        }
        serviceAccount = ((ServiceAccountBuilder)((ServiceAccountFluent.MetadataNested)new ServiceAccountBuilder().withNewMetadata().withName(SERVICE_ACCOUNT_NAME)).endMetadata()).build();
        return (ServiceAccount)((Resource)((NonNamespaceOperation)client.serviceAccounts().inNamespace(this.cluster.getNamespace())).resource((Object)serviceAccount)).create();
    }

    private void createClusterRoleIfNotExist(KubernetesClient client) {
        ClusterRoleList existingClusterRole = (ClusterRoleList)client.rbac().clusterRoles().list();
        ClusterRole clusterRole = (ClusterRole)KubernetesUtils.findResource(client, (KubernetesResourceList<? extends HasMetadata>)existingClusterRole, CLUSTER_ROLE_NAME);
        if (clusterRole != null) {
            return;
        }
        clusterRole = ((ClusterRoleBuilder)((ClusterRoleFluent.RulesNested)((ClusterRoleFluent.RulesNested)((ClusterRoleFluent.RulesNested)((ClusterRoleBuilder)((ClusterRoleFluent.MetadataNested)new ClusterRoleBuilder().withNewMetadata().withName(CLUSTER_ROLE_NAME)).endMetadata()).addNewRule().withApiGroups(new String[]{""})).withResources(new String[]{"secrets"})).withVerbs(new String[]{"create", "get", "patch", "delete"})).endRule()).build();
        ((Resource)client.rbac().clusterRoles().resource((Object)clusterRole)).create();
    }

    private void createClusterRoleBindingIfNotExist(KubernetesClient client) {
        ClusterRoleBindingList existingClusterRoleBinding = (ClusterRoleBindingList)client.rbac().clusterRoleBindings().list();
        ClusterRoleBinding clusterRoleBinding = (ClusterRoleBinding)KubernetesUtils.findResource(client, (KubernetesResourceList<? extends HasMetadata>)existingClusterRoleBinding, CLUSTER_ROLE_BINDING_NAME);
        if (clusterRoleBinding != null) {
            return;
        }
        clusterRoleBinding = ((ClusterRoleBindingBuilder)((ClusterRoleBindingFluent.RoleRefNested)((ClusterRoleBindingFluent.RoleRefNested)((ClusterRoleBindingFluent.RoleRefNested)((ClusterRoleBindingBuilder)((ClusterRoleBindingFluent.SubjectsNested)((ClusterRoleBindingFluent.SubjectsNested)((ClusterRoleBindingFluent.SubjectsNested)((ClusterRoleBindingBuilder)((ClusterRoleBindingFluent.MetadataNested)new ClusterRoleBindingBuilder().withNewMetadata().withName(CLUSTER_ROLE_BINDING_NAME)).endMetadata()).addNewSubject().withName(SERVICE_ACCOUNT_NAME)).withKind("ServiceAccount")).withNamespace(this.cluster.getNamespace())).endSubject()).withNewRoleRef().withKind("ClusterRole")).withName(CLUSTER_ROLE_NAME)).withApiGroup("rbac.authorization.k8s.io")).endRoleRef()).build();
        ((Resource)client.rbac().clusterRoleBindings().resource((Object)clusterRoleBinding)).create();
    }

    private String createSecretCommand() {
        String repoEndpoint = this.cluster.getRegionCode() + ".ocir.io";
        return "KUBECTL_VERSION=\"v1.27.4\"\ncase \"$(uname -m)\" in\n  x86_64) ARCHITECTURE=\"amd64\" ;;\n  aarch64) ARCHITECTURE=\"arm64\" ;;\n  *) ARCHITECTURE=\"Unknown architecture\" ;;\nesac\nKUBECTL_URL=\"https://dl.k8s.io/release/${KUBECTL_VERSION}/bin/linux/${ARCHITECTURE}/kubectl\"\nmkdir -p /tmp/bin\ncurl -LO \"${KUBECTL_URL}\"\nchmod +x ./kubectl\nmv ./kubectl /tmp/bin/kubectl\nexport PATH=$PATH:/tmp/bin\nTOKEN=$(oci raw-request --http-method GET --target-uri https://" + repoEndpoint + "/20180419/docker/token | jq -r '.data.token')\nkubectl create secret --save-config --dry-run=client docker-registry docker-bearer-vscode-generated-ocirsecret --docker-server=" + repoEndpoint + " --docker-username=BEARER_TOKEN --docker-password=\"$TOKEN\" -o yaml | kubectl apply -f - ";
    }
}

