/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GetBucketRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private String bucketName;
    private String ifMatch;
    private String ifNoneMatch;
    private String opcClientRequestId;
    private List<Fields> fields;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getIfNoneMatch() {
        return this.ifNoneMatch;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public List<Fields> getFields() {
        return this.fields;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).bucketName(this.bucketName).ifMatch(this.ifMatch).ifNoneMatch(this.ifNoneMatch).opcClientRequestId(this.opcClientRequestId).fields(this.fields);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",bucketName=").append(String.valueOf(this.bucketName));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",ifNoneMatch=").append(String.valueOf(this.ifNoneMatch));
        sb.append(",opcClientRequestId=").append(String.valueOf(this.opcClientRequestId));
        sb.append(",fields=").append(String.valueOf(this.fields));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetBucketRequest)) {
            return false;
        }
        GetBucketRequest other = (GetBucketRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals(this.bucketName, other.bucketName) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.ifNoneMatch, other.ifNoneMatch) && Objects.equals(this.opcClientRequestId, other.opcClientRequestId) && Objects.equals(this.fields, other.fields);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.bucketName == null ? 43 : this.bucketName.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.ifNoneMatch == null ? 43 : this.ifNoneMatch.hashCode());
        result = result * 59 + (this.opcClientRequestId == null ? 43 : this.opcClientRequestId.hashCode());
        result = result * 59 + (this.fields == null ? 43 : this.fields.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetBucketRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private String bucketName = null;
        private String ifMatch = null;
        private String ifNoneMatch = null;
        private String opcClientRequestId = null;
        private List<Fields> fields = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder ifNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder fields(List<Fields> fields) {
            this.fields = fields;
            return this;
        }

        public Builder fields(Fields singularValue) {
            return this.fields(Arrays.asList(singularValue));
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetBucketRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.bucketName(o.getBucketName());
            this.ifMatch(o.getIfMatch());
            this.ifNoneMatch(o.getIfNoneMatch());
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.fields(o.getFields());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetBucketRequest build() {
            GetBucketRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetBucketRequest buildWithoutInvocationCallback() {
            GetBucketRequest request = new GetBucketRequest();
            request.namespaceName = this.namespaceName;
            request.bucketName = this.bucketName;
            request.ifMatch = this.ifMatch;
            request.ifNoneMatch = this.ifNoneMatch;
            request.opcClientRequestId = this.opcClientRequestId;
            request.fields = this.fields;
            return request;
        }
    }

    public static enum Fields implements BmcEnum
    {
        ApproximateCount("approximateCount"),
        ApproximateSize("approximateSize"),
        AutoTiering("autoTiering");

        private final String value;
        private static Map<String, Fields> map;

        private Fields(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Fields create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Fields: " + key);
        }

        static {
            map = new HashMap<String, Fields>();
            for (Fields v : Fields.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

