/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.nbimpl.javac;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.utils.VMUtils;
import org.netbeans.modules.profiler.nbimpl.javac.Bundle;
import org.netbeans.modules.profiler.nbimpl.javac.ParsingUtils;
import org.netbeans.modules.profiler.nbimpl.javac.ScanSensitiveTask;
import org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class ElementUtilitiesEx {
    private static final String VM_CONSTRUCTUR_SIG = "<init>";
    private static final String VM_INITIALIZER_SIG = "<clinit>";
    private static final Logger LOG = Logger.getLogger(ElementUtilitiesEx.class.getName());

    public static String getBinaryName(ExecutableElement method, CompilationInfo ci) {
        try {
            switch (method.getKind()) {
                case METHOD: 
                case CONSTRUCTOR: 
                case STATIC_INIT: {
                    String paramsVMSignature = ElementUtilitiesEx.getParamsSignature(method.getParameters(), ci);
                    String retTypeVMSignature = VMUtils.typeToVMSignature((String)ElementUtilitiesEx.getRealTypeName(method.getReturnType(), ci));
                    return "(" + paramsVMSignature + ")" + retTypeVMSignature;
                }
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            ProfilerLogger.warning((String)e.getMessage());
            return null;
        }
    }

    public static ElementHandle<TypeElement> resolveClassByName(final String className, ClasspathInfo cpInfo, final boolean fuzzy) {
        if (className == null || cpInfo == null) {
            return null;
        }
        final ElementHandle[] rslt = new ElementHandle[1];
        ParsingUtils.invokeScanSensitiveTask(cpInfo, new ScanSensitiveTask<CompilationController>(){

            public void run(CompilationController cc) throws Exception {
                TypeElement te = ElementUtilitiesEx.resolveClassByName(className, cc, fuzzy);
                if (te != null) {
                    rslt[0] = ElementHandle.create((Element)te);
                }
            }

            @Override
            public boolean shouldRetry() {
                return rslt[0] == null;
            }
        });
        return rslt[0];
    }

    public static TypeElement resolveClassByName(String className, CompilationController controller, boolean fuzzy) {
        if (className == null || controller == null) {
            return null;
        }
        TypeElement mainClass = controller.getElements().getTypeElement(className.replace('$', '.'));
        if (mainClass == null) {
            try {
                int innerIndex = className.indexOf(36);
                if (innerIndex > -1) {
                    TypeElement anon;
                    FileObject fo = null;
                    String topClassName = className.substring(0, innerIndex);
                    mainClass = controller.getElements().getTypeElement(topClassName);
                    if (mainClass != null) {
                        fo = SourceUtils.getFile((ElementHandle)ElementHandle.create((Element)mainClass), (ClasspathInfo)controller.getClasspathInfo());
                    }
                    if (fo != null) {
                        anon = ElementUtilitiesEx.getAnonymousFromSource(fo, className);
                    } else {
                        mainClass = anon = ElementUtilitiesEx.getAnonymousFromBinary(controller, className);
                    }
                    mainClass = anon == null && fuzzy ? mainClass : anon;
                }
            }
            catch (IOException e) {
                ProfilerLogger.log((Exception)e);
            }
        }
        if (mainClass != null) {
            ProfilerLogger.debug((String)("Resolved: " + mainClass));
        } else {
            ProfilerLogger.debug((String)("Could not resolve: " + className));
        }
        if (mainClass == null) {
            StatusDisplayer.getDefault().setStatusText(Bundle.MDRUtils_ClassNotResolvedMessage(className));
        }
        return mainClass;
    }

    private static TypeElement getAnonymousFromSource(FileObject fo, final String className) throws IllegalArgumentException, IOException {
        final TypeElement[] resolvedClassElement = new TypeElement[1];
        JavaSource js = JavaSource.forFileObject((FileObject)fo);
        if (js != null) {
            js.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(final CompilationController cc) throws Exception {
                    cc.toPhase(JavaSource.Phase.RESOLVED);
                    new ErrorAwareTreePathScanner<Void, Void>(this){
                        final /* synthetic */ 2 this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public Void visitClass(ClassTree node, Void p) {
                            TypeElement te = (TypeElement)cc.getTrees().getElement(this.getCurrentPath());
                            if (te != null && className.equals(ElementUtilities.getBinaryName((TypeElement)te))) {
                                resolvedClassElement[0] = te;
                            }
                            return (Void)super.visitClass(node, (Object)p);
                        }
                    }.scan((Tree)cc.getCompilationUnit(), null);
                }
            }, true);
        }
        return resolvedClassElement[0];
    }

    private static TypeElement getAnonymousFromBinary(CompilationController controller, final String className) throws IOException {
        String resPath = className.replace('.', '/') + ".class";
        FileObject fo = controller.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.BOOT).findResource(resPath);
        if (fo == null) {
            fo = controller.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE).findResource(resPath);
        }
        if (fo == null) {
            fo = controller.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.COMPILE).findResource(resPath);
        }
        if (fo != null) {
            final TypeElement[] resolvedClassElement = new TypeElement[1];
            JavaSource js = JavaSource.forFileObject((FileObject)fo);
            if (js != null) {
                js.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController cc) throws Exception {
                        for (TypeElement te : cc.getTopLevelElements()) {
                            if (!ElementUtilities.getBinaryName((TypeElement)te).equals(className)) continue;
                            resolvedClassElement[0] = te;
                            break;
                        }
                    }
                }, true);
                return resolvedClassElement[0];
            }
        }
        return null;
    }

    public static Set<ElementHandle<TypeElement>> findImplementors(final ClasspathInfo cpInfo, final ElementHandle<TypeElement> baseType) {
        final EnumSet<ClassIndex.SearchKind> kind = EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS);
        final EnumSet<ClassIndex.SearchScope> scope = EnumSet.allOf(ClassIndex.SearchScope.class);
        final HashSet<ElementHandle<TypeElement>> allImplementors = new HashSet<ElementHandle<TypeElement>>();
        ParsingUtils.invokeScanSensitiveTask(cpInfo, new ScanSensitiveTask<CompilationController>(true){

            public void run(CompilationController cc) {
                HashSet tmpImplementors;
                HashSet implementors = cpInfo.getClassIndex().getElements(baseType, kind, scope);
                do {
                    tmpImplementors = new HashSet();
                    allImplementors.addAll(implementors);
                    for (ElementHandle element : implementors) {
                        tmpImplementors.addAll(cpInfo.getClassIndex().getElements(element, kind, scope));
                    }
                } while (!(implementors = tmpImplementors).isEmpty());
            }
        });
        return allImplementors;
    }

    public static Set<TypeElement> findImplementorsResolved(ClasspathInfo cpInfo, ElementHandle<TypeElement> baseType) {
        final HashSet<TypeElement> implementors = new HashSet<TypeElement>();
        final Set<ElementHandle<TypeElement>> implHandles = ElementUtilitiesEx.findImplementors(cpInfo, baseType);
        if (!implHandles.isEmpty()) {
            ParsingUtils.invokeScanSensitiveTask(cpInfo, new ScanSensitiveTask<CompilationController>(true){

                public void run(CompilationController controller) throws Exception {
                    if (controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED).compareTo((Enum)JavaSource.Phase.ELEMENTS_RESOLVED) < 0) {
                        return;
                    }
                    for (ElementHandle eh : implHandles) {
                        implementors.add((TypeElement)eh.resolve((CompilationInfo)controller));
                    }
                }
            });
        }
        return implementors;
    }

    public static ExecutableElement resolveMethodByName(CompilationInfo ci, TypeElement parentClass, String methodName, String signature) {
        if (parentClass == null || methodName == null) {
            return null;
        }
        ExecutableElement foundMethod = null;
        boolean found = false;
        List<ExecutableElement> methods = methodName.equals(VM_CONSTRUCTUR_SIG) ? ElementFilter.constructorsIn(ci.getElements().getAllMembers(parentClass)) : ElementFilter.methodsIn(ci.getElements().getAllMembers(parentClass));
        for (ExecutableElement method : methods) {
            if (!ElementUtilitiesEx.methodNameMatch(methodName, method)) continue;
            if (signature != null && ElementUtilitiesEx.methodSignatureMatch(ci, signature, method)) {
                foundMethod = method;
                found = true;
                break;
            }
            foundMethod = method;
        }
        if (!found) {
            ProfilerLogger.debug((String)("Could not find exact signature match, opening at first method with same name: " + foundMethod));
        }
        return foundMethod;
    }

    private static String getParamsSignature(List<? extends VariableElement> params, CompilationInfo ci) {
        StringBuilder ret = new StringBuilder();
        Iterator<? extends VariableElement> it = params.iterator();
        while (it.hasNext()) {
            TypeMirror type = it.next().asType();
            String realTypeName = ElementUtilitiesEx.getRealTypeName(type, ci);
            String typeVMSignature = VMUtils.typeToVMSignature((String)realTypeName);
            ret.append(typeVMSignature);
        }
        return ret.toString();
    }

    private static String getRealTypeName(TypeMirror type, CompilationInfo ci) {
        TypeMirror et = ci.getTypes().erasure(type);
        if (et.getKind() == TypeKind.DECLARED) {
            return ElementUtilities.getBinaryName((TypeElement)((TypeElement)((DeclaredType)et).asElement()));
        }
        if (et.getKind() == TypeKind.ARRAY) {
            return ElementUtilitiesEx.getRealTypeName(((ArrayType)et).getComponentType(), ci) + "[]";
        }
        return et.toString();
    }

    private static JavaSource getSources(FileObject[] roots) {
        return JavaSource.create((ClasspathInfo)ElementUtilitiesEx.getClasspathInfo(roots), Collections.emptyList());
    }

    private static ClasspathInfo getClasspathInfo(FileObject[] roots) {
        ClassPath compilePath;
        ClassPath bootPath;
        ClassPath srcPath;
        ClassPath cpEmpty = ClassPathSupport.createClassPath((FileObject[])new FileObject[0]);
        if (roots == null || roots.length == 0) {
            Set paths = GlobalPathRegistry.getDefault().getPaths("classpath/source");
            srcPath = ClassPathSupport.createProxyClassPath((ClassPath[])paths.toArray(new ClassPath[0]));
            bootPath = JavaPlatform.getDefault().getBootstrapLibraries();
            paths = GlobalPathRegistry.getDefault().getPaths("classpath/compile");
            compilePath = ClassPathSupport.createProxyClassPath((ClassPath[])paths.toArray(new ClassPath[0]));
        } else {
            srcPath = ClassPathSupport.createClassPath((FileObject[])roots);
            bootPath = ClassPath.getClassPath((FileObject)roots[0], (String)"classpath/boot");
            compilePath = ClassPath.getClassPath((FileObject)roots[0], (String)"classpath/compile");
        }
        return ClasspathInfo.create((ClassPath)(bootPath != null ? bootPath : cpEmpty), (ClassPath)(compilePath != null ? compilePath : cpEmpty), (ClassPath)srcPath);
    }

    public static JavaSource getSources(Project project) {
        if (project == null) {
            return ElementUtilitiesEx.getSources((FileObject[])null);
        }
        return ElementUtilitiesEx.getSources(ProjectUtilities.getSourceRoots((Lookup.Provider)project, (boolean)true));
    }

    private static boolean methodNameMatch(String vmName, ExecutableElement ee) {
        switch (ee.getKind()) {
            case METHOD: {
                return ee.getSimpleName().contentEquals(vmName);
            }
            case CONSTRUCTOR: {
                return vmName.equals(VM_CONSTRUCTUR_SIG);
            }
            case STATIC_INIT: 
            case INSTANCE_INIT: {
                return vmName.equals(VM_INITIALIZER_SIG);
            }
        }
        return false;
    }

    private static boolean methodSignatureMatch(CompilationInfo ci, String vmSig, ExecutableElement ee) {
        return ElementUtilitiesEx.getBinaryName(ee, ci).equals(vmSig);
    }
}

