/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.core.model.UpdateCaptureFilterDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateCaptureFilterRequest
extends BmcRequest<UpdateCaptureFilterDetails> {
    private String captureFilterId;
    private UpdateCaptureFilterDetails updateCaptureFilterDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getCaptureFilterId() {
        return this.captureFilterId;
    }

    public UpdateCaptureFilterDetails getUpdateCaptureFilterDetails() {
        return this.updateCaptureFilterDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateCaptureFilterDetails getBody$() {
        return this.updateCaptureFilterDetails;
    }

    public Builder toBuilder() {
        return new Builder().captureFilterId(this.captureFilterId).updateCaptureFilterDetails(this.updateCaptureFilterDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",captureFilterId=").append(String.valueOf(this.captureFilterId));
        sb.append(",updateCaptureFilterDetails=").append(String.valueOf((Object)this.updateCaptureFilterDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateCaptureFilterRequest)) {
            return false;
        }
        UpdateCaptureFilterRequest other = (UpdateCaptureFilterRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.captureFilterId, other.captureFilterId) && Objects.equals((Object)this.updateCaptureFilterDetails, (Object)other.updateCaptureFilterDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.captureFilterId == null ? 43 : this.captureFilterId.hashCode());
        result = result * 59 + (this.updateCaptureFilterDetails == null ? 43 : this.updateCaptureFilterDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateCaptureFilterRequest, UpdateCaptureFilterDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String captureFilterId = null;
        private UpdateCaptureFilterDetails updateCaptureFilterDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder captureFilterId(String captureFilterId) {
            this.captureFilterId = captureFilterId;
            return this;
        }

        public Builder updateCaptureFilterDetails(UpdateCaptureFilterDetails updateCaptureFilterDetails) {
            this.updateCaptureFilterDetails = updateCaptureFilterDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateCaptureFilterRequest o) {
            this.captureFilterId(o.getCaptureFilterId());
            this.updateCaptureFilterDetails(o.getUpdateCaptureFilterDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateCaptureFilterRequest build() {
            UpdateCaptureFilterRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateCaptureFilterDetails body) {
            this.updateCaptureFilterDetails(body);
            return this;
        }

        public UpdateCaptureFilterRequest buildWithoutInvocationCallback() {
            UpdateCaptureFilterRequest request = new UpdateCaptureFilterRequest();
            request.captureFilterId = this.captureFilterId;
            request.updateCaptureFilterDetails = this.updateCaptureFilterDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

