/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class LetterOfAuthority
extends ExplicitlySetBmcModel {
    @JsonProperty(value="authorizedEntityName")
    private final String authorizedEntityName;
    @JsonProperty(value="circuitType")
    private final CircuitType circuitType;
    @JsonProperty(value="crossConnectId")
    private final String crossConnectId;
    @JsonProperty(value="facilityLocation")
    private final String facilityLocation;
    @JsonProperty(value="portName")
    private final String portName;
    @JsonProperty(value="timeExpires")
    private final Date timeExpires;
    @JsonProperty(value="timeIssued")
    private final Date timeIssued;

    @Deprecated
    @ConstructorProperties(value={"authorizedEntityName", "circuitType", "crossConnectId", "facilityLocation", "portName", "timeExpires", "timeIssued"})
    public LetterOfAuthority(String authorizedEntityName, CircuitType circuitType, String crossConnectId, String facilityLocation, String portName, Date timeExpires, Date timeIssued) {
        this.authorizedEntityName = authorizedEntityName;
        this.circuitType = circuitType;
        this.crossConnectId = crossConnectId;
        this.facilityLocation = facilityLocation;
        this.portName = portName;
        this.timeExpires = timeExpires;
        this.timeIssued = timeIssued;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getAuthorizedEntityName() {
        return this.authorizedEntityName;
    }

    public CircuitType getCircuitType() {
        return this.circuitType;
    }

    public String getCrossConnectId() {
        return this.crossConnectId;
    }

    public String getFacilityLocation() {
        return this.facilityLocation;
    }

    public String getPortName() {
        return this.portName;
    }

    public Date getTimeExpires() {
        return this.timeExpires;
    }

    public Date getTimeIssued() {
        return this.timeIssued;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("LetterOfAuthority(");
        sb.append("super=").append(super.toString());
        sb.append("authorizedEntityName=").append(String.valueOf(this.authorizedEntityName));
        sb.append(", circuitType=").append(String.valueOf((Object)this.circuitType));
        sb.append(", crossConnectId=").append(String.valueOf(this.crossConnectId));
        sb.append(", facilityLocation=").append(String.valueOf(this.facilityLocation));
        sb.append(", portName=").append(String.valueOf(this.portName));
        sb.append(", timeExpires=").append(String.valueOf(this.timeExpires));
        sb.append(", timeIssued=").append(String.valueOf(this.timeIssued));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LetterOfAuthority)) {
            return false;
        }
        LetterOfAuthority other = (LetterOfAuthority)((Object)o);
        return Objects.equals(this.authorizedEntityName, other.authorizedEntityName) && Objects.equals((Object)this.circuitType, (Object)other.circuitType) && Objects.equals(this.crossConnectId, other.crossConnectId) && Objects.equals(this.facilityLocation, other.facilityLocation) && Objects.equals(this.portName, other.portName) && Objects.equals(this.timeExpires, other.timeExpires) && Objects.equals(this.timeIssued, other.timeIssued) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.authorizedEntityName == null ? 43 : this.authorizedEntityName.hashCode());
        result = result * 59 + (this.circuitType == null ? 43 : this.circuitType.hashCode());
        result = result * 59 + (this.crossConnectId == null ? 43 : this.crossConnectId.hashCode());
        result = result * 59 + (this.facilityLocation == null ? 43 : this.facilityLocation.hashCode());
        result = result * 59 + (this.portName == null ? 43 : this.portName.hashCode());
        result = result * 59 + (this.timeExpires == null ? 43 : this.timeExpires.hashCode());
        result = result * 59 + (this.timeIssued == null ? 43 : this.timeIssued.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum CircuitType implements BmcEnum
    {
        SingleModeLc("Single_mode_LC"),
        SingleModeSc("Single_mode_SC"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, CircuitType> map;

        private CircuitType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static CircuitType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'CircuitType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(CircuitType.class);
            map = new HashMap<String, CircuitType>();
            for (CircuitType v : CircuitType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="authorizedEntityName")
        private String authorizedEntityName;
        @JsonProperty(value="circuitType")
        private CircuitType circuitType;
        @JsonProperty(value="crossConnectId")
        private String crossConnectId;
        @JsonProperty(value="facilityLocation")
        private String facilityLocation;
        @JsonProperty(value="portName")
        private String portName;
        @JsonProperty(value="timeExpires")
        private Date timeExpires;
        @JsonProperty(value="timeIssued")
        private Date timeIssued;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder authorizedEntityName(String authorizedEntityName) {
            this.authorizedEntityName = authorizedEntityName;
            this.__explicitlySet__.add("authorizedEntityName");
            return this;
        }

        public Builder circuitType(CircuitType circuitType) {
            this.circuitType = circuitType;
            this.__explicitlySet__.add("circuitType");
            return this;
        }

        public Builder crossConnectId(String crossConnectId) {
            this.crossConnectId = crossConnectId;
            this.__explicitlySet__.add("crossConnectId");
            return this;
        }

        public Builder facilityLocation(String facilityLocation) {
            this.facilityLocation = facilityLocation;
            this.__explicitlySet__.add("facilityLocation");
            return this;
        }

        public Builder portName(String portName) {
            this.portName = portName;
            this.__explicitlySet__.add("portName");
            return this;
        }

        public Builder timeExpires(Date timeExpires) {
            this.timeExpires = timeExpires;
            this.__explicitlySet__.add("timeExpires");
            return this;
        }

        public Builder timeIssued(Date timeIssued) {
            this.timeIssued = timeIssued;
            this.__explicitlySet__.add("timeIssued");
            return this;
        }

        public LetterOfAuthority build() {
            LetterOfAuthority model = new LetterOfAuthority(this.authorizedEntityName, this.circuitType, this.crossConnectId, this.facilityLocation, this.portName, this.timeExpires, this.timeIssued);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(LetterOfAuthority model) {
            if (model.wasPropertyExplicitlySet("authorizedEntityName")) {
                this.authorizedEntityName(model.getAuthorizedEntityName());
            }
            if (model.wasPropertyExplicitlySet("circuitType")) {
                this.circuitType(model.getCircuitType());
            }
            if (model.wasPropertyExplicitlySet("crossConnectId")) {
                this.crossConnectId(model.getCrossConnectId());
            }
            if (model.wasPropertyExplicitlySet("facilityLocation")) {
                this.facilityLocation(model.getFacilityLocation());
            }
            if (model.wasPropertyExplicitlySet("portName")) {
                this.portName(model.getPortName());
            }
            if (model.wasPropertyExplicitlySet("timeExpires")) {
                this.timeExpires(model.getTimeExpires());
            }
            if (model.wasPropertyExplicitlySet("timeIssued")) {
                this.timeIssued(model.getTimeIssued());
            }
            return this;
        }
    }
}

