/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.core.model.ImageSourceViaObjectStorageTupleDetails;
import com.oracle.bmc.core.model.ImageSourceViaObjectStorageUriDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="sourceType", defaultImpl=ImageSourceDetails.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=ImageSourceViaObjectStorageTupleDetails.class, name="objectStorageTuple"), @JsonSubTypes.Type(value=ImageSourceViaObjectStorageUriDetails.class, name="objectStorageUri")})
@JsonFilter(value="explicitlySetFilter")
public class ImageSourceDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="operatingSystem")
    private final String operatingSystem;
    @JsonProperty(value="operatingSystemVersion")
    private final String operatingSystemVersion;
    @JsonProperty(value="sourceImageType")
    private final SourceImageType sourceImageType;

    @Deprecated
    @ConstructorProperties(value={"operatingSystem", "operatingSystemVersion", "sourceImageType"})
    protected ImageSourceDetails(String operatingSystem, String operatingSystemVersion, SourceImageType sourceImageType) {
        this.operatingSystem = operatingSystem;
        this.operatingSystemVersion = operatingSystemVersion;
        this.sourceImageType = sourceImageType;
    }

    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public String getOperatingSystemVersion() {
        return this.operatingSystemVersion;
    }

    public SourceImageType getSourceImageType() {
        return this.sourceImageType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ImageSourceDetails(");
        sb.append("super=").append(super.toString());
        sb.append("operatingSystem=").append(String.valueOf(this.operatingSystem));
        sb.append(", operatingSystemVersion=").append(String.valueOf(this.operatingSystemVersion));
        sb.append(", sourceImageType=").append(String.valueOf((Object)this.sourceImageType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImageSourceDetails)) {
            return false;
        }
        ImageSourceDetails other = (ImageSourceDetails)((Object)o);
        return Objects.equals(this.operatingSystem, other.operatingSystem) && Objects.equals(this.operatingSystemVersion, other.operatingSystemVersion) && Objects.equals((Object)this.sourceImageType, (Object)other.sourceImageType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.operatingSystem == null ? 43 : this.operatingSystem.hashCode());
        result = result * 59 + (this.operatingSystemVersion == null ? 43 : this.operatingSystemVersion.hashCode());
        result = result * 59 + (this.sourceImageType == null ? 43 : this.sourceImageType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum SourceImageType implements BmcEnum
    {
        Qcow2("QCOW2"),
        Vmdk("VMDK");

        private final String value;
        private static Map<String, SourceImageType> map;

        private SourceImageType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SourceImageType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SourceImageType: " + key);
        }

        static {
            map = new HashMap<String, SourceImageType>();
            for (SourceImageType v : SourceImageType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

