/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.parser;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class TreeParser
extends DefaultHandler {
    private static final Logger LOGGER = Logger.getLogger("glassfish");
    private static final boolean isFinestLoggable = LOGGER.isLoggable(Level.FINEST);
    private static final boolean isFinerLoggable = LOGGER.isLoggable(Level.FINER);
    private final Node root;
    private Node rover;
    private String skipping;
    private int depth;
    private NodeReader childNodeReader;

    public static boolean readXml(File xmlFile, List<Path> pathList) throws IllegalStateException {
        boolean result = false;
        InputStreamReader reader = null;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(false);
            SAXParser saxParser = factory.newSAXParser();
            TreeParser handler = new TreeParser(pathList);
            reader = new FileReader(xmlFile);
            InputSource source = new InputSource(reader);
            saxParser.parse(source, (DefaultHandler)handler);
            result = true;
        }
        catch (ParserConfigurationException ex) {
            throw new IllegalStateException(ex);
        }
        catch (SAXException ex) {
            throw new IllegalStateException(ex);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.INFO, ex.getLocalizedMessage(), ex);
                }
            }
        }
        return result;
    }

    private TreeParser(List<Path> pathList) {
        this.root = TreeParser.buildTree(pathList);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.childNodeReader != null) {
            this.childNodeReader.readCData(this.skipping, ch, start, length);
        }
    }

    @Override
    public void startElement(String uri, String localname, String qname, Attributes attributes) throws SAXException {
        if (this.skipping != null) {
            ++this.depth;
            if (this.childNodeReader != null) {
                if (isFinerLoggable) {
                    LOGGER.log(Level.FINER, "Skip: reading {0}", qname);
                }
                this.childNodeReader.readChildren(qname, attributes);
            }
            if (isFinestLoggable) {
                LOGGER.log(Level.FINEST, "Skip: descend, depth is {0}, qn is {1}", new Object[]{this.depth, qname});
            }
        } else {
            Node child = this.rover.findChild(qname);
            if (child != null) {
                NodeReader reader;
                this.rover = child;
                if (isFinerLoggable) {
                    LOGGER.log(Level.FINER, "Rover descend to {0}", this.rover);
                }
                if ((reader = this.rover.getReader()) != null) {
                    if (isFinerLoggable) {
                        LOGGER.log(Level.FINER, "Rover enter & read node {0}", qname);
                    }
                    reader.readAttributes(qname, attributes);
                }
            } else {
                this.skipping = qname;
                this.depth = 1;
                this.childNodeReader = this.rover.getReader();
                if (this.childNodeReader != null) {
                    if (isFinerLoggable) {
                        LOGGER.log(Level.FINER, "Skip: reading {0}", qname);
                    }
                    this.childNodeReader.readChildren(qname, attributes);
                }
                if (isFinestLoggable) {
                    LOGGER.log(Level.FINEST, "Skip: start, depth is {0}, qn is {1}", new Object[]{this.depth, qname});
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String localname, String qname) throws SAXException {
        if (this.skipping != null) {
            if (--this.depth == 0) {
                if (!this.skipping.equals(qname)) {
                    LOGGER.log(Level.WARNING, "Skip: {0} does not match {1} at depth {2}", new Object[]{this.skipping, qname, this.depth});
                }
                if (isFinestLoggable) {
                    LOGGER.log(Level.FINEST, "Skip: ascend, depth is {0}", this.depth);
                }
                this.skipping = null;
                this.childNodeReader = null;
            } else if (isFinestLoggable) {
                LOGGER.log(Level.FINEST, "Skip: ascend, depth is {0}", this.depth);
            }
        } else {
            NodeReader reader = this.rover.getReader();
            if (reader != null) {
                if (isFinerLoggable) {
                    LOGGER.log(Level.FINER, "Rover exit & read node {0}", qname);
                }
                reader.endNode(qname);
            }
            this.rover = this.rover.getParent();
            if (isFinerLoggable) {
                LOGGER.log(Level.FINER, "Rover ascend to {0}", this.rover);
            }
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.rover = this.root;
        this.skipping = null;
        this.depth = 0;
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        LOGGER.log(Level.INFO, "Requested Entity: public id = {0}, system id = {1}", new Object[]{publicId, systemId});
        InputSource source = null;
        FileObject folder = FileUtil.getConfigFile((String)"DTDs/GlassFish");
        if (folder != null) {
            for (FileObject fo : folder.getChildren()) {
                Object attr = fo.getAttribute("publicId");
                if (attr instanceof String && attr.equals(publicId)) {
                    source = new InputSource(fo.getInputStream());
                    break;
                }
                attr = fo.getAttribute("systemId");
                if (!(attr instanceof String) || !attr.equals(systemId)) continue;
                source = new InputSource(fo.getInputStream());
                break;
            }
        }
        return source;
    }

    private static Node buildTree(List<Path> paths) {
        Node root = null;
        for (Path path : paths) {
            String[] parts = path.getPath().split("/");
            if (parts == null || parts.length == 0) {
                LOGGER.log(Level.WARNING, "Invalid entry, no parts, skipping: {0}", path);
                continue;
            }
            if (parts[0] == null) {
                LOGGER.log(Level.WARNING, "Invalid entry, null root, skipping: {0}", path);
                continue;
            }
            if (root == null) {
                if (isFinerLoggable) {
                    LOGGER.log(Level.FINER, "Root node created: {0}", parts[0]);
                }
                root = new Node(parts[0]);
            }
            Node rover = root;
            for (int i = 1; i < parts.length; ++i) {
                if (parts[i] != null && parts[i].length() > 0) {
                    Node existing = rover.findChild(parts[i]);
                    if (existing != null) {
                        if (isFinerLoggable) {
                            LOGGER.log(Level.FINER, "Existing node {0} at level {1}", new Object[]{parts[i], i});
                        }
                        rover = existing;
                        continue;
                    }
                    if (isFinerLoggable) {
                        LOGGER.log(Level.FINER, "Adding node {0} at level {1}", new Object[]{parts[i], i});
                    }
                    rover = rover.addChild(parts[i]);
                    continue;
                }
                LOGGER.log(Level.WARNING, "Broken parts found in {0} at level {1}", new Object[]{path, i});
            }
            if (rover == null) continue;
            rover.setReader(path.getReader());
        }
        return root;
    }

    private static class Node
    implements Comparable<Node> {
        private final String element;
        private final Map<String, Node> children;
        private Node parent;
        private NodeReader reader;

        public Node(String element) {
            this(element, null);
        }

        private Node(String element, Node parent) {
            this.element = element;
            this.children = new HashMap<String, Node>();
            this.parent = parent;
        }

        public Node addChild(String tag) {
            Node child = new Node(tag, this);
            this.children.put(tag, child);
            return child;
        }

        public Node findChild(String tag) {
            return this.children.get(tag);
        }

        public Node getParent() {
            return this.parent;
        }

        public NodeReader getReader() {
            return this.reader;
        }

        public void setReader(NodeReader reader) {
            this.reader = reader;
        }

        @Override
        public int compareTo(Node o) {
            return this.element.compareTo(o.element);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Node other = (Node)obj;
            return this.element == other.element || this.element != null && this.element.equals(other.element);
        }

        public int hashCode() {
            int hash = 3;
            hash = 41 * hash + (this.element != null ? this.element.hashCode() : 0);
            return hash;
        }

        public String toString() {
            boolean comma = false;
            StringBuilder buf = new StringBuilder(500);
            buf.append("{ ");
            if (this.element != null && this.element.length() > 0) {
                buf.append(this.element);
                comma = true;
            }
            if (this.parent == null) {
                if (comma) {
                    buf.append(", ");
                }
                buf.append("root");
                comma = true;
            }
            if (this.children.size() > 0) {
                if (comma) {
                    buf.append(", ");
                }
                buf.append(this.children.size());
                buf.append(" sub(s)");
            }
            buf.append(" }");
            return buf.toString();
        }
    }

    public static abstract class NodeReader {
        public void readAttributes(String qname, Attributes attributes) throws SAXException {
        }

        public void readChildren(String qname, Attributes attributes) throws SAXException {
        }

        public void readCData(String qname, char[] ch, int start, int length) throws SAXException {
        }

        public void endNode(String qname) throws SAXException {
        }
    }

    public static class Path {
        private final String path;
        private final NodeReader reader;

        public Path(String path) {
            this(path, null);
        }

        public Path(String path, NodeReader reader) {
            this.path = path;
            this.reader = reader;
        }

        public String getPath() {
            return this.path;
        }

        public NodeReader getReader() {
            return this.reader;
        }

        public String toString() {
            return this.path;
        }
    }
}

