/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.notifications.center;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.modules.notifications.NotificationImpl;
import org.netbeans.modules.notifications.center.NotificationTable;
import org.netbeans.modules.notifications.center.NotificationTableModel;
import org.netbeans.modules.notifications.filter.FilterRepository;
import org.netbeans.modules.notifications.filter.NotificationFilter;
import org.netbeans.modules.notifications.filter.TitleFilter;
import org.openide.awt.NotificationDisplayer;

public class NotificationCenterManager {
    public static final String PROP_NOTIFICATIONS_CHANGED = "notificationsChanged";
    public static final String PROP_NOTIFICATION_ADDED = "notificationAdded";
    public static final String PROP_NOTIFICATION_READ = "notificationRead";
    private static final int NOTIFICATIONS_CAPACITY = 100;
    private static final PropertyChangeSupport propSupport = new PropertyChangeSupport(NotificationCenterManager.class);
    private static NotificationCenterManager instance = null;
    private final List<NotificationImpl> notifications = new ArrayList<NotificationImpl>();
    private final List<NotificationImpl> filteredNotifications = new ArrayList<NotificationImpl>();
    private NotificationTable notificationTable;
    private final FilterRepository filterRepository = FilterRepository.getInstance();
    private NotificationFilter notificationFilter;
    private TitleFilter titleFilter;

    private NotificationCenterManager() {
        this.loadFilters();
    }

    public static NotificationCenterManager getInstance() {
        if (instance == null) {
            instance = new NotificationCenterManager();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(NotificationImpl notification) {
        boolean capacityFull = false;
        List<NotificationImpl> list = this.notifications;
        synchronized (list) {
            boolean bl = capacityFull = this.notifications.size() == 100;
            if (capacityFull) {
                this.notifications.remove(0).clear();
            }
            this.notifications.add(notification);
        }
        if (this.isEnabled(notification)) {
            this.filteredNotifications.add(notification);
            this.firePropertyChange(PROP_NOTIFICATION_ADDED, notification);
        }
        this.updateTable(capacityFull);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(NotificationImpl notification) {
        List<NotificationImpl> list = this.notifications;
        synchronized (list) {
            if (!this.notifications.remove(notification)) {
                return;
            }
        }
        if (this.isEnabled(notification)) {
            this.filteredNotifications.remove(notification);
            if (!notification.isRead()) {
                this.firePropertyChange(PROP_NOTIFICATION_READ, notification);
            }
        }
        this.updateTable(false);
    }

    public void updateTable(boolean filter) {
        if (filter) {
            this.filterNotifications();
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                NotificationTableModel model = NotificationCenterManager.this.getModel();
                List list = NotificationCenterManager.this.notifications;
                synchronized (list) {
                    model.setEntries(NotificationCenterManager.this.filteredNotifications);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(NotificationImpl n) {
        int index;
        List<NotificationImpl> list = this.notifications;
        synchronized (list) {
            index = this.filteredNotifications.indexOf(n);
        }
        if (index != -1) {
            SwingUtilities.invokeLater(new Runnable(){
                final /* synthetic */ NotificationCenterManager this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    NotificationTableModel model = this.this$0.getModel();
                    model.updateIndex(index);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll() {
        List<NotificationImpl> list = this.notifications;
        synchronized (list) {
            this.notifications.clear();
            this.filteredNotifications.clear();
            this.firePropertyChange(PROP_NOTIFICATIONS_CHANGED, null);
            this.updateTable(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markAllRead() {
        List<NotificationImpl> list = this.notifications;
        synchronized (list) {
            for (NotificationImpl n : this.notifications) {
                n.markAsRead(true);
            }
        }
    }

    public List<NotificationDisplayer.Category> getCategories() {
        return NotificationDisplayer.Category.getCategories();
    }

    public void wasRead(NotificationImpl notification) {
        this.firePropertyChange(PROP_NOTIFICATION_READ, notification);
        this.update(notification);
    }

    public NotificationFilter getActiveFilter() {
        return this.notificationFilter;
    }

    public JComponent getComponent() {
        return this.getTable();
    }

    private NotificationTableModel getModel() {
        return (NotificationTableModel)this.getTable().getModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUnreadCount() {
        int count = 0;
        List<NotificationImpl> list = this.notifications;
        synchronized (list) {
            for (NotificationImpl notification : this.notifications) {
                if (notification.isRead()) continue;
                ++count;
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NotificationImpl getLastUnreadNotification() {
        List<NotificationImpl> list = this.notifications;
        synchronized (list) {
            for (int i = this.filteredNotifications.size() - 1; i >= 0; --i) {
                NotificationImpl n = this.filteredNotifications.get(i);
                if (n.isRead()) continue;
                return n;
            }
        }
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        propSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        propSupport.removePropertyChangeListener(l);
    }

    private void firePropertyChange(final String propName, final NotificationImpl notification) {
        Runnable r = new Runnable(){
            final /* synthetic */ NotificationCenterManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                if (NotificationCenterManager.PROP_NOTIFICATION_ADDED.equals(propName)) {
                    notification.initDecorations();
                }
                propSupport.firePropertyChange(propName, null, notification);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    static void tcClosed() {
        try {
            FilterRepository.getInstance().save();
        }
        catch (IOException ioE) {
            NotificationCenterManager.getLogger().log(Level.INFO, null, ioE);
        }
    }

    static Logger getLogger() {
        return Logger.getLogger(NotificationCenterManager.class.getName());
    }

    public boolean isEnabled(NotificationImpl notification) {
        boolean categoryEnabled = this.notificationFilter == null || this.notificationFilter != null && this.notificationFilter.isEnabled(notification);
        boolean titleEnabled = true;
        if (categoryEnabled) {
            titleEnabled = this.titleFilter == null ? true : this.titleFilter.isEnabled(notification.getTitle());
        }
        return categoryEnabled && titleEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filterNotifications() {
        this.notificationFilter = this.filterRepository.getActive();
        List<NotificationImpl> list = this.notifications;
        synchronized (list) {
            this.filteredNotifications.clear();
            for (NotificationImpl notification : this.notifications) {
                if (!this.isEnabled(notification)) continue;
                this.filteredNotifications.add(notification);
            }
        }
        this.firePropertyChange(PROP_NOTIFICATIONS_CHANGED, null);
    }

    void setMessageFilter(String searchText) {
        this.titleFilter = searchText == null || searchText.isEmpty() ? null : new TitleFilter(searchText);
        this.updateTable(true);
    }

    boolean isQuickFilter() {
        return this.titleFilter != null;
    }

    private void loadFilters() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    NotificationCenterManager.this.filterRepository.load();
                }
                catch (IOException ioE) {
                    NotificationCenterManager.getLogger().log(Level.INFO, ioE.getMessage(), ioE);
                }
                if (NotificationCenterManager.this.notificationTable != null) {
                    NotificationCenterManager.this.updateTable(true);
                } else {
                    NotificationCenterManager.this.notificationFilter = NotificationCenterManager.this.filterRepository.getActive();
                }
            }
        }).start();
    }

    private NotificationTable getTable() {
        if (this.notificationTable == null) {
            this.notificationTable = new NotificationTable();
        }
        return this.notificationTable;
    }

    void setActiveFilter(NotificationFilter notificationFilter) {
        this.notificationFilter = notificationFilter;
        this.filterNotifications();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getTotalCount() {
        int count = 0;
        List<NotificationImpl> list = this.notifications;
        synchronized (list) {
            count = this.notifications.size();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getFilteredCount() {
        int count = 0;
        List<NotificationImpl> list = this.notifications;
        synchronized (list) {
            count = this.filteredNotifications.size();
        }
        return count;
    }

    List<NotificationImpl> getFilteredNotifications() {
        return this.filteredNotifications;
    }
}

