/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.notifications.center;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import org.netbeans.modules.notifications.center.MenuToggleButton;
import org.netbeans.modules.notifications.center.NotificationCenterManager;
import org.netbeans.modules.notifications.filter.FilterEditor;
import org.netbeans.modules.notifications.filter.FilterRepository;
import org.netbeans.modules.notifications.filter.NotificationFilter;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class FiltersMenuButton
extends MenuToggleButton {
    private final NotificationCenterManager notificationManager = NotificationCenterManager.getInstance();

    public FiltersMenuButton(NotificationFilter currentFilter) {
        super(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/notifications/resources/filter.png", (boolean)false), (Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/notifications/resources/filter_rollover.png", (boolean)false), 4);
        this.updateState(currentFilter, false);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!FiltersMenuButton.this.isSelected()) {
                    FiltersMenuButton.this.updateState(NotificationFilter.EMPTY, false);
                } else {
                    FiltersMenuButton.this.updateState(FiltersMenuButton.openFilterEditor(), false);
                }
            }
        });
    }

    @Override
    protected JPopupMenu getPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        this.fillMenu(popup, null);
        return popup;
    }

    void fillMenu(JPopupMenu popup, JMenu menu) {
        assert (null != popup || null != menu);
        FilterRepository filterRep = FilterRepository.getInstance();
        NotificationFilter activeFilter = this.notificationManager.getActiveFilter();
        JRadioButtonMenuItem item = new JRadioButtonMenuItem(new CancelFilterAction());
        item.setSelected(NotificationFilter.EMPTY.equals(activeFilter));
        if (null == popup) {
            menu.add(item);
        } else {
            popup.add(item);
        }
        if (null == popup) {
            menu.addSeparator();
        } else {
            popup.addSeparator();
        }
        List<NotificationFilter> allFilters = filterRep.getAllFilters();
        for (NotificationFilter tf : allFilters) {
            item = new JRadioButtonMenuItem(new SetFilterAction(tf));
            item.setSelected(activeFilter.equals(tf));
            if (null == popup) {
                menu.add(item);
                continue;
            }
            popup.add(item);
        }
        if (allFilters.size() > 0) {
            if (null == popup) {
                menu.addSeparator();
            } else {
                popup.addSeparator();
            }
        }
        if (null == popup) {
            menu.add(new ManageFiltersAction());
        } else {
            popup.add(new ManageFiltersAction());
        }
    }

    private void updateState(NotificationFilter filter, boolean saveFilters) {
        if (null == filter || NotificationFilter.EMPTY.equals(filter)) {
            this.setSelected(false);
            this.setToolTipText(NbBundle.getMessage(FiltersMenuButton.class, (String)"HINT_SelectFilter"));
        } else {
            this.setSelected(true);
            this.setToolTipText(filter.getName());
        }
        FilterRepository.getInstance().setActive(filter);
        this.notificationManager.updateTable(true);
        if (saveFilters) {
            try {
                FilterRepository.getInstance().save();
            }
            catch (IOException ioE) {
                NotificationCenterManager.getLogger().log(Level.INFO, ioE.getMessage(), ioE);
            }
        }
    }

    private static NotificationFilter openFilterEditor() {
        FilterRepository filterRep = FilterRepository.getInstance();
        FilterRepository clone = (FilterRepository)filterRep.clone();
        FilterEditor fe = new FilterEditor(clone);
        if (fe.showWindow()) {
            filterRep.assign(clone);
            try {
                filterRep.save();
            }
            catch (IOException ioE) {
                NotificationCenterManager.getLogger().log(Level.INFO, ioE.getMessage(), ioE);
            }
        }
        return filterRep.getActive();
    }

    private class CancelFilterAction
    extends AbstractAction {
        public CancelFilterAction() {
            super(NbBundle.getMessage(FiltersMenuButton.class, (String)"LBL_CancelFilter"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FiltersMenuButton.this.updateState(NotificationFilter.EMPTY, true);
        }
    }

    private class SetFilterAction
    extends AbstractAction {
        private final NotificationFilter filter;

        public SetFilterAction(NotificationFilter filter) {
            super(filter.getName());
            this.filter = filter;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FiltersMenuButton.this.updateState(this.filter, true);
        }
    }

    private class ManageFiltersAction
    extends AbstractAction {
        public ManageFiltersAction() {
            super(NbBundle.getMessage(FiltersMenuButton.class, (String)"LBL_EditFilters"));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            FiltersMenuButton.this.updateState(FiltersMenuButton.openFilterEditor(), false);
        }
    }
}

