/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.updater;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.netbeans.updater.ModuleDeactivator;
import org.netbeans.updater.ModuleUpdater;
import org.netbeans.updater.UpdateTracking;
import org.netbeans.updater.UpdatingContext;
import org.netbeans.updater.XMLUtil;

public final class UpdaterDispatcher
implements Runnable {
    private Boolean disable = null;
    private Boolean enable = null;
    private Boolean install = null;
    private Boolean uninstall = null;
    public static final String UPDATE_DIR = "update";
    public static final String DEACTIVATE_DIR = "deactivate";
    public static final String NEW_UPDATER_DIR = "new_updater";
    public static final String DEACTIVATE_LATER = "deactivate_later.txt";
    public static final String LAST_MODIFIED = ".lastModified";
    private final UpdatingContext context;

    UpdaterDispatcher(UpdatingContext context) {
        this.context = context;
    }

    private void dispatch() {
        assert (!SwingUtilities.isEventDispatchThread()) : "Cannot run in EQ";
        try {
            if (this.isUninstallScheduled()) {
                new ModuleDeactivator(this.context).delete();
            }
            if (this.isDisableScheduled()) {
                new ModuleDeactivator(this.context).enableDisable(false);
            }
            if (this.isEnableScheduled()) {
                new ModuleDeactivator(this.context).enableDisable(true);
            }
            if (this.isInstallScheduled()) {
                try {
                    ModuleUpdater mu = new ModuleUpdater(this.context);
                    mu.start();
                    mu.join();
                }
                catch (InterruptedException ex) {
                    XMLUtil.LOG.log(Level.SEVERE, "Error", ex);
                }
            }
        }
        catch (Exception x) {
            XMLUtil.LOG.log(Level.WARNING, "Handling delete throws", x);
        }
        finally {
            this.context.unpackingFinished();
        }
    }

    private boolean isDisableScheduled() {
        if (this.disable == null) {
            this.exploreUpdateDir();
        }
        return this.disable;
    }

    private boolean isEnableScheduled() {
        if (this.enable == null) {
            this.exploreUpdateDir();
        }
        return this.enable;
    }

    private boolean isUninstallScheduled() {
        if (this.uninstall == null) {
            this.exploreUpdateDir();
        }
        return this.uninstall;
    }

    private boolean isInstallScheduled() {
        if (this.install == null) {
            this.exploreUpdateDir();
        }
        return this.install;
    }

    private void exploreUpdateDir() {
        this.install = false;
        this.uninstall = false;
        this.disable = false;
        this.enable = false;
        for (File cluster : UpdateTracking.clusters(true)) {
            File updateDir = new File(cluster, UPDATE_DIR);
            if (!updateDir.exists() || !updateDir.isDirectory()) continue;
            if (this.install == null || !this.install.booleanValue()) {
                this.install = !ModuleUpdater.getModulesToInstall(cluster).isEmpty();
            }
            if (this.uninstall == null || !this.uninstall.booleanValue()) {
                this.uninstall = ModuleDeactivator.hasModulesForDelete(updateDir);
            }
            if (this.disable == null || !this.disable.booleanValue()) {
                this.disable = ModuleDeactivator.hasModulesForDisable(updateDir);
            }
            if (this.enable != null && this.enable.booleanValue()) continue;
            this.enable = ModuleDeactivator.hasModulesForEnable(updateDir);
        }
    }

    @Override
    public void run() {
        this.dispatch();
        this.context.disposeSplash();
    }

    public static void touchLastModified(File cluster) {
        if (!cluster.exists()) {
            return;
        }
        try {
            File stamp = new File(cluster, LAST_MODIFIED);
            if (!stamp.exists() && !stamp.createNewFile()) {
                throw new IOException("Can`t create stamp file " + stamp);
            }
            if (!stamp.setLastModified(System.currentTimeMillis())) {
                stamp.delete();
                stamp.createNewFile();
                stamp.setLastModified(System.currentTimeMillis());
            }
        }
        catch (IOException ex) {
            XMLUtil.LOG.log(Level.WARNING, null, ex);
        }
    }
}

