/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.hints;

import java.io.IOException;
import java.util.Collections;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.javascript2.editor.JsPreferences;
import org.netbeans.modules.javascript2.editor.JsVersion;
import org.netbeans.modules.javascript2.editor.hints.JsAstRule;
import org.netbeans.modules.javascript2.editor.hints.JsHintsProvider;
import org.netbeans.modules.parsing.api.indexing.IndexingManager;
import org.netbeans.spi.lexer.MutableTextInput;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public abstract class EcmaLevelRule
extends JsAstRule {
    private static final RequestProcessor RP = new RequestProcessor(EcmaLevelRule.class);

    public static void refresh(FileObject fo) throws IOException {
        EcmaLevelRule.reindexFile(fo);
        EcmaLevelRule.refreshDocument(fo);
    }

    static boolean ecmaEditionProjectBelow(JsHintsProvider.JsRuleContext context, JsVersion targetVersion) {
        return JsPreferences.isPreECMAVersion(FileOwnerQuery.getOwner((FileObject)context.getJsParserResult().getSnapshot().getSource().getFileObject()), targetVersion);
    }

    private static void reindexFile(FileObject fo) {
        RP.post(() -> IndexingManager.getDefault().refreshIndexAndWait(fo.getParent().toURL(), Collections.singleton(fo.toURL()), true, false));
    }

    private static void refreshDocument(FileObject fo) throws IOException {
        RP.post(() -> {
            try {
                DataObject dobj = DataObject.find((FileObject)fo);
                EditorCookie editorCookie = (EditorCookie)dobj.getLookup().lookup(EditorCookie.class);
                StyledDocument document = editorCookie.openDocument();
                EcmaLevelRule.forceReparse(document);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        });
    }

    private static void forceReparse(Document doc) {
        SwingUtilities.invokeLater(() -> {
            NbEditorDocument nbdoc = (NbEditorDocument)doc;
            nbdoc.runAtomic(() -> {
                MutableTextInput mti = (MutableTextInput)doc.getProperty(MutableTextInput.class);
                if (mti != null) {
                    mti.tokenHierarchyControl().rebuild();
                }
            });
        });
    }
}

