/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.support;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.concurrent.Callable;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.jshell.support.PersistentSnippets;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.WeakListeners;

public class SnippetsFolder
implements PersistentSnippets {
    private FileObject parentFolder;
    private ChangeSupport supp = new ChangeSupport((Object)this);
    private FileChangeListener fcl;
    private FileChangeListener weakFCL;
    private boolean attached;
    private FileObject root;
    private Callable<FileObject> storageCreator;
    private static final String PATH_SNIPPETS = "jshell-snippets";

    public SnippetsFolder(FileObject parentFolder) {
        this.parentFolder = parentFolder;
    }

    public SnippetsFolder(FileObject parentFolder, Callable<FileObject> creator) {
        this.parentFolder = parentFolder;
        this.storageCreator = creator;
    }

    @Override
    public boolean isValid() {
        return this.parentFolder.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void attach(FileObject basedir) {
        SnippetsFolder snippetsFolder = this;
        synchronized (snippetsFolder) {
            if (this.attached) {
                return;
            }
            this.attached = true;
        }
        this.root = basedir;
        this.fcl = new FileChangeAdapter(){

            public void fileDataCreated(FileEvent fe) {
                if (fe.getFile().getParent() == SnippetsFolder.this.root) {
                    SnippetsFolder.this.fireChange();
                }
            }

            public void fileFolderCreated(FileEvent fe) {
                if (fe.getFile() == null) {
                    return;
                }
                if (fe.getFile().getParent() == SnippetsFolder.this.root) {
                    SnippetsFolder.this.fireChange();
                    return;
                }
            }

            public void fileRenamed(FileRenameEvent fe) {
                if (fe.getFile().getParent() == SnippetsFolder.this.root) {
                    SnippetsFolder.this.fireChange();
                }
            }

            public void fileDeleted(FileEvent fe) {
                if (fe.getFile().getParent() == SnippetsFolder.this.root) {
                    SnippetsFolder.this.fireChange();
                }
            }

            public void fileChanged(FileEvent fe) {
                if (fe.getFile().getParent() == SnippetsFolder.this.root || fe.getFile() == SnippetsFolder.this.root) {
                    SnippetsFolder.this.fireChange();
                }
            }
        };
        this.weakFCL = (FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)this.fcl, (Object)basedir);
        basedir.addFileChangeListener(this.weakFCL);
    }

    private void fireChange() {
        this.supp.fireChange();
    }

    @Override
    public Collection<FileObject> getSavedClasses(String folder) {
        this.attach(this.parentFolder);
        FileObject dir = this.savedClassFolder(null);
        if (dir == null) {
            return Collections.emptyList();
        }
        if (folder != null) {
            dir = dir.getFileObject(folder);
        }
        return dir == null ? Collections.emptyList() : Arrays.asList(dir.getChildren());
    }

    @Override
    public FileObject savedClassFolder(String name) {
        this.attach(this.parentFolder);
        FileObject dir = this.root;
        return dir;
    }

    @Override
    public FileObject saveClass(String name, String description, InputStream contents) throws IOException {
        if (this.storageCreator != null) {
            try {
                this.storageCreator.call();
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
        }
        FileObject pdir = this.root;
        FileObject target = FileUtil.createFolder((FileObject)pdir, (String)PATH_SNIPPETS);
        try (OutputStream ostm = target.createAndOpen(name + ".java");){
            FileUtil.copy((InputStream)contents, (OutputStream)ostm);
        }
        FileObject snipFile = target.getFileObject(name + ".java");
        return snipFile;
    }

    @Override
    public String getDescription(FileObject saved) {
        return null;
    }

    @Override
    public void setDescription(FileObject saved, String desc) {
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.supp.addChangeListener(l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.supp.removeChangeListener(l);
    }

    @Override
    public Collection<FileObject> startupSnippets(String runAction) {
        return this.getSavedClasses("startup");
    }
}

