/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetMfaTotpDeviceRequest
extends BmcRequest<Void> {
    private String userId;
    private String mfaTotpDeviceId;

    public String getUserId() {
        return this.userId;
    }

    public String getMfaTotpDeviceId() {
        return this.mfaTotpDeviceId;
    }

    public Builder toBuilder() {
        return new Builder().userId(this.userId).mfaTotpDeviceId(this.mfaTotpDeviceId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",userId=").append(String.valueOf(this.userId));
        sb.append(",mfaTotpDeviceId=").append(String.valueOf(this.mfaTotpDeviceId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetMfaTotpDeviceRequest)) {
            return false;
        }
        GetMfaTotpDeviceRequest other = (GetMfaTotpDeviceRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.userId, other.userId) && Objects.equals(this.mfaTotpDeviceId, other.mfaTotpDeviceId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.userId == null ? 43 : this.userId.hashCode());
        result = result * 59 + (this.mfaTotpDeviceId == null ? 43 : this.mfaTotpDeviceId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetMfaTotpDeviceRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String userId = null;
        private String mfaTotpDeviceId = null;

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder mfaTotpDeviceId(String mfaTotpDeviceId) {
            this.mfaTotpDeviceId = mfaTotpDeviceId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetMfaTotpDeviceRequest o) {
            this.userId(o.getUserId());
            this.mfaTotpDeviceId(o.getMfaTotpDeviceId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetMfaTotpDeviceRequest build() {
            GetMfaTotpDeviceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetMfaTotpDeviceRequest buildWithoutInvocationCallback() {
            GetMfaTotpDeviceRequest request = new GetMfaTotpDeviceRequest();
            request.userId = this.userId;
            request.mfaTotpDeviceId = this.mfaTotpDeviceId;
            return request;
        }
    }
}

