/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.JavaCodeGenerator;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADConnectionPropertyEditor;
import org.netbeans.modules.form.RADVisualComponent;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class RenameSupport {
    private static final String[] FORM_ELEMENTS_ATTRS = new String[]{"<Component ", " class=\"", "<AuxValue name=\"JavaCodeGenerator_", " value=\"", "<Property ", " preCode=\"", "<Property ", " postCode=\"", "<Connection ", " code=\""};

    static void renameComponent(RADComponent component, String newName) {
        int varType = component.getCodeExpression().getVariable().getType();
        if ((varType & 0x3000) == 4096) {
            RenameSupport.renameComponentInClass(component, newName, false);
        } else if ((varType & 7) == 2) {
            RenameSupport.renameComponentInClass(component, newName, true);
        } else {
            Refactoring r = (Refactoring)Lookup.getDefault().lookup(Refactoring.class);
            if (r != null) {
                r.renameComponent(component.getFormModel(), component.getName(), newName);
            } else {
                RenameSupport.renameComponentInClass(component, newName, true);
            }
        }
    }

    private static void renameComponentInClass(RADComponent component, String newName, boolean outOfGenerated) {
        RenameSupport.renameComponentInCustomCode(component, newName);
        if (outOfGenerated) {
            FormEditor.getFormJavaSource(component.getFormModel()).renameField(component.getName(), newName);
        }
        component.setName(newName);
    }

    static void renameComponentInCustomCode(RADComponent metacomp, String newName) {
        String oldName = metacomp.getName();
        for (RADComponent comp : metacomp.getFormModel().getAllComponents()) {
            RenameSupport.renameInCustomCode(comp.getKnownBeanProperties(), oldName, newName);
            RenameSupport.renameInCustomCode(comp.getKnownAccessibilityProperties(), oldName, newName);
            if (comp instanceof RADVisualComponent) {
                RenameSupport.renameInCustomCode(((RADVisualComponent)comp).getConstraintsProperties(), oldName, newName);
            }
            RenameSupport.renameInCustomCode(comp.getSyntheticProperties(), oldName, newName);
        }
    }

    private static void renameInCustomCode(Node.Property[] properties, String oldName, String newName) {
        if (properties == null) {
            return;
        }
        for (Node.Property prop : properties) {
            if (!(prop instanceof FormProperty)) continue;
            FormProperty formProp = (FormProperty)prop;
            String newCode = RenameSupport.replaceCode(formProp.getPreCode(), oldName, newName);
            if (newCode != null) {
                formProp.setPreCode(newCode);
            }
            if ((newCode = RenameSupport.replaceCode(formProp.getPostCode(), oldName, newName)) != null) {
                formProp.setPostCode(newCode);
            }
            if (!formProp.isChanged()) continue;
            try {
                Object value = formProp.getValue();
                if (value instanceof RADConnectionPropertyEditor.RADConnectionDesignValue) {
                    RADConnectionPropertyEditor.RADConnectionDesignValue rr = (RADConnectionPropertyEditor.RADConnectionDesignValue)value;
                    if (rr.getType() != 2 || (newCode = RenameSupport.replaceCode(rr.getCode(), oldName, newName)) == null) continue;
                    value = new RADConnectionPropertyEditor.RADConnectionDesignValue(newCode);
                    formProp.setValue(value);
                    continue;
                }
                if (!(value instanceof String) || !(formProp instanceof JavaCodeGenerator.CodeProperty) || (newCode = RenameSupport.replaceCode((String)value, oldName, newName)) == null) continue;
                formProp.setValue(newCode);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static String replaceCode(String code, String oldName, String newName) {
        if (code != null && code.contains(oldName)) {
            NameReplacer rep = new NameReplacer(new String[]{oldName}, new String[]{newName}, code.length() + 10);
            rep.append(code);
            String newCode = rep.getResult();
            if (!code.equals(newCode)) {
                return newCode;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String renameInFormFile(FileObject formFile, String[] oldNames, String[] newNames, boolean pkgName) throws IOException {
        String[] newStr;
        String[] oldStr;
        boolean shortName = false;
        if (pkgName) {
            oldStr = new String[oldNames.length * 3];
            newStr = new String[newNames.length * 3];
            for (int i = 0; i < oldNames.length; ++i) {
                String oldName = oldNames[i] + ".";
                String newName = newNames[i] + ".";
                String oldResName = oldName.replace('.', '/');
                String newResName = newName.replace('.', '/');
                int idx = i * 3;
                oldStr[idx] = oldName;
                oldStr[idx + 1] = oldResName;
                oldStr[idx + 2] = "/" + oldResName;
                newStr[idx] = newName;
                newStr[idx + 1] = newResName;
                newStr[idx + 2] = "/" + newResName;
            }
        } else {
            for (String s : oldNames) {
                if (s.contains(".")) continue;
                shortName = true;
                break;
            }
            oldStr = oldNames;
            newStr = newNames;
        }
        try (InputStream is = null;){
            String outString;
            is = formFile.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            if (!shortName) {
                NameReplacer rep = new NameReplacer(oldStr, newStr, (int)formFile.getSize());
                String line = reader.readLine();
                while (line != null) {
                    rep.append(line);
                    line = reader.readLine();
                    if (line == null) continue;
                    rep.append("\n");
                }
                outString = rep.getResult();
                if (!rep.anythingChanged()) {
                    String idx = null;
                    return idx;
                }
            } else {
                StringBuilder buf = new StringBuilder((int)formFile.getSize());
                boolean anyChange = false;
                String line = reader.readLine();
                while (line != null) {
                    String trimLine = line.trim();
                    for (int i = 0; i < FORM_ELEMENTS_ATTRS.length; i += 2) {
                        int idx2;
                        int idx1;
                        String attr;
                        int idx;
                        if (!trimLine.startsWith(FORM_ELEMENTS_ATTRS[i]) || (idx = line.indexOf(attr = FORM_ELEMENTS_ATTRS[i + 1])) <= 0) continue;
                        if (!attr.endsWith("\"")) {
                            for (idx1 = idx + attr.length(); idx1 < line.length() && line.charAt(idx1) != '\"'; ++idx1) {
                            }
                        }
                        for (idx2 = ++idx1; idx2 < line.length() && line.charAt(idx2) != '\"'; ++idx2) {
                        }
                        if (idx1 >= line.length() || idx2 >= line.length()) continue;
                        String sub = line.substring(idx1, idx2);
                        boolean containsOldName = false;
                        for (String s : oldStr) {
                            if (!sub.contains(s)) continue;
                            containsOldName = true;
                            break;
                        }
                        if (!containsOldName) continue;
                        NameReplacer rep = new NameReplacer(oldStr, newStr, sub.length());
                        rep.append(sub);
                        sub = rep.getResult();
                        if (!rep.anythingChanged()) continue;
                        line = line.substring(0, idx1) + sub + line.substring(idx2);
                        anyChange = true;
                    }
                    buf.append(line);
                    line = reader.readLine();
                    if (line == null) continue;
                    buf.append("\n");
                }
                if (!anyChange) {
                    String string = null;
                    return string;
                }
                outString = buf.toString();
            }
            String string = outString;
            return string;
        }
    }

    public static interface Refactoring {
        public void renameComponent(FormModel var1, String var2, String var3);
    }

    private static class NameReplacer {
        private String[] toReplace;
        private String[] replaceWith;
        private int[] matchCounts;
        private StringBuilder buffer;
        private StringBuilder pendingChars;
        private char lastChar;
        private boolean anyChange;
        private boolean ended;

        public NameReplacer(String[] toReplace, String[] replaceWith, int len) {
            this.toReplace = toReplace;
            for (String s : toReplace) {
                assert (s != null && s.length() > 0);
            }
            for (String s : replaceWith) {
                assert (s != null && s.length() > 0);
            }
            this.replaceWith = replaceWith;
            this.pendingChars = new StringBuilder(50);
            this.buffer = new StringBuilder(len);
            this.matchCounts = new int[toReplace.length];
        }

        public void append(String str) {
            assert (!this.ended);
            for (int i = 0; i < str.length(); ++i) {
                this.append(str.charAt(i));
            }
        }

        public String getResult() {
            for (int i = 0; i < this.toReplace.length; ++i) {
                int count = this.matchCounts[i];
                String template = this.toReplace[i];
                if (count != template.length()) continue;
                this.replace(i);
                break;
            }
            this.writePendingChars();
            this.ended = true;
            return this.buffer.toString();
        }

        public boolean anythingChanged() {
            return this.anyChange;
        }

        private void append(char c) {
            int completeMatch = -1;
            boolean charMatch = false;
            for (int i = 0; i < this.toReplace.length; ++i) {
                int count = this.matchCounts[i];
                String template = this.toReplace[i];
                if (count == template.length()) {
                    if (this.canEndHere(c)) {
                        completeMatch = i;
                        break;
                    }
                    this.matchCounts[i] = 0;
                    continue;
                }
                if (template.charAt(count) == c) {
                    if (count <= 0 && !this.canStartHere()) continue;
                    this.matchCounts[i] = count + 1;
                    charMatch = true;
                    continue;
                }
                this.matchCounts[i] = 0;
            }
            if (completeMatch >= 0) {
                this.replace(completeMatch);
                this.buffer.append(c);
            } else if (charMatch) {
                this.pendingChars.append(c);
            } else {
                this.writePendingChars();
                this.buffer.append(c);
            }
            this.lastChar = c;
        }

        private boolean canStartHere() {
            return this.lastChar != '.' && this.lastChar != '/' && (this.lastChar <= ' ' || !Character.isJavaIdentifierPart(this.lastChar));
        }

        private boolean canEndHere(char next) {
            return this.lastChar == '.' || this.lastChar == '/' || !Character.isJavaIdentifierPart(next);
        }

        private void replace(int completeMatch) {
            int preCount = this.pendingChars.length() - this.matchCounts[completeMatch];
            if (preCount > 0) {
                this.buffer.append(this.pendingChars.substring(0, preCount));
            }
            this.buffer.append(this.replaceWith[completeMatch]);
            for (int i = 0; i < this.matchCounts.length; ++i) {
                this.matchCounts[i] = 0;
            }
            this.pendingChars.delete(0, this.pendingChars.length());
            this.anyChange = true;
        }

        private void writePendingChars() {
            if (this.pendingChars.length() > 0) {
                this.buffer.append(this.pendingChars.toString());
                this.pendingChars.delete(0, this.pendingChars.length());
            }
        }
    }
}

