/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.shelve;

import java.awt.EventQueue;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.progress.FileListener;
import org.netbeans.libs.git.progress.NotificationListener;
import org.netbeans.modules.git.FileInformation;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.GitModuleConfig;
import org.netbeans.modules.git.client.GitClient;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.actions.GitAction;
import org.netbeans.modules.git.ui.actions.SingleRepositoryAction;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.ui.shelve.Bundle;
import org.netbeans.modules.git.ui.stash.SaveStashAction;
import org.netbeans.modules.git.ui.stash.Stash;
import org.netbeans.modules.git.utils.GitUtils;
import org.netbeans.modules.versioning.shelve.ShelveChangesActionsRegistry;
import org.netbeans.modules.versioning.shelve.ShelveChangesSupport;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.awt.Actions;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;
import org.openide.windows.WindowManager;

public class ShelveChangesAction
extends SingleRepositoryAction {
    private static ShelveChangesActionsRegistry.ShelveChangesActionProvider ACTION_PROVIDER;
    private static final String ICON_RESOURCE = "org/netbeans/modules/git/resources/icons/diff.png";

    public ShelveChangesAction() {
        super(ICON_RESOURCE);
    }

    protected String iconResource() {
        return ICON_RESOURCE;
    }

    @Override
    protected void performAction(File repository, File[] roots, VCSContext context) {
        this.shelve(repository, roots);
    }

    public void shelve(File repository, File[] roots) {
        if (Git.getInstance().getFileStatusCache().listFiles(roots, FileInformation.STATUS_MODIFIED_HEAD_VS_WORKING).length == 0) {
            EventQueue.invokeLater(() -> JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), Bundle.MSG_ShelveAction_noModifications_text(), Bundle.LBL_ShelveAction_noModifications_title(), 1));
            return;
        }
        GitShelveChangesSupport supp = new GitShelveChangesSupport(repository);
        if (supp.open()) {
            RequestProcessor rp = Git.getInstance().getRequestProcessor(repository);
            supp.startAsync(rp, repository, roots);
        }
    }

    public static ShelveChangesActionsRegistry.ShelveChangesActionProvider getProvider() {
        if (ACTION_PROVIDER == null) {
            ACTION_PROVIDER = new ShelveChangesActionsRegistry.ShelveChangesActionProvider(){

                public Action getAction() {
                    SystemAction a = SystemAction.get(SaveStashAction.class);
                    Utils.setAcceleratorBindings((String)"Actions/Git", (Action[])new Action[]{a});
                    return a;
                }

                public JComponent[] getUnshelveActions(VCSContext ctx, boolean popup) {
                    JComponent[] cont = UnstashMenu.getInstance().getMenu(ctx, popup);
                    if (cont == null) {
                        cont = super.getUnshelveActions(ctx, popup);
                    }
                    return cont;
                }
            };
        }
        return ACTION_PROVIDER;
    }

    private static class GitShelveChangesSupport
    extends ShelveChangesSupport {
        private ShelveChangesProgressSupport support;
        private File[] modifications;
        private final File repository;
        private final JPanel optionsPanel;
        private final JCheckBox revertModificationInIndex;
        private final JCheckBox doPurgeChxBox;
        private boolean doRevertIndex;
        private boolean doPurge;

        public GitShelveChangesSupport(File repository) {
            this.repository = repository;
            this.revertModificationInIndex = new JCheckBox();
            Mnemonics.setLocalizedText((AbstractButton)this.revertModificationInIndex, (String)Bundle.ShelvePanel_doRevertIndexChanges_text());
            this.revertModificationInIndex.setToolTipText(Bundle.ShelvePanel_doRevertIndexChanges_desc());
            this.revertModificationInIndex.getAccessibleContext().setAccessibleDescription(this.revertModificationInIndex.getToolTipText());
            this.revertModificationInIndex.setSelected(true);
            this.doPurgeChxBox = new JCheckBox();
            Mnemonics.setLocalizedText((AbstractButton)this.doPurgeChxBox, (String)Bundle.ShelvePanel_doPurgeChxBox_text());
            this.doPurgeChxBox.setToolTipText(Bundle.ShelvePanel_doPurgeChxBox_desc());
            this.doPurgeChxBox.getAccessibleContext().setAccessibleDescription(this.doPurgeChxBox.getToolTipText());
            this.doPurgeChxBox.setSelected(GitModuleConfig.getDefault().getRemoveWTNew());
            this.optionsPanel = new JPanel();
            this.optionsPanel.setLayout(new BoxLayout(this.optionsPanel, 1));
            this.optionsPanel.add(this.revertModificationInIndex);
            this.optionsPanel.add(this.doPurgeChxBox);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void exportPatch(File toFile, File commonParent) throws IOException {
            BufferedOutputStream out = null;
            boolean success = false;
            try {
                out = new BufferedOutputStream(new FileOutputStream(toFile));
                if (this.support.isCanceled()) {
                    return;
                }
                GitClient client = null;
                this.support.setDisplayName(Bundle.MSG_ShelveChanges_progress_exporting(this.repository.getName()));
                try {
                    client = Git.getInstance().getClient(this.repository);
                    ShelveChangesProgressSupport shelveChangesProgressSupport = this.support;
                    Objects.requireNonNull(shelveChangesProgressSupport);
                    client.addNotificationListener((NotificationListener)shelveChangesProgressSupport.new GitProgressSupport.DefaultFileListener(this.modifications));
                    client.exportDiff(this.modifications, GitClient.DiffMode.HEAD_VS_WORKINGTREE, out, this.support.getProgressMonitor());
                }
                catch (GitException ex) {
                    throw new IOException(ex);
                }
                finally {
                    if (client != null) {
                        client.release();
                    }
                }
                success = true;
            }
            finally {
                if (out != null) {
                    try {
                        out.flush();
                        out.close();
                    }
                    catch (IOException iOException) {}
                    if (success && toFile.length() > 0L) {
                        Utils.openFile((File)toFile);
                    } else {
                        toFile.delete();
                    }
                }
            }
        }

        protected void postExportCleanup() {
            HashSet<File> notifiedFiles = new HashSet<File>();
            if (this.support.isCanceled()) {
                return;
            }
            try {
                GitUtils.runWithoutIndexing(() -> {
                    this.support.setDisplayName(Bundle.MSG_ShelveChanges_progress_reverting(this.repository.getName()));
                    GitClient client = Git.getInstance().getClient(this.repository);
                    client.addNotificationListener((NotificationListener)((FileListener)(file, relativePathToRoot) -> notifiedFiles.add(file)));
                    ShelveChangesProgressSupport shelveChangesProgressSupport = this.support;
                    Objects.requireNonNull(shelveChangesProgressSupport);
                    client.addNotificationListener((NotificationListener)shelveChangesProgressSupport.new GitProgressSupport.DefaultFileListener(this.modifications));
                    client.checkout(this.modifications, this.doRevertIndex ? "HEAD" : null, true, this.support.getProgressMonitor());
                    if (this.doPurge) {
                        client.clean(this.modifications, this.support.getProgressMonitor());
                    }
                    return null;
                }, this.modifications);
            }
            catch (GitException ex) {
                GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
            }
            finally {
                this.support.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
                Git.getInstance().getFileStatusCache().refreshAllRoots(notifiedFiles);
            }
        }

        protected boolean isCanceled() {
            return this.support == null ? false : this.support.isCanceled();
        }

        private void startAsync(RequestProcessor rp, final File repository, final File[] roots) {
            this.support = new ShelveChangesProgressSupport(this){
                final /* synthetic */ GitShelveChangesSupport this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                protected void perform() {
                    this.this$0.modifications = Git.getInstance().getFileStatusCache().listFiles(roots, FileInformation.STATUS_MODIFIED_HEAD_VS_WORKING);
                    File[] arr = Arrays.copyOf(this.this$0.modifications, this.this$0.modifications.length + 1);
                    arr[this.this$0.modifications.length] = repository;
                    this.this$0.shelveChanges(arr);
                }
            };
            this.support.start(rp, repository, Bundle.LBL_ShelveChanges_Progress());
        }

        private boolean open() {
            boolean retval = this.prepare(this.optionsPanel, "org.netbeans.modules.git.ui.shelve.ShelveChangesPanel");
            if (retval) {
                this.doRevertIndex = this.revertModificationInIndex.isSelected();
                this.doPurge = this.doPurgeChxBox.isSelected();
                GitModuleConfig.getDefault().putRemoveWTNew(this.doPurge);
            }
            return retval;
        }
    }

    private static class UnstashMenu {
        private static UnstashMenu instance;

        private UnstashMenu() {
        }

        static synchronized UnstashMenu getInstance() {
            if (instance == null) {
                instance = new UnstashMenu();
            }
            return instance;
        }

        private JComponent[] getMenu(VCSContext context, boolean popup) {
            File root;
            RepositoryInfo info;
            List<GitRevisionInfo> stashes;
            Set<File> actionRoots = GitUtils.getRepositoryRoots(context);
            if (actionRoots.size() == 1 && !(stashes = (info = RepositoryInfo.getInstance(root = actionRoots.iterator().next())).getStashes()).isEmpty()) {
                JMenu menu = new JMenu(popup ? Bundle.CTL_UnstashMenu_name_popup() : Bundle.CTL_UnstashMenu_name());
                Mnemonics.setLocalizedText((AbstractButton)menu, (String)menu.getText());
                ListIterator<Stash> it = Stash.create(root, stashes).listIterator();
                for (int i = 0; it.hasNext() && i < 10; ++i) {
                    Stash stash = it.next();
                    Action a = stash.getApplyAction();
                    String name = Bundle.CTL_UnstashAction_name(stash.getIndex(), stash.getInfo().getShortMessage());
                    if (name.length() > 40) {
                        name = name.substring(0, 40);
                    }
                    a.putValue("Name", name);
                    a.putValue("ShortDescription", stash.getInfo().getShortMessage());
                    JMenuItem item = new JMenuItem(name);
                    if (popup) {
                        Actions.connect((JMenuItem)item, (Action)a, (boolean)true);
                    } else {
                        Actions.connect((AbstractButton)item, (Action)a);
                    }
                    menu.add(item);
                }
                return new JComponent[]{menu};
            }
            return null;
        }
    }

    private static abstract class ShelveChangesProgressSupport
    extends GitProgressSupport {
        private ShelveChangesProgressSupport() {
        }

        @Override
        public void setDisplayName(String displayName) {
            super.setDisplayName(displayName);
        }
    }
}

