/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.actions;

import java.util.concurrent.Callable;
import org.netbeans.libs.git.GitException;
import org.netbeans.modules.git.client.ProgressDelegate;
import org.netbeans.modules.git.ui.actions.ActionProgress;

public abstract class ActionProgressSupport {
    private final GitProgressSupportDelegate delegate;

    protected ActionProgressSupport(GitProgressSupportDelegate delegate) {
        this.delegate = delegate;
    }

    public final void execute() throws GitException {
        Callable<ActionProgress> nextAction = this.getNextAction();
        if (nextAction == null) {
            this.delegate.getProgress().cancel();
        } else {
            try {
                ActionProgress p = nextAction.call();
                if (p.isCanceled()) {
                    this.delegate.getProgress().cancel();
                } else if (p.isError()) {
                    this.delegate.getProgress().setError(true);
                }
            }
            catch (GitException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new GitException((Throwable)ex);
            }
        }
    }

    protected abstract Callable<ActionProgress> getNextAction();

    public static interface GitProgressSupportDelegate {
        public ProgressDelegate getProgress();
    }
}

